/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities.swing.timeedit;

import de.uib.utilities.Globals;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerListModel;

public class TimeEditor
extends JPanel {
    JLabel labelTime;
    JSpinner spinnerHour;
    JSpinner spinnerMin;
    ArrayList hours;
    ArrayList mins;

    public TimeEditor() {
        this(0, 0);
    }

    public TimeEditor(int n, int n2) {
        this.init();
        this.setHour(n);
        this.setMin(n2);
    }

    private String fillTo2Chars(int n) {
        String string = "00";
        if (n < 0 || n > 99) {
            return string;
        }
        string = "" + n;
        if (string.length() == 1) {
            string = "0" + string;
        }
        return string;
    }

    protected void init() {
        int n;
        this.setOpaque(false);
        this.setLayout(new GridLayout(1, 2));
        this.setPreferredSize(new Dimension(250, 22));
        this.labelTime = new JLabel(" hh:mm");
        this.labelTime.setFont(Globals.defaultFontBig);
        this.hours = new ArrayList();
        for (n = 0; n < 24; ++n) {
            this.hours.add(this.fillTo2Chars(n));
        }
        this.spinnerHour = new JSpinner(new SpinnerListModel(this.hours));
        this.mins = new ArrayList();
        for (n = 0; n < 60; ++n) {
            this.mins.add(this.fillTo2Chars(n));
        }
        this.spinnerMin = new JSpinner(new SpinnerListModel(this.mins));
        this.add(this.labelTime);
        this.add(this.spinnerHour);
        this.add(this.spinnerMin);
    }

    public void setHour(int n) {
        this.spinnerHour.getModel().setValue(this.hours.get(n));
    }

    public void setMin(int n) {
        this.spinnerMin.getModel().setValue(this.mins.get(n));
    }

    public int getHour() {
        int n = 0;
        try {
            n = Integer.parseInt((String)this.spinnerHour.getValue());
        }
        catch (Exception exception) {
            System.out.println("Time Editor exception " + this.spinnerHour.getValue() + ", " + exception);
        }
        return n;
    }

    public int getMin() {
        int n = 0;
        try {
            n = Integer.parseInt((String)this.spinnerMin.getValue());
        }
        catch (Exception exception) {
            System.out.println("Time Editor exception  " + this.spinnerMin.getValue() + ", " + exception);
        }
        return n;
    }
}

