/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities.swing;

import de.uib.configed.Globals;
import de.uib.configed.configed;
import de.uib.configed.gui.IconButton;
import de.uib.utilities.logging.logging;
import de.uib.utilities.observer.RunningInstances;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FEditObject
extends JDialog
implements ActionListener,
KeyListener,
DocumentListener {
    public static RunningInstances<JDialog> runningInstances = new RunningInstances(JDialog.class, "leaving dialog");
    public Dimension areaDimension = new Dimension(300, 240);
    protected Object initialValue = "";
    protected boolean leaveOnCommit = true;
    protected JPanel framingPanel;
    protected JPanel editingArea;
    protected JPanel loggingPanel;
    protected JScrollPane scrollpaneL;
    protected JSplitPane splitPane;
    private int splitPaneHMargin = 1;
    protected IconButton buttonCommit;
    protected IconButton buttonCancel;
    protected IconButton buttonAdd;
    protected IconButton buttonRemove;
    protected String tooltipCommit = configed.getResourceValue("FEditObject.SaveButtonTooltip");
    protected boolean dataChanged = false;
    protected boolean editable = true;
    protected boolean finished = false;
    protected int buttonWidth = 30;
    protected JTextField extraField;
    protected JLabel extraLabel;
    protected JTextArea loggingArea;

    public FEditObject(Object object) {
        this.setIconImage(Globals.mainIcon);
        if (object != null) {
            this.initialValue = object;
        }
        this.createComponents();
    }

    protected void createComponents() {
        this.framingPanel = new JPanel();
        this.editingArea = new JPanel(new BorderLayout());
        this.loggingPanel = new JPanel(new BorderLayout());
        this.loggingPanel.setVisible(false);
        this.loggingArea = new JTextArea("");
        this.loggingArea.setEditable(false);
        this.loggingArea.setBackground(Globals.backgroundWhite);
        this.scrollpaneL = new JScrollPane();
        this.scrollpaneL.setViewportView(this.loggingArea);
        this.scrollpaneL.setVerticalScrollBarPolicy(22);
        this.loggingPanel.add((Component)this.scrollpaneL, "Center");
        this.splitPane = new JSplitPane(0);
        this.buttonCommit = new IconButton(configed.getResourceValue("FEditObject.SaveButtonTooltip"), "images/apply.png", "images/apply_over.png", "images/apply_disabled.png", true);
        this.buttonCommit.setPreferredSize(new Dimension(this.buttonWidth, 24));
        this.buttonCancel = new IconButton(configed.getResourceValue("FEditObject.CancelButtonTooltip"), "images/cancel.png", "images/cancel_over.png", "images/cancel_disabled.png", true);
        this.buttonCancel.setPreferredSize(new Dimension(this.buttonWidth, 24));
        this.buttonCancel.setEnabled(true);
        this.buttonRemove = new IconButton(configed.getResourceValue("FEditObject.RemoveButtonTooltip"), "images/list-remove.png", "images/list-remove.png", "images/list-remove_disabled.png", true);
        this.buttonRemove.setPreferredSize(new Dimension(this.buttonWidth, 24));
        this.buttonRemove.setVisible(false);
        this.buttonAdd = new IconButton(configed.getResourceValue("FEditObject.AddButtonTooltip"), "images/list-add.png", "images/list-add.png", "images/list-add_disabled.png", true);
        this.buttonAdd.setPreferredSize(new Dimension(this.buttonWidth, 24));
        this.buttonAdd.setVisible(false);
        this.extraField = new JTextField("");
        this.extraField.setPreferredSize(new Dimension(140, 28));
        this.extraField.setVisible(false);
        this.extraLabel = new JLabel("");
        this.extraLabel.setPreferredSize(new Dimension(140, 28));
        this.extraLabel.setVisible(false);
    }

    public void setDividerLocation(double d) {
        this.splitPane.setDividerLocation(d);
    }

    protected void initComponents() {
        this.framingPanel.setBackground(Globals.backgroundWhite);
        this.setDefaultCloseOperation(1);
        this.editingArea.addKeyListener(this);
        this.buttonCommit.addActionListener(this);
        this.buttonCancel.addActionListener(this);
        this.buttonCommit.addKeyListener(this);
        this.buttonCancel.addKeyListener(this);
        this.buttonRemove.addActionListener(this);
        this.buttonRemove.addKeyListener(this);
        this.buttonAdd.addActionListener(this);
        this.buttonAdd.addKeyListener(this);
        this.extraField.getDocument().addDocumentListener(this);
        GroupLayout groupLayout = new GroupLayout(this.framingPanel);
        this.framingPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(5, 5, 5).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.editingArea, 60, -2, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.buttonCommit, 20, -2, -2).addComponent(this.buttonCancel, 20, -2, -2).addGap(10, 20, 20).addComponent(this.buttonRemove, 20, -2, -2).addComponent(this.buttonAdd, 20, -2, -2).addComponent(this.extraField, 20, -2, Short.MAX_VALUE).addComponent(this.extraLabel, 20, -2, Short.MAX_VALUE))).addGap(5, 5, 5)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.editingArea, -2, -2, Short.MAX_VALUE).addGap(5, 5, 5).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCommit, -2, -2, -2).addComponent(this.buttonCancel, -2, -2, -2).addComponent(this.buttonRemove, -2, -2, -2).addComponent(this.buttonAdd, -2, -2, -2).addComponent(this.extraField, -2, -2, -2).addComponent(this.extraLabel, -2, -2, -2)).addGap(5, 5, 5)));
        if (this.loggingPanel.isVisible()) {
            this.splitPane.setTopComponent(this.framingPanel);
            this.splitPane.setBottomComponent(this.loggingPanel);
            this.add(this.splitPane);
            GroupLayout groupLayout2 = new GroupLayout(this.getContentPane());
            this.setLayout(groupLayout2);
            groupLayout2.setHorizontalGroup(groupLayout2.createSequentialGroup().addGap(this.splitPaneHMargin, this.splitPaneHMargin, this.splitPaneHMargin).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.splitPane, 0, -2, Short.MAX_VALUE)).addContainerGap().addGap(this.splitPaneHMargin, this.splitPaneHMargin, this.splitPaneHMargin));
            groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.splitPane, 0, -2, Short.MAX_VALUE));
        } else {
            GroupLayout groupLayout3 = new GroupLayout(this.getContentPane());
            this.getContentPane().setLayout(groupLayout3);
            groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addComponent(this.framingPanel, 100, -1, Short.MAX_VALUE).addContainerGap()).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addComponent(this.loggingPanel, 100, -2, Short.MAX_VALUE).addContainerGap()));
            groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap(20, 20).addComponent(this.framingPanel, -2, -2, Short.MAX_VALUE).addComponent(this.loggingPanel, -2, 30, Short.MAX_VALUE).addContainerGap(20, 20)));
        }
        this.pack();
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    @Override
    public void setModal(boolean bl) {
        super.setModal(bl);
        logging.debug(this, "setModal " + bl);
        if (bl) {
            this.setAlwaysOnTop(true);
        }
    }

    public void setDataChanged(boolean bl) {
        logging.debug(this, "setDataChanged " + bl);
        if (Globals.isReadOnly() && bl) {
            return;
        }
        this.dataChanged = bl;
        this.buttonCommit.setEnabled(bl);
    }

    public void setStartValue(Object object) {
        this.initialValue = object;
    }

    public Object getValue() {
        return this.initialValue;
    }

    public void setLeaveOnCommit(boolean bl) {
        this.leaveOnCommit = bl;
    }

    private int intHalf(double d) {
        return (int)(d / 2.0);
    }

    public void centerOn(Component component) {
        int n = 0;
        int n2 = 0;
        if (component == null) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            n = (dimension.width - this.getSize().width) / 2;
            n2 = (dimension.height - this.getSize().height) / 2;
        } else {
            Point point = component.getLocationOnScreen();
            n = (int)point.getX() + this.intHalf(component.getWidth()) - this.intHalf(this.getSize().getWidth());
            n2 = (int)point.getY() + this.intHalf(component.getHeight()) - this.intHalf(this.getSize().getHeight());
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            if (n + this.getSize().width > dimension.width) {
                n = dimension.width - this.getSize().width;
            }
            if (n2 + this.getSize().height > dimension.height) {
                n2 = dimension.height - this.getSize().height;
            }
        }
        this.setLocation(n, n2);
    }

    public boolean init(Dimension dimension) {
        if (this.editingArea.getComponentCount() != 1) {
            logging.error(" editing area not filled with component");
            return false;
        }
        this.editingArea.getComponent(0).setPreferredSize(dimension);
        this.initComponents();
        this.initEditing();
        return true;
    }

    private void initEditing() {
        logging.debug(this, "FEditObject.initEditing");
        this.setDataChanged(false);
        this.buttonAdd.setEnabled(false);
        this.buttonRemove.setEnabled(false);
        this.initExtraField();
    }

    public boolean init() {
        return this.init(this.areaDimension);
    }

    public boolean isFinished() {
        return this.finished;
    }

    protected void initExtraField() {
        this.extraField.setText("");
    }

    public void setExtraLabel(String string) {
        this.extraLabel.setVisible(true);
        this.extraLabel.setText(string);
    }

    public void enter() {
        logging.debug(this, "enter");
    }

    public void deactivate() {
        this.leave();
    }

    protected void leave() {
        this.setVisible(false);
        this.finished = true;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            runningInstances.add(this, "");
        } else {
            runningInstances.forget(this);
        }
        super.setVisible(bl);
    }

    @Override
    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.cancel();
        } else if (windowEvent.getID() == 205) {
            this.enter();
        } else if (windowEvent.getID() == 206) {
            // empty if block
        }
        super.processWindowEvent(windowEvent);
    }

    protected void commit() {
        logging.debug(this, "FEditObject.commit");
        if (Globals.isReadOnly()) {
            this.cancel();
        } else {
            this.setStartValue(this.getValue());
            if (this.leaveOnCommit) {
                this.leave();
            }
        }
    }

    protected void cancel() {
        this.setStartValue(this.initialValue);
        this.leave();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        logging.debug(this, "actionPerformed" + actionEvent);
        if (actionEvent.getSource() == this.buttonCommit) {
            this.commit();
        } else if (actionEvent.getSource() == this.buttonCancel) {
            this.cancel();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.commit();
        } else if (keyEvent.getKeyCode() == 27) {
            this.cancel();
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    protected void extraFieldChanged(boolean bl) {
        this.buttonAdd.setEnabled(bl);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.extraFieldChanged(true);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.extraFieldChanged(true);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.extraFieldChanged(true);
    }
}

