/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities.datapanel;

import de.uib.configed.configed;
import de.uib.utilities.DataChangedObserver;
import de.uib.utilities.DataChangedSubject;
import de.uib.utilities.datapanel.ListModelProducerForVisualDatamap;
import de.uib.utilities.logging.logging;
import de.uib.utilities.table.ListCellOptions;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class MapTableModel
extends AbstractTableModel
implements DataChangedSubject {
    protected Vector<DataChangedObserver> observers = new Vector();
    protected Collection updateCollection;
    protected Collection<Map<String, Object>> storeData;
    protected boolean datachanged;
    private List<Object> showOnlyValues;
    private Set<String> keysOfReadOnlyEntries;
    public static final List nullLIST = new ArrayList();
    protected Map<String, ListCellOptions> optionsMap;
    private SortedMap<String, Object> data;
    private Map<String, Object> oridata;
    private Vector<String> keys;
    private ListModelProducerForVisualDatamap modelProducer;
    private boolean writeData = true;

    public void setModelProducer(ListModelProducerForVisualDatamap listModelProducerForVisualDatamap) {
        this.modelProducer = listModelProducerForVisualDatamap;
    }

    public void setOptions(Map<String, ListCellOptions> map) {
        this.optionsMap = map;
    }

    public void setMap(Map<String, Object> map) {
        this.data = null;
        if (map != null) {
            Collator collator = Collator.getInstance();
            collator.setStrength(0);
            this.data = Collections.synchronizedSortedMap(new TreeMap(collator));
            this.data.putAll(map);
            this.keys = new Vector<String>(this.data.keySet());
        }
        this.oridata = map;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    private void setNew() {
        this.datachanged = false;
    }

    public Vector<String> getKeys() {
        return this.keys;
    }

    public void setStoreData(Collection<Map<String, Object>> collection) {
        logging.debug(this, "setStoreData " + collection);
        this.setNew();
        this.storeData = collection;
    }

    public Collection<Map<String, Object>> getStoreData() {
        return this.storeData;
    }

    public void setUpdateCollection(Collection collection) {
        this.updateCollection = collection;
    }

    public Collection getUpdateCollection() {
        return this.updateCollection;
    }

    public void setReadOnlyEntries(Set<String> set) {
        this.keysOfReadOnlyEntries = set;
    }

    public void setShowOnlyValues(List<Object> list) {
        this.showOnlyValues = list;
    }

    public List<Object> getShowOnlyValues() {
        return this.showOnlyValues;
    }

    public void addEntry(String string, Object object) {
        this.data.put(string, object);
        this.oridata.put(string, object);
        logging.debug(this, " keys " + this.keys);
        this.keys = new Vector<String>(this.data.keySet());
        logging.debug(this, " new keys  " + this.keys);
        this.putEntryIntoStoredMaps(string, object);
        this.fireTableDataChanged();
    }

    public void addEntry(String string) {
        ArrayList arrayList = new ArrayList();
        this.data.put(string, arrayList);
        this.oridata.put(string, arrayList);
        this.keys = new Vector<String>(this.data.keySet());
        this.putEntryIntoStoredMaps(string, arrayList);
        this.fireTableDataChanged();
    }

    public void removeEntry(String string) {
        this.data.remove(string);
        this.oridata.remove(string);
        this.keys = new Vector<String>(this.data.keySet());
        this.removeEntryFromStoredMaps(string);
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        int n = 0;
        if (this.data != null) {
            n = this.keys.size();
        }
        return n;
    }

    @Override
    public String getColumnName(int n) {
        String string = "";
        switch (n) {
            case 0: {
                string = configed.getResourceValue("EditMapPanel.ColumnHeaderName");
                break;
            }
            case 1: {
                string = configed.getResourceValue("EditMapPanel.ColumnHeaderValue");
            }
        }
        return string;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.data == null) {
            return "";
        }
        String string = null;
        switch (n2) {
            case 0: {
                try {
                    string = this.keys.get(n);
                }
                catch (Exception exception) {
                    logging.info(this, "keys " + this.keys + " row " + n);
                    string = "";
                }
                break;
            }
            case 1: {
                string = this.data.get(this.keys.get(n));
            }
        }
        return string;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: {
                return "".getClass();
            }
            case 1: {
                return List.class;
            }
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.data == null) {
            return false;
        }
        if (n2 < 1) {
            return false;
        }
        return this.keysOfReadOnlyEntries == null || !this.keysOfReadOnlyEntries.contains(this.keys.get(n));
    }

    void weHaveChangedStoredMaps() {
        if (!this.datachanged || this.updateCollection.size() == 0) {
            this.datachanged = true;
            this.notifyChange();
            if (this.updateCollection == null) {
                logging.debug(this, "updateCollection null - should not be");
            } else {
                this.updateCollection.addAll(this.storeData);
            }
        }
    }

    void removeEntryFromStoredMaps(String string) {
        if (this.storeData != null) {
            for (Map<String, Object> map : this.storeData) {
                map.put(string, nullLIST);
            }
            this.weHaveChangedStoredMaps();
        }
    }

    void putEntryIntoStoredMaps(String string, Object object) {
        logging.debug(this, "putEntryIntoStoredMaps myKey, value: " + string + ", " + object);
        if (this.storeData != null) {
            for (Map<String, Object> map : this.storeData) {
                if (!(map instanceof Map)) {
                    if (map == null) {
                        logging.info(this, "EditMapPanel.setValueAt: we have some data null ");
                        continue;
                    }
                    logging.error(this, "EditMapPanel.setValueAt: backendData " + map + " is not null and not a Map ");
                    continue;
                }
                map.put(string, object);
            }
            this.weHaveChangedStoredMaps();
        }
    }

    public void setWrite() {
        this.writeData = true;
    }

    public void unsetWrite() {
        this.writeData = false;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (object == null) {
            logging.debug(this, "call set value in table at " + n + "," + n2 + " to null");
            return;
        }
        logging.debug(this, "Setting value in table at " + n + "," + n2 + " to " + object + " (an instance of " + object.getClass() + ")");
        if (!this.getValueAt(n, n2).equals(object) && !this.getValueAt(n, n2).toString().equals(object.toString()) && n2 == 1 && this.keys != null) {
            String string = this.keys.get(n);
            Object object2 = object;
            this.data.put(string, object2);
            this.oridata.put(string, object2);
            logging.debug(this, "put into oridata for myKey o " + string + ": " + object2);
            this.modelProducer.updateData(this.oridata);
            if (this.writeData) {
                logging.debug(this, " -------  storeData " + object + " (class : " + object.getClass());
                this.putEntryIntoStoredMaps(string, object);
            }
        }
        this.fireTableCellUpdated(n, n2);
    }

    public void setValue(String string, Object object) {
        List list;
        int n = this.keys.indexOf(string);
        if (n < 0) {
            logging.error("key not valid: " + string);
            return;
        }
        if (this.optionsMap.get(string) != null && this.optionsMap.get(string) instanceof List && (list = (List)((Object)this.optionsMap.get(string))).size() > 0 && list.indexOf(object) == -1) {
            logging.error("EditMapPanel: value not allowed: " + object);
            return;
        }
        this.setValueAt(object, n, 1);
    }

    @Override
    public void registerDataChangedObserver(DataChangedObserver dataChangedObserver) {
        this.observers.addElement(dataChangedObserver);
    }

    Vector<DataChangedObserver> getObservers() {
        return this.observers;
    }

    void setObservers(Vector<DataChangedObserver> vector) {
        this.observers = vector;
    }

    public void notifyChange() {
        logging.debug(this, "notifyChange, notify observers " + this.observers.size());
        for (int i = 0; i < this.observers.size(); ++i) {
            this.observers.elementAt(i).dataHaveChanged(this);
        }
    }

    static {
        nullLIST.add(null);
    }
}

