/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities;

import de.uib.utilities.Globals;
import de.uib.utilities.logging.logging;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

public class Mapping<K, V> {
    protected Map<K, V> map = new HashMap();
    protected Map<String, V> mapOfStrings;
    protected boolean invertible;
    protected Map<V, K> inverseMap = new HashMap<V, K>();
    protected Vector<K> domain = new Vector();
    protected Vector<V> range = new Vector();
    protected Vector<String> rangeAsStrings;

    public Mapping() {
        this(null);
    }

    public Mapping(Map<K, V> map) {
        this.mapOfStrings = new HashMap<String, V>();
        this.rangeAsStrings = new Vector();
        this.defineBy(map);
    }

    public void clear() {
        this.map.clear();
        this.inverseMap.clear();
        this.domain.clear();
        this.range.clear();
        this.mapOfStrings.clear();
        this.invertible = true;
    }

    public Map<K, V> getMap() {
        return this.map;
    }

    public Map<V, K> getInverseMap() {
        return this.inverseMap;
    }

    public Map<String, V> getMapOfStrings() {
        return this.mapOfStrings;
    }

    public boolean isInvertible() {
        return this.invertible;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Vector<K> getDomain() {
        return this.domain;
    }

    public TreeSet<K> getDomainNaturallyOrdered() {
        return new TreeSet<K>(this.domain);
    }

    public TreeSet<String> getDomainAsStringsCollated() {
        TreeSet<Object> treeSet = new TreeSet<Object>(Globals.getCollator());
        treeSet.addAll(this.mapOfStrings.keySet());
        return treeSet;
    }

    public Vector<V> getRange() {
        return this.range;
    }

    public TreeSet<V> getRangeNaturallyOrdered() {
        return new TreeSet<V>(this.range);
    }

    public TreeSet<String> getRangeAsStringsCollated() {
        TreeSet<Object> treeSet = new TreeSet<Object>(Globals.getCollator());
        treeSet.addAll(this.rangeAsStrings);
        return treeSet;
    }

    public void addPair(K k, V v) {
        this.domain.add(k);
        this.range.add(v);
        this.rangeAsStrings.add("" + v);
        this.mapOfStrings.put("" + k, v);
        if (this.invertible) {
            if (this.inverseMap.get(v) != null) {
                this.invertible = false;
            } else {
                this.inverseMap.put(v, k);
            }
        }
    }

    public void defineBy(Map<K, V> map) {
        this.clear();
        if (map == null) {
            return;
        }
        this.map = map;
        for (K k : this.map.keySet()) {
            V v = this.map.get(k);
            if (v == null) {
                logging.info(this, " " + k + " mapped to null in map " + map);
                continue;
            }
            this.addPair(k, v);
        }
    }

    public Mapping<K, V> restrictedTo(Set<K> set) {
        HashMap<K, V> hashMap = new HashMap<K, V>();
        for (K k : set) {
            if (!this.domain.contains(k)) continue;
            hashMap.put(k, this.map.get(k));
        }
        return new Mapping(hashMap);
    }

    public String toString() {
        return "de.uib.utilities.Mapping defined by Map " + this.map;
    }
}

