/*
 * Decompiled with CFR 0.152.
 */
package de.uib.opsicommand.sshcommand;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import de.uib.configed.ConfigedMain;
import de.uib.configed.configed;
import de.uib.configed.gui.ssh.SSHConnectionTerminalDialog;
import de.uib.opsicommand.sshcommand.SSHConnect;
import de.uib.utilities.logging.logging;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import javax.swing.JTextField;

public class SSHConnectTerminal
extends SSHConnect {
    private JSch jsch = null;
    Session session = null;
    private SSHConnectionTerminalDialog dialog;
    private OutputStream out = null;

    public SSHConnectTerminal(ConfigedMain configedMain) {
        super(configedMain);
        this.connect();
    }

    @Override
    public void connect() {
        try {
            this.jsch = new JSch();
            this.checkUserData();
            this.session = this.jsch.getSession(user, host, 22);
            this.session.setPassword(password);
            this.dialog = new SSHConnectionTerminalDialog(configed.getResourceValue("SSHConnection.Terminal.title") + " " + user + "@" + host);
            this.dialog.append(configed.getResourceValue("SSHConnection.Terminal.note") + "\n\n", this.dialog.getInputField());
            this.session.setConfig("StrictHostKeyChecking", "no");
            this.session.connect();
            Channel channel = this.session.openChannel("shell");
            channel.setOutputStream(new MyOutputStream(this.dialog));
            PipedInputStream pipedInputStream = new PipedInputStream();
            this.out = new PipedOutputStream(pipedInputStream);
            channel.setInputStream(pipedInputStream);
            channel.connect();
            logging.info(this, "connect " + user + "@" + host);
            this.dialog.getInputField().addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    int n = keyEvent.getKeyCode();
                    JTextField jTextField = (JTextField)keyEvent.getSource();
                    if (jTextField.getText().trim().toLowerCase().equals("exit")) {
                        if (n == 10) {
                            SSHConnectTerminal.this.dialog.cancel();
                        }
                        ((Component)jTextField).requestFocusInWindow();
                    } else if (jTextField.getText().trim().toLowerCase().equals("clear")) {
                        if (n == 10) {
                            SSHConnectTerminal.this.clear();
                        }
                        ((Component)jTextField).requestFocusInWindow();
                    } else if (n == 10) {
                        String string = SSHConnectTerminal.this.dialog.getInputField().getText() + "\n";
                        SSHConnectTerminal.this.exec(string);
                        ((Component)jTextField).requestFocusInWindow();
                        SSHConnectTerminal.this.dialog.getInputField().setText("");
                    } else if (n == 38 || n == 224) {
                        SSHConnectTerminal.this.dialog.getInputField().setText(SSHConnectTerminal.this.dialog.getPrevCommand_up());
                        ((Component)jTextField).requestFocusInWindow();
                    } else if (n == 40 || n == 225) {
                        SSHConnectTerminal.this.dialog.getInputField().setText(SSHConnectTerminal.this.dialog.getPrevCommand_down());
                        ((Component)jTextField).requestFocusInWindow();
                    }
                }

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                }
            });
            logging.info(this, "SSHConnectTerminal connected");
        }
        catch (Exception exception) {
            logging.error(this, "connect " + exception);
            exception.printStackTrace();
        }
    }

    public final void exec(String string) {
        try {
            if (this.out != null && string.trim().length() > 0) {
                this.out.write(string.getBytes());
                if (this.dialog.getPrivateStatus()) {
                    this.dialog.setPrivate(false);
                } else {
                    logging.debug(this, " exec " + string);
                    this.dialog.addToHistory(string.trim());
                }
                this.out.write("\n".getBytes());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public final void clear() {
        this.dialog.getOutputField().setText("");
        this.dialog.getInputField().setText("");
        try {
            this.out.write("\n".getBytes());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    class MyOutputStream
    extends OutputStream {
        SSHConnectionTerminalDialog theDialog;
        StringBuilder sb = new StringBuilder();

        MyOutputStream(SSHConnectionTerminalDialog sSHConnectionTerminalDialog) {
            this.theDialog = sSHConnectionTerminalDialog;
        }

        @Override
        public void write(int n) throws IOException {
            if (n == 10) {
                String string = this.sb.toString() + "\n";
                this.theDialog.append(string, this.theDialog.getInputField());
                this.sb.setLength(0);
                return;
            }
            this.sb.append((char)n);
        }
    }
}

