/*
 * Decompiled with CFR 0.152.
 */
package de.uib.opsicommand.sshcommand;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import de.uib.configed.ConfigedMain;
import de.uib.configed.Globals;
import de.uib.configed.configed;
import de.uib.opsicommand.sshcommand.SSHCommand;
import de.uib.utilities.logging.logging;
import java.awt.Component;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;

public class SSHConnect {
    protected static String host;
    protected static String user;
    protected static String password;
    protected String pw_sudo;
    protected String pw_root;
    private JSch jsch = null;
    protected Session session = null;
    ConfigedMain main;

    public SSHConnect(ConfigedMain configedMain) {
        this.main = configedMain;
    }

    protected boolean isNotError(String string) {
        return string.compareTo("error") != 0;
    }

    protected void showMessage(String string) {
        JOptionPane.showMessageDialog(null, string);
        logging.info(this, "show message: " + string);
    }

    protected boolean isConnected() {
        return this.session != null && this.session.isConnected();
    }

    protected String getSudoPass() {
        return this.getSudoPass(null);
    }

    protected String getSudoPass(Component component, boolean bl) {
        logging.debug(this, "getSudoPass 1");
        if (!bl && this.pw_sudo != null) {
            return this.pw_sudo;
        }
        return this.getSudoPass(component);
    }

    protected String getSudoPass(Component component) {
        if (component == null) {
            component = Globals.mainFrame;
        }
        logging.debug(this, "getSudoPass 2");
        final JPasswordField jPasswordField = new JPasswordField(10);
        jPasswordField.setEchoChar('*');
        JOptionPane jOptionPane = new JOptionPane(new Object[]{new JLabel(configed.getResourceValue("SSHConnection.sudoPassw1")), new JLabel(configed.getResourceValue("SSHConnection.sudoPassw2")), jPasswordField}, 3, 2){

            @Override
            public void selectInitialValue() {
                super.selectInitialValue();
                ((Component)jPasswordField).requestFocusInWindow();
            }
        };
        JDialog jDialog = jOptionPane.createDialog(component, configed.getResourceValue("SSHConnection.Config.jLabelPassword"));
        jDialog.setVisible(true);
        this.pw_sudo = String.valueOf(jPasswordField.getPassword());
        return this.pw_sudo;
    }

    protected void checkUserData() {
        if (host == null) {
            host = ConfigedMain.HOST;
        }
        if (user == null) {
            user = ConfigedMain.USER;
        }
        if (password == null) {
            password = ConfigedMain.PASSWORD;
        }
        logging.debug(this, "checkUserData user " + user + " host " + host);
    }

    public static void setUserData(String string, String string2, String string3) {
        host = string;
        user = string2;
        password = string3;
    }

    public void connect() {
        this.connect(null);
    }

    public boolean connect(SSHCommand sSHCommand) {
        if (sSHCommand != null) {
            logging.info(this, "connect command " + sSHCommand.getName());
        } else {
            logging.info(this, "connect command null");
        }
        try {
            this.jsch = new JSch();
            this.checkUserData();
            this.session = this.jsch.getSession(user, host, 22);
            this.session.setPassword(password);
            this.session.setConfig("StrictHostKeyChecking", "no");
            this.session.connect();
            logging.debug(this, "connect " + user + "@" + host);
        }
        catch (JSchException jSchException) {
            logging.error(this, "connect Authentication failed. " + jSchException);
            return false;
        }
        catch (Exception exception) {
            logging.error(this, "connect Exception " + exception);
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    protected Session getSession() {
        return this.session;
    }

    public void disconnect() {
        if (this.isConnected()) {
            this.session.disconnect();
        }
        logging.debug(this, "disconnect");
    }
}

