/*
 * Decompiled with CFR 0.152.
 */
package de.uib.opsicommand.sshcommand;

import de.uib.configed.ConfigedMain;
import de.uib.configed.configed;
import de.uib.configed.gui.GeneralFrame;
import de.uib.configed.gui.ssh.SSHConnectionExecDialog;
import de.uib.configed.gui.ssh.SSHWgetParameterDialog;
import de.uib.opsicommand.sshcommand.CommandHelp;
import de.uib.opsicommand.sshcommand.SSHCommand;
import de.uib.opsicommand.sshcommand.SSHCommandNeedParameter;
import de.uib.utilities.logging.logging;

public class CommandWget
implements SSHCommand,
SSHCommandNeedParameter {
    private String baseName = "wget ";
    private String command = "wget ";
    protected GeneralFrame frame = null;
    private boolean needSudo = false;
    private boolean needRoot = false;
    private boolean needParameter = true;
    private boolean isMultiCommand = false;
    private int helpColumns = 2;
    private String url = "";
    private String dir = "";
    private String product = "";
    private String verbosity = "";
    private String freeInput = "";

    public CommandWget() {
        this.command = "wget ";
    }

    public CommandWget(String string, String string2) {
        this.setVerbosity(1);
        this.setDir(string);
        this.setUrl(string2);
        if (string.charAt(string.length() - 1) != '/') {
            string = string + "/";
        }
        this.setProduct(string + this.getFilenameFromUrl(this.url));
        logging.info(this, "CommandWget dir " + this.dir);
        logging.info(this, "CommandWget url " + this.url);
        logging.info(this, "CommandWget product " + this.getProduct());
        this.needParameter = false;
    }

    @Override
    public boolean isMultiCommand() {
        return this.isMultiCommand;
    }

    @Override
    public String getName() {
        return "CommandWget";
    }

    @Override
    public String getBasicName() {
        return this.baseName;
    }

    @Override
    public String getMenuText() {
        return configed.getResourceValue("SSHConnection.command.wget");
    }

    @Override
    public String getToolTipText() {
        return configed.getResourceValue("SSHConnection.command.wget.tooltip");
    }

    @Override
    public String getCommand() {
        this.command = "wget " + this.verbosity + this.dir + this.url;
        if (this.needSudo()) {
            return configed.getResourceValue("SSHConnection.sudoText") + " " + this.command + " 2>&1";
        }
        return this.command + " 2>&1";
    }

    @Override
    public boolean needSudo() {
        return this.needSudo;
    }

    @Override
    public String getSudoText() {
        return configed.getResourceValue("SSHConnection.sudoText");
    }

    @Override
    public int getHelpColumns() {
        return this.helpColumns;
    }

    @Override
    public boolean needUserRoot() {
        return this.needRoot;
    }

    @Override
    public boolean needParameter() {
        return this.needParameter;
    }

    @Override
    public void startParameterGui() {
        this.frame = new SSHWgetParameterDialog();
    }

    @Override
    public void startParameterGui(ConfigedMain configedMain) {
        this.frame = new SSHWgetParameterDialog(configedMain);
    }

    @Override
    public SSHConnectionExecDialog startHelpDialog() {
        CommandHelp commandHelp = new CommandHelp(this);
        return new SSHConnectionExecDialog(commandHelp, configed.getResourceValue("SSHConnection.Exec.title") + " \"" + commandHelp.getCommand() + "\" ");
    }

    @Override
    public GeneralFrame getDialog() {
        return this.frame;
    }

    public void setDir(String string) {
        this.dir = string != "" ? " -P " + string : "";
    }

    public void setUrl(String string) {
        this.url = string != "" ? " " + string : "";
    }

    public void setVerbosity(int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + "v";
        }
        this.verbosity = " -" + string + " ";
        if (n == 0) {
            this.verbosity = "";
        }
    }

    public void setFreeInput(String string) {
        this.freeInput = " " + string;
    }

    public void setProduct(String string) {
        this.product = " " + string;
    }

    public String getProduct() {
        return this.product;
    }

    public boolean checkCommand() {
        if (this.dir == "") {
            return false;
        }
        return this.url != "";
    }

    private String getFilenameFromUrl(String string) {
        int n = string.lastIndexOf("/");
        String string2 = string.substring(n + 1);
        return string2;
    }
}

