/*
 * Decompiled with CFR 0.152.
 */
package de.uib.opsicommand.sshcommand;

import de.uib.configed.ConfigedMain;
import de.uib.configed.configed;
import de.uib.configed.gui.GeneralFrame;
import de.uib.configed.gui.ssh.SSHConnectionExecDialog;
import de.uib.configed.gui.ssh.SSHDeployClientAgentParameterDialog;
import de.uib.opsicommand.sshcommand.CommandHelp;
import de.uib.opsicommand.sshcommand.SSHCommand;
import de.uib.opsicommand.sshcommand.SSHCommandNeedParameter;

public class CommandDeployClientAgent
implements SSHCommand,
SSHCommandNeedParameter {
    private String command = this.baseName;
    private String baseName = "/var/lib/opsi/depot/opsi-client-agent/opsi-deploy-client-agent";
    protected GeneralFrame frame = null;
    private boolean needSudo = true;
    private boolean needRoot = false;
    private boolean needParameter = true;
    private boolean isMultiCommand = false;
    private int helpColumns = 2;
    private String client = "";
    private String user = "";
    private String passw = "";
    private String keepClientOnFailure = "";
    private String verbosity = "";

    @Override
    public String getName() {
        return "CommandDeployClientAgent";
    }

    @Override
    public String getBasicName() {
        return this.baseName;
    }

    @Override
    public boolean isMultiCommand() {
        return this.isMultiCommand;
    }

    @Override
    public String getMenuText() {
        return configed.getResourceValue("SSHConnection.command.deploy-clientagent");
    }

    @Override
    public String getToolTipText() {
        return configed.getResourceValue("SSHConnection.command.deploy-clientagent.tooltip");
    }

    @Override
    public String getCommand() {
        this.command = "/var/lib/opsi/depot/opsi-client-agent/opsi-deploy-client-agent " + this.verbosity + this.user + this.passw + this.keepClientOnFailure + this.client;
        if (this.needSudo()) {
            return configed.getResourceValue("SSHConnection.sudoText") + " " + this.command + " 2>&1";
        }
        return this.command + " 2>&1";
    }

    @Override
    public boolean needSudo() {
        return this.needSudo;
    }

    @Override
    public String getSudoText() {
        return configed.getResourceValue("SSHConnection.sudoText");
    }

    @Override
    public boolean needUserRoot() {
        return this.needRoot;
    }

    @Override
    public boolean needParameter() {
        return this.needParameter;
    }

    @Override
    public void startParameterGui() {
        this.frame = new SSHDeployClientAgentParameterDialog();
    }

    @Override
    public void startParameterGui(ConfigedMain configedMain) {
        this.frame = new SSHDeployClientAgentParameterDialog(configedMain);
    }

    @Override
    public SSHConnectionExecDialog startHelpDialog() {
        CommandHelp commandHelp = new CommandHelp(this);
        return new SSHConnectionExecDialog(commandHelp, configed.getResourceValue("SSHConnection.Exec.title") + " \"" + commandHelp.getCommand() + "\" ");
    }

    @Override
    public GeneralFrame getDialog() {
        return this.frame;
    }

    @Override
    public int getHelpColumns() {
        return this.helpColumns;
    }

    public void setClient(String string) {
        this.client = string != "" ? " " + string : "";
    }

    public void setUser(String string) {
        this.user = string != "" ? " -u " + string : "";
    }

    public void setVerbosity(int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + "v";
        }
        this.verbosity = " -" + string + " ";
        if (n == 0) {
            this.verbosity = "";
        }
    }

    public void setPassw(String string) {
        this.passw = string != "" ? " -p " + string : "";
    }

    public void setKeepClient(boolean bl) {
        this.keepClientOnFailure = bl ? " --keep-client-on-failure " : "";
    }

    public boolean checkCommand() {
        if (this.client == "") {
            return false;
        }
        return this.passw != "";
    }
}

