/*
 * Decompiled with CFR 0.152.
 */
package de.uib.connectx;

import de.uib.opsidatamodel.PersistenceController;
import de.uib.opsidatamodel.PersistenceControllerFactory;
import de.uib.utilities.logging.logging;
import java.io.File;
import java.util.Map;

public class SmbConnect {
    public static final String[] directoryProducts = new String[]{"var", "lib", "opsi", "depot"};
    public static final String PRODUCT_SHARE_RW = "opsi_depot_rw";
    public static final String directoryPE = "winpe";
    public static final String directoryI386 = "i386";
    public static final String directoryInstallFiles = "installfiles";
    public static final String[] DIRECTORY_DRIVERS = new String[]{"drivers", "drivers"};
    public static final String[] DIRECTORY_DRIVERS_PREFERRED = new String[]{"drivers", "drivers", "preferred"};
    public static final String[] DIRECTORY_DRIVERS_EXCLUDED = new String[]{"drivers", "drivers", "excluded"};
    public static final String[] DIRECTORY_DRIVERS_ADDITIONAL = new String[]{"drivers", "drivers", "additional"};
    public static final String[] DIRECTORY_DRIVERS_BY_AUDIT = new String[]{"drivers", "drivers", "additional", "byAudit"};
    private static SmbConnect instance;
    protected PersistenceController persist = PersistenceControllerFactory.getPersistenceController();

    private SmbConnect() {
    }

    public static SmbConnect getInstance() {
        if (instance == null) {
            instance = new SmbConnect();
        }
        return instance;
    }

    public static String unixPath(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length - 1; ++i) {
                stringBuffer.append(stringArray[i]);
                stringBuffer.append("/");
            }
            if (stringArray.length - 1 > 0) {
                stringBuffer.append(stringArray[stringArray.length - 1]);
            }
        }
        return stringBuffer.toString();
    }

    public String buildSambaTarget(String string, String string2) {
        String string3 = "";
        Map<String, Map<String, Object>> map = this.persist.getHostInfoCollections().getDepots();
        logging.info(this, "buildSambaTarget for depotserver " + string);
        if (map.get(string) == null) {
            return string3;
        }
        String string4 = (String)map.get(string).get("depotRemoteUrl");
        if (string4 == null) {
            logging.warning(this, "buildSambaTarget, depotRemoteUrl null");
            return string3;
        }
        String[] stringArray = string4.split("/");
        String string5 = "";
        if (stringArray.length > 2) {
            string5 = stringArray[2];
            logging.info(this, "buildSambaTarget " + string5);
        } else {
            logging.warning(this, "buildSambaTarget, no splitting for " + string4);
        }
        string3 = File.separator + File.separator + string5 + File.separator + string2;
        logging.info(this, "buildSambaTarget " + string3);
        return string3;
    }
}

