/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.gui.ssh;

import de.uib.configed.ConfigedMain;
import de.uib.configed.Globals;
import de.uib.configed.configed;
import de.uib.configed.gui.GeneralFrame;
import de.uib.configed.gui.ssh.SSHConnectionExecDialog;
import de.uib.opsicommand.sshcommand.CommandWget;
import de.uib.opsicommand.sshcommand.SSHConnectExec;
import de.uib.utilities.logging.logging;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SSHWgetParameterDialog
extends GeneralFrame {
    private GroupLayout layout;
    private JPanel inputPanel = new JPanel();
    private JPanel buttonPanel = new JPanel();
    private JLabel lbl_url = new JLabel();
    private JLabel lbl_dir = new JLabel();
    private JLabel lbl_verbosity = new JLabel();
    private JLabel lbl_freeInput = new JLabel();
    private JLabel lbl_fullCommand = new JLabel();
    private JButton btn_help;
    private JButton btn_execute;
    private JButton btn_execute_close;
    private JButton btn_close;
    private JTextField tf_url;
    private JTextField tf_dir;
    private JComboBox cb_dir;
    private JComboBox cb_verbosity;
    private JTextField tf_freeInput;
    private final int frameLength = 700;
    private final int frameHight = 250;
    private ConfigedMain main;
    CommandWget commandWget = new CommandWget();

    public SSHWgetParameterDialog() {
        this((ConfigedMain)null);
    }

    public SSHWgetParameterDialog(ConfigedMain configedMain) {
        super((Frame)null, configed.getResourceValue("SSHConnection.ParameterDialog.wget.title"), false);
        this.main = configedMain;
        this.init();
        this.initLayout();
        this.pack();
        this.centerOn(Globals.mainFrame);
        this.setBackground(Globals.backLightBlue);
        this.setSize(700, 250);
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    private void init() {
        this.inputPanel.setBackground(Globals.backLightBlue);
        this.buttonPanel.setBackground(Globals.backLightBlue);
        this.getContentPane().add((Component)this.inputPanel, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.buttonPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.inputPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.inputPanel.setPreferredSize(new Dimension(376, 220));
        this.lbl_url.setText(configed.getResourceValue("SSHConnection.ParameterDialog.wget.jLabelUrl"));
        this.tf_url = new JTextField();
        this.tf_url.setText(configed.getResourceValue("SSHConnection.ParameterDialog.wget.tooltip.tf_wget_url"));
        this.tf_url.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                SSHWgetParameterDialog.this.changeUrl();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                SSHWgetParameterDialog.this.changeUrl();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                SSHWgetParameterDialog.this.changeUrl();
            }
        });
        this.lbl_dir.setText(configed.getResourceValue("SSHConnection.ParameterDialog.wget.jLabelDirectory"));
        this.tf_dir = new JTextField();
        this.tf_dir.setText(configed.getResourceValue("SSHConnection.ParameterDialog.wget.tooltip.tf_wget_dir"));
        this.tf_dir.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                SSHWgetParameterDialog.this.changeDir();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                SSHWgetParameterDialog.this.changeDir();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                SSHWgetParameterDialog.this.changeDir();
            }
        });
        this.lbl_verbosity.setText(configed.getResourceValue("SSHConnection.ParameterDialog.jLabelVerbosity"));
        this.cb_verbosity = new JComboBox();
        this.cb_verbosity.setToolTipText(configed.getResourceValue("SSHConnection.ParameterDialog.tooltip.verbosity"));
        for (int i = 0; i < 5; ++i) {
            this.cb_verbosity.addItem(i);
        }
        this.cb_verbosity.setSelectedItem(1);
        this.cb_verbosity.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SSHWgetParameterDialog.this.commandWget.setVerbosity((Integer)SSHWgetParameterDialog.this.cb_verbosity.getSelectedItem());
                SSHWgetParameterDialog.this.updateCommand();
            }
        });
        this.lbl_freeInput.setText(configed.getResourceValue("SSHConnection.ParameterDialog.jLabelFreeInput"));
        this.tf_freeInput = new JTextField();
        this.tf_freeInput.setToolTipText(configed.getResourceValue("SSHConnection.ParameterDialog.tooltip.freeInput"));
        this.tf_freeInput.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                SSHWgetParameterDialog.this.changeFreeInput();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                SSHWgetParameterDialog.this.changeFreeInput();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                SSHWgetParameterDialog.this.changeFreeInput();
            }
        });
        this.btn_help = new JButton("", Globals.createImageIcon("images/help.gif", ""));
        this.btn_help.setText(configed.getResourceValue("SSHConnection.buttonHelp"));
        this.buttonPanel.add(this.btn_help);
        this.btn_help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SSHWgetParameterDialog.this.doActionHelp();
            }
        });
        this.btn_execute = new JButton();
        this.buttonPanel.add(this.btn_execute);
        this.btn_execute.setText(configed.getResourceValue("SSHConnection.buttonExec"));
        this.btn_execute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SSHWgetParameterDialog.this.doAction1();
            }
        });
        this.btn_execute_close = new JButton();
        this.buttonPanel.add(this.btn_execute_close);
        this.btn_execute_close.setText(configed.getResourceValue("SSHConnection.buttonExecClose"));
        this.btn_execute_close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SSHWgetParameterDialog.this.doAction1();
                SSHWgetParameterDialog.this.doAction2();
            }
        });
        this.btn_close = new JButton();
        this.buttonPanel.add(this.btn_close);
        this.btn_close.setText(configed.getResourceValue("SSHConnection.buttonClose"));
        this.btn_close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SSHWgetParameterDialog.this.doAction2();
            }
        });
        this.lbl_fullCommand.setText("wget ");
        this.changeDir();
        this.changeUrl();
        this.changeFreeInput();
    }

    private void updateCommand() {
        this.lbl_fullCommand.setText(this.commandWget.getCommand());
    }

    private void changeFreeInput() {
        if (this.tf_freeInput.getText().trim() != "") {
            this.commandWget.setFreeInput(this.tf_freeInput.getText().trim());
        } else {
            this.commandWget.setFreeInput("");
        }
        this.updateCommand();
    }

    private void changeDir() {
        if (!this.tf_dir.getText().equals("")) {
            this.commandWget.setDir(this.tf_dir.getText().trim());
        } else {
            this.commandWget.setDir("");
        }
        this.updateCommand();
    }

    private void changeUrl() {
        if (!this.tf_url.getText().equals("")) {
            this.commandWget.setUrl(this.tf_url.getText().trim());
        } else {
            this.commandWget.setUrl("");
        }
        this.updateCommand();
    }

    @Override
    protected void doAction1() {
        if (this.commandWget.checkCommand()) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        logging.info(this, "doAction1 wget ");
                        SSHConnectExec sSHConnectExec = new SSHConnectExec(SSHWgetParameterDialog.this.commandWget);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }.start();
        }
    }

    protected void doActionHelp() {
        SSHConnectionExecDialog sSHConnectionExecDialog = this.commandWget.startHelpDialog();
        sSHConnectionExecDialog.setVisible(true);
    }

    protected void doAction2() {
        this.setVisible(false);
        this.dispose();
    }

    private void initLayout() {
        GroupLayout groupLayout = new GroupLayout(this.inputPanel);
        this.inputPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup().addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup().addComponent(this.lbl_url, -2, -2, -2).addComponent(this.lbl_dir, -2, -2, -2).addComponent(this.lbl_verbosity, -2, -2, -2).addComponent(this.lbl_freeInput, -2, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup().addComponent(this.tf_url, -2, -2, Short.MAX_VALUE).addComponent(this.tf_dir, -2, -2, Short.MAX_VALUE).addComponent(this.cb_verbosity, -2, -2, -2).addComponent(this.tf_freeInput, -2, -2, Short.MAX_VALUE)))).addContainerGap());
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGap(10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tf_url, GroupLayout.Alignment.BASELINE, -2, -2, -2).addComponent(this.lbl_url, GroupLayout.Alignment.BASELINE, -2, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tf_dir, GroupLayout.Alignment.BASELINE, -2, -2, -2).addComponent(this.lbl_dir, GroupLayout.Alignment.BASELINE, -2, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cb_verbosity, GroupLayout.Alignment.BASELINE, -2, -2, -2).addComponent(this.lbl_verbosity, GroupLayout.Alignment.BASELINE, -2, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tf_freeInput, GroupLayout.Alignment.BASELINE, -2, -2, -2).addComponent(this.lbl_freeInput, GroupLayout.Alignment.BASELINE, -2, -2, -2)).addGap(10).addContainerGap(70, 70));
    }
}

