/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.gui.ssh;

import de.uib.configed.ConfigedMain;
import de.uib.configed.Globals;
import de.uib.configed.configed;
import de.uib.configed.gui.ssh.SSHConnectionExecDialog;
import de.uib.configed.gui.ssh.SSHPackageManagerParameterDialog;
import de.uib.opsicommand.sshcommand.CommandListOpsiProducts;
import de.uib.opsicommand.sshcommand.CommandOpsiPackageManagerInstall;
import de.uib.opsicommand.sshcommand.CommandWget;
import de.uib.opsicommand.sshcommand.List_Commands;
import de.uib.opsicommand.sshcommand.SSHConnectExec;
import de.uib.opsidatamodel.PersistenceController;
import de.uib.opsidatamodel.PersistenceControllerFactory;
import de.uib.utilities.logging.logging;
import de.uib.utilities.thread.WaitCursor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SSHPackageManagerInstallParameterDialog
extends SSHPackageManagerParameterDialog {
    private GroupLayout gpl;
    private JPanel installPanel = new JPanel();
    private JPanel radioPanel = new JPanel();
    private JLabel lbl_install = new JLabel();
    private JLabel lbl_on = new JLabel();
    private JLabel lbl_fullCommand = new JLabel();
    private JLabel lbl_server_dir = new JLabel();
    private JLabel lbl_wget_url = new JLabel();
    private JLabel lbl_wget_dir = new JLabel();
    private JLabel lbl_updateInstalled = new JLabel();
    private JLabel lbl_setupInstalled = new JLabel();
    private JLabel lbl_overwriteExisting = new JLabel();
    private JRadioButton rb_1;
    private JRadioButton rb_2;
    private JRadioButton rb_3;
    private JRadioButton rb_4;
    private JComboBox cb_opsiproducts;
    private JComboBox cb_opsirepo;
    private JComboBox cb_verbosity;
    private JComboBox cb_depots;
    private JCheckBox checkb_updateInstalled;
    private JCheckBox checkb_setupInstalled;
    private JCheckBox checkb_overwriteExisting;
    private JTextField tf_rb_4_dir;
    private JTextField tf_rb_4_url;
    private JTextField tf_rb_3;
    private JTextField tf_freeInput;
    private CommandOpsiPackageManagerInstall commandPMInstall = new CommandOpsiPackageManagerInstall();
    SSHConnectionExecDialog lastWgetDialog;
    protected final int frameLength = 700;
    protected final int frameHight = 450;

    public SSHPackageManagerInstallParameterDialog() {
        this((ConfigedMain)null);
    }

    public SSHPackageManagerInstallParameterDialog(ConfigedMain configedMain) {
        super(configed.getResourceValue("SSHConnection.ParameterDialog.opsipackagemanager_install.title"));
        WaitCursor waitCursor = new WaitCursor(this.getContentPane());
        this.main = configedMain;
        this.setSize(700, 450);
        this.setVisible(true);
        this.init();
        this.pack();
        this.enableComponents(false, false, false, false, true);
        this.setSize(700, 450);
        this.setDefaultCloseOperation(2);
        waitCursor.stop();
    }

    protected void init() {
        this.getRepositotiesFromConfigs(null);
        logging.info(this, "init opsiProd " + this.opsiProd);
        logging.info(this, "init opsiRepo " + this.opsiRepo);
        this.installPanel.setBackground(Globals.backLightBlue);
        this.buttonPanel.setBackground(Globals.backLightBlue);
        this.radioPanel.setBackground(Globals.backLightBlue);
        this.getContentPane().add((Component)this.installPanel, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.buttonPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.installPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.radioPanel.setBorder(new LineBorder(Globals.blueGrey));
        this.installPanel.setPreferredSize(new Dimension(376, 220));
        this.lbl_install.setText(configed.getResourceValue("SSHConnection.ParameterDialog.opsipackagemanager_install.jLabelInstall"));
        Object object = new ButtonGroup();
        this.rb_1 = new JRadioButton(this.opsiProd);
        ((ButtonGroup)object).add(this.rb_1);
        this.addListener(this.rb_1);
        this.rb_2 = new JRadioButton(this.opsiRepo);
        ((ButtonGroup)object).add(this.rb_2);
        this.addListener(this.rb_2);
        this.rb_3 = new JRadioButton(configed.getResourceValue("SSHConnection.ParameterDialog.opsipackagemanager_install.jLabelFromServer"), true);
        ((ButtonGroup)object).add(this.rb_3);
        this.addListener(this.rb_3);
        this.rb_4 = new JRadioButton(configed.getResourceValue("SSHConnection.ParameterDialog.opsipackagemanager_install.jLabelWgetFrom"));
        ((ButtonGroup)object).add(this.rb_4);
        this.addListener(this.rb_4);
        this.lbl_on.setText(configed.getResourceValue("SSHConnection.ParameterDialog.opsipackagemanager_install.jLabelOn"));
        this.cb_depots = new JComboBox();
        this.cb_depots.setToolTipText(configed.getResourceValue("SSHConnection.ParameterDialog.opsipackagemanager_install.tooltip.depot"));
        this.cb_depots.addItem(this.defaultDepot);
        this.cb_depots.addItem("all");
        object = PersistenceControllerFactory.getPersistenceController();
        if (object == null) {
            logging.info(this, "init PersistenceController null");
        }
        LinkedList<String> linkedList = ((PersistenceController)object).getHostInfoCollections().getDepotNamesList();
        for (String string : linkedList) {
            this.cb_depots.addItem(string);
        }
        this.cb_depots.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SSHPackageManagerInstallParameterDialog.this.getRepositotiesFromConfigs((String)SSHPackageManagerInstallParameterDialog.this.cb_depots.getSelectedItem());
                SSHPackageManagerInstallParameterDialog.this.updateLabels();
                SSHPackageManagerInstallParameterDialog.this.changeDepot();
            }
        });
        this.cb_opsiproducts = new JComboBox();
        this.cb_opsiproducts.setToolTipText(configed.getResourceValue("SSHConnection.ParameterDialog.opsipackagemanager_install.tooltip.opsiproduct") + this.opsiProd);
        this.cb_opsiproducts.addItem(this.defaultProduct);
        this.cb_opsiproducts.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SSHPackageManagerInstallParameterDialog.this.changeProduct();
            }
        });
        this.cb_opsirepo = new JComboBox();
        this.cb_opsirepo.setToolTipText(configed.getResourceValue("SSHConnection.ParameterDialog.opsipackagemanager_install.tooltip.cb_opsirepo") + this.opsiRepo);
        this.cb_opsirepo.addItem(this.defaultProduct);
        this.cb_opsirepo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SSHPackageManagerInstallParameterDialog.this.changeProduct();
            }
        });
        this.cb_verbosity = new JComboBox();
        this.cb_verbosity.setToolTipText(configed.getResourceValue("SSHConnection.ParameterDialog.tooltip.verbosity"));
        for (int i = 0; i < 5; ++i) {
            this.cb_verbosity.addItem(i);
        }
        this.cb_verbosity.setSelectedItem(1);
        this.cb_verbosity.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SSHPackageManagerInstallParameterDialog.this.changeVerbosity();
            }
        });
        this.lbl_updateInstalled.setText(configed.getResourceValue("SSHConnection.ParameterDialog.opsipackagemanager_install.updateInstalled"));
        this.checkb_updateInstalled = new JCheckBox();
        this.checkb_updateInstalled.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SSHPackageManagerInstallParameterDialog.this.changeUpdateInstalled();
            }
        });
        this.lbl_setupInstalled.setText(configed.getResourceValue("SSHConnection.ParameterDialog.opsipackagemanager_install.setupInstalled"));
        this.checkb_setupInstalled = new JCheckBox();
        this.checkb_setupInstalled.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SSHPackageManagerInstallParameterDialog.this.changeSetupInstalled();
            }
        });
        this.tf_freeInput = new JTextField();
        this.tf_freeInput.setToolTipText(configed.getResourceValue("SSHConnection.ParameterDialog.tooltip.freeInput"));
        this.tf_freeInput.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                SSHPackageManagerInstallParameterDialog.this.changeFreeInput();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                SSHPackageManagerInstallParameterDialog.this.changeFreeInput();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                SSHPackageManagerInstallParameterDialog.this.changeFreeInput();
            }
        });
        this.lbl_wget_dir.setText(configed.getResourceValue("SSHConnection.ParameterDialog.opsipackagemanager_install.jLabelWgetDir"));
        this.lbl_server_dir.setText(configed.getResourceValue("SSHConnection.ParameterDialog.opsipackagemanager_install.jLabelOtherPath"));
        this.lbl_wget_url.setText(configed.getResourceValue("SSHConnection.ParameterDialog.opsipackagemanager_install.jLabelWgetUrl"));
        this.tf_rb_4_dir = new JTextField(this.opsiProd);
        this.tf_rb_4_dir.setToolTipText(configed.getResourceValue("SSHConnection.ParameterDialog.wget.tooltip.tf_wget_dir"));
        this.addListener(this.tf_rb_4_dir);
        this.tf_rb_4_url = new JTextField("<" + configed.getResourceValue("SSHConnection.ParameterDialog.opsipackagemanager_install.jLabelWgetUrl").replace(":", "") + ">");
        this.tf_rb_4_url.setToolTipText(configed.getResourceValue("SSHConnection.ParameterDialog.wget.tooltip.tf_wget_url"));
        this.addListener(this.tf_rb_4_url);
        this.tf_rb_3 = new JTextField(this.opsiProd);
        this.tf_rb_3.setToolTipText(configed.getResourceValue("SSHConnection.ParameterDialog.opsipackagemanager_install.tooltip.tf_sonstiges"));
        this.addListener(this.tf_rb_3);
        this.initLabels();
        this.initButtons(this);
        this.initLayout();
        this.updateLabels();
        this.changeProduct();
        this.changeDepot();
        this.changeVerbosity();
        this.changeFreeInput();
    }

    private void updateLabels() {
        this.rb_1.setText(this.opsiProd);
        this.rb_2.setText(this.opsiRepo);
        this.tf_rb_3.setText(this.opsiProd);
        this.tf_rb_4_dir.setText(this.opsiProd);
        logging.info(this, "updateLabels opsiProd " + this.opsiProd);
        logging.info(this, "updateLabels opsiRepo " + this.opsiRepo);
    }

    private void addProducts(JComboBox jComboBox, String string) {
        logging.info(this, "addProducts dir " + string);
        try {
            String[] stringArray;
            CommandListOpsiProducts commandListOpsiProducts = new CommandListOpsiProducts(string);
            String string2 = new SSHConnectExec().exec(commandListOpsiProducts, false);
            logging.info(this, "addProducts dir " + string + " opsiproductlist " + string2);
            for (String string3 : stringArray = string2.replaceAll(string, "").split("\n")) {
                jComboBox.addItem(string3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void addListener(Object object) {
        if (object instanceof JRadioButton) {
            ((JRadioButton)object).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
                    if (jRadioButton == SSHPackageManagerInstallParameterDialog.this.rb_3) {
                        SSHPackageManagerInstallParameterDialog.this.enableComponents(false, false, false, false, true);
                    } else if (jRadioButton == SSHPackageManagerInstallParameterDialog.this.rb_4) {
                        SSHPackageManagerInstallParameterDialog.this.enableComponents(false, false, true, true, false);
                    }
                }
            });
        } else if (object instanceof JTextField) {
            ((JTextField)object).getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    SSHPackageManagerInstallParameterDialog.this.changeProduct();
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    SSHPackageManagerInstallParameterDialog.this.changeProduct();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    SSHPackageManagerInstallParameterDialog.this.changeProduct();
                }
            });
        }
    }

    private void updateCommand() {
        this.lbl_fullCommand.setText(this.commandPMInstall.getCommand());
    }

    private void changeProduct() {
        this.changeProduct(null);
    }

    private void changeProduct(String string) {
        if (this.rb_4.isSelected()) {
            if (!this.tf_rb_4_dir.getText().equals("") && !this.tf_rb_4_url.getText().equals("<" + configed.getResourceValue("SSHConnection.ParameterDialog.opsipackagemanager_install.jLabelWgetUrl").replace(":", "") + ">")) {
                this.commandPMInstall.setOpsiproduct(this.tf_rb_4_dir.getText() + this.getFilenameFromUrl(this.tf_rb_4_url.getText()));
            }
            if (string != null) {
                this.commandPMInstall.setOpsiproduct(string);
            }
        } else if (this.rb_3.isSelected()) {
            this.commandPMInstall.setOpsiproduct(this.tf_rb_3.getText());
        }
        this.updateCommand();
    }

    private void changeFreeInput() {
        if (this.tf_freeInput.getText().trim() != "") {
            this.commandPMInstall.setFreeInput(this.tf_freeInput.getText().trim());
        } else {
            this.commandPMInstall.setFreeInput("");
        }
        this.updateCommand();
    }

    private void changeVerbosity() {
        this.commandPMInstall.setVerbosity((Integer)this.cb_verbosity.getSelectedItem());
        this.updateCommand();
    }

    private void changeDepot() {
        if (this.cb_depots.getSelectedItem().equals(this.defaultDepot)) {
            this.commandPMInstall.setDepot("");
        } else {
            this.commandPMInstall.setDepot((String)this.cb_depots.getSelectedItem());
        }
        this.updateCommand();
    }

    private void changeUpdateInstalled() {
        this.commandPMInstall.setUpdateInstalled(this.checkb_updateInstalled.isSelected());
        this.updateCommand();
    }

    private void changeSetupInstalled() {
        this.commandPMInstall.setSetupInstalled(this.checkb_setupInstalled.isSelected());
    }

    private void enableComponents(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.cb_opsiproducts.setEnabled(bl);
        this.cb_opsirepo.setEnabled(bl2);
        this.tf_rb_4_url.setEnabled(bl3);
        this.tf_rb_4_dir.setEnabled(bl4);
        this.tf_rb_3.setEnabled(bl5);
        this.changeProduct();
    }

    @Override
    protected void doAction1() {
        logging.info(this, " doAction1 install ");
        SSHConnectExec sSHConnectExec = new SSHConnectExec();
        List_Commands list_Commands = new List_Commands();
        boolean bl = false;
        if (this.rb_4.isSelected()) {
            CommandWget commandWget = this.getWgetCommand();
            bl = true;
            if (commandWget != null && list_Commands.add(commandWget)) {
                logging.info(this, "doAction1 wget " + commandWget);
            }
        }
        if (this.commandPMInstall.checkCommand()) {
            list_Commands.add(this.commandPMInstall);
        }
        try {
            sSHConnectExec.exec_list(list_Commands, bl);
            logging.info(this, "doAction1 end ");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private CommandWget getWgetCommand() {
        String string = this.opsiProd;
        String string2 = "";
        String string3 = "<" + configed.getResourceValue("SSHConnection.ParameterDialog.wget.jLabelDirectory") + ">";
        if (this.tf_rb_4_dir.getText() == "" && this.tf_rb_4_dir.getText() == string3) {
            return null;
        }
        string = this.tf_rb_4_dir.getText();
        String string4 = "<" + configed.getResourceValue("SSHConnection.ParameterDialog.opsipackagemanager_install.jLabelWgetUrl").replace(":", "") + ">";
        if (this.tf_rb_4_url.getText() == "" && this.tf_rb_4_url.getText() == string4) {
            return null;
        }
        string2 = this.tf_rb_4_url.getText();
        try {
            CommandWget commandWget = new CommandWget(string, string2);
            this.changeProduct(commandWget.getProduct());
            return commandWget;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private String getFilenameFromUrl(String string) {
        int n = string.lastIndexOf("/");
        String string2 = string.substring(n + 1);
        return string2;
    }

    @Override
    protected void doAction2() {
        this.setVisible(false);
        this.dispose();
    }

    private void initLayout() {
        int n = -2;
        int n2 = Short.MAX_VALUE;
        GroupLayout.Alignment alignment = GroupLayout.Alignment.LEADING;
        GroupLayout groupLayout = new GroupLayout(this.radioPanel);
        this.radioPanel.setLayout(groupLayout);
        GroupLayout.SequentialGroup sequentialGroup = groupLayout.createSequentialGroup();
        GroupLayout.SequentialGroup sequentialGroup2 = groupLayout.createSequentialGroup();
        GroupLayout.ParallelGroup parallelGroup = groupLayout.createParallelGroup(alignment);
        GroupLayout.ParallelGroup parallelGroup2 = groupLayout.createParallelGroup(alignment);
        GroupLayout.ParallelGroup parallelGroup3 = groupLayout.createParallelGroup(alignment);
        GroupLayout.ParallelGroup parallelGroup4 = groupLayout.createParallelGroup(alignment);
        GroupLayout.ParallelGroup parallelGroup5 = groupLayout.createParallelGroup(alignment);
        GroupLayout.ParallelGroup parallelGroup6 = groupLayout.createParallelGroup(alignment);
        GroupLayout.ParallelGroup parallelGroup7 = groupLayout.createParallelGroup(alignment);
        parallelGroup.addGap(5).addComponent(this.rb_3).addGap(5).addGroup(groupLayout.createSequentialGroup().addGap(25).addComponent(this.lbl_server_dir)).addGap(5).addComponent(this.rb_4).addGap(5).addGroup(groupLayout.createSequentialGroup().addGap(25).addComponent(this.lbl_wget_url)).addGap(5).addGroup(groupLayout.createSequentialGroup().addGap(25).addComponent(this.lbl_wget_dir)).addGap(5);
        parallelGroup2.addComponent(this.tf_rb_3, n, n, n2).addGap(5).addComponent(this.tf_rb_4_url, n, n, n2).addGap(5).addComponent(this.tf_rb_4_dir, n, n, n2).addGap(5);
        sequentialGroup.addGap(5).addGroup(parallelGroup).addGap(5).addGroup(parallelGroup2).addGap(5);
        parallelGroup3.addComponent(this.rb_3, n, n, n);
        parallelGroup4.addGap(25).addGroup(groupLayout.createSequentialGroup().addGap(5).addComponent(this.lbl_server_dir, n, n, n)).addComponent(this.tf_rb_3, n, n, n);
        parallelGroup5.addComponent(this.rb_4, n, n, n);
        parallelGroup6.addGap(25).addGroup(groupLayout.createSequentialGroup().addGap(5).addComponent(this.lbl_wget_url, n, n, n)).addComponent(this.tf_rb_4_url, n, n, n);
        parallelGroup7.addGap(25).addGroup(groupLayout.createSequentialGroup().addGap(5).addComponent(this.lbl_wget_dir, n, n, n)).addComponent(this.tf_rb_4_dir, n, n, n);
        sequentialGroup2.addGap(5).addGroup(parallelGroup3).addGap(5).addGroup(parallelGroup4).addGap(5).addGroup(parallelGroup5).addGap(5).addGroup(parallelGroup6).addGap(5).addGroup(parallelGroup7).addGap(5);
        groupLayout.setHorizontalGroup(sequentialGroup);
        groupLayout.setVerticalGroup(sequentialGroup2);
        GroupLayout groupLayout2 = new GroupLayout(this.installPanel);
        this.installPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(alignment).addGap(10).addComponent(this.lbl_install, n, n, n2).addGap(10).addComponent(this.radioPanel, n, n, n2).addGap(10).addGroup(groupLayout2.createSequentialGroup().addComponent(this.lbl_on, 300, 300, 300).addComponent(this.cb_depots, n, n, n2)).addGroup(groupLayout2.createSequentialGroup().addComponent(this.lbl_verbosity, n, n, n2).addComponent(this.cb_verbosity, n, n, n)).addGroup(groupLayout2.createSequentialGroup().addComponent(this.lbl_updateInstalled, n, n, n2).addGap(25).addComponent(this.checkb_updateInstalled, n, n, n)).addGroup(groupLayout2.createSequentialGroup().addComponent(this.lbl_setupInstalled, n, n, n2).addGap(25).addComponent(this.checkb_setupInstalled, n, n, n)));
        groupLayout2.setVerticalGroup(groupLayout2.createSequentialGroup().addGap(10).addComponent(this.lbl_install).addGap(10).addGap(10).addComponent(this.radioPanel).addGap(10).addGroup(groupLayout2.createParallelGroup(alignment).addComponent(this.lbl_on, n, n, n).addComponent(this.cb_depots, n, n, n)).addGap(10).addGroup(groupLayout2.createParallelGroup(alignment).addComponent(this.lbl_verbosity, n, n, n).addComponent(this.cb_verbosity, n, n, n)).addGap(10).addGroup(groupLayout2.createParallelGroup(alignment).addComponent(this.lbl_updateInstalled, n, n, n).addComponent(this.checkb_updateInstalled, n, n, n)).addGap(15).addGroup(groupLayout2.createParallelGroup(alignment).addComponent(this.lbl_setupInstalled, n, n, n).addComponent(this.checkb_setupInstalled, n, n, n)));
    }
}

