/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.groupaction;

import de.uib.configed.HostsStatusInfo;
import de.uib.configed.configed;
import de.uib.utilities.logging.logging;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class ActivatedGroupModel {
    protected String groupName;
    protected String groupDescription;
    protected TreePath path;
    protected DefaultMutableTreeNode node;
    protected Set<String> associatedClients;
    protected boolean active = false;
    private HostsStatusInfo hostsInfo;

    public ActivatedGroupModel(HostsStatusInfo hostsStatusInfo) {
        this.hostsInfo = hostsStatusInfo;
    }

    public void setActive(boolean bl) {
        logging.info(this, "setActive " + bl);
        this.active = bl;
        if (bl && this.groupName != null) {
            this.hostsInfo.setGroupName(this.groupName);
            this.hostsInfo.setActivatedClientsCount(this.associatedClients.size());
            configed.savedStates.saveGroupSelection.serialize(this.groupName);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void setNode(String string, DefaultMutableTreeNode defaultMutableTreeNode, TreePath treePath) {
        this.groupName = string;
        this.node = defaultMutableTreeNode;
        this.path = treePath;
        this.hostsInfo.setGroupName(string);
    }

    public void setDescription(String string) {
        this.groupDescription = string;
    }

    public void setAssociatedClients(Set<String> set) {
        this.associatedClients = set;
        this.hostsInfo.setActivatedClientsCount(set.size());
    }

    public Set<String> getAssociatedClients() {
        return this.associatedClients;
    }

    public int getNumberOfClients() {
        if (this.associatedClients == null) {
            return 0;
        }
        return this.associatedClients.size();
    }

    public String getGroupName() {
        return "" + this.groupName;
    }

    public String getLabel() {
        if (this.groupName != null && this.groupDescription != null && !this.groupDescription.equals(this.groupName) && !this.groupDescription.equals("")) {
            return this.groupName + "  (" + this.groupDescription + ") ";
        }
        return "" + this.groupName;
    }

    public String getGroupDescription() {
        return "" + this.groupDescription;
    }
}

