/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities.thread;

import de.uib.utilities.logging.logging;
import de.uib.utilities.thread.WaitingSleeper;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;

public class WaitingWorker
extends SwingWorker<Void, Long> {
    private boolean ready = false;
    private boolean stopped = false;
    protected final JLabel statusLabel;
    protected final JProgressBar progressBar;
    private final long startActionMillis;
    private boolean timeoutReached;
    WaitingSleeper waitingSleeper;

    public WaitingWorker(WaitingSleeper waitingSleeper) {
        this.waitingSleeper = waitingSleeper;
        this.progressBar = waitingSleeper.getProgressBar();
        this.statusLabel = waitingSleeper.getLabel();
        this.startActionMillis = waitingSleeper.getStartActionMillis();
        this.timeoutReached = false;
    }

    public void setReady() {
        this.ready = true;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void stop() {
        logging.info(this, "stop");
        this.stopped = true;
        this.cancel(true);
    }

    @Override
    public Void doInBackground() {
        long l = 500L;
        logging.info(this, " doInBackground waitingMillis " + this.waitingSleeper.getWaitingMillis());
        long l2 = 0L;
        long l3 = 0L;
        boolean bl = this.timeoutReached = l2 >= this.waitingSleeper.getWaitingMillis();
        while (!(this.ready || this.timeoutReached || this.stopped)) {
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                logging.info(this, "InterruptedException");
            }
            long l4 = new GregorianCalendar().getTimeInMillis();
            l2 = l4 - this.startActionMillis;
            l3 = l2 / 1000L / 60L;
            logging.info(this, " doInBackground progress  elapsedMillis " + l2);
            logging.debug(this, " doInBackground progress totalTimeElapsed  [min] " + l3);
            this.publish(l2);
            this.timeoutReached = l2 >= this.waitingSleeper.getWaitingMillis();
        }
        logging.info(this, " doInBackground finished: ready, stopped, elapsedMillis < waitingSleeper.getWaitingMillis() " + this.ready + ", " + this.stopped + ", " + (l2 >= this.waitingSleeper.getWaitingMillis()));
        if (this.timeoutReached) {
            logging.warning(this, " doInBackground finished, timeoutReached");
        }
        return null;
    }

    @Override
    protected void process(List<Long> list) {
        logging.debug(this, "process, we have got list " + list);
        long l = list.get(list.size() - 1);
        this.statusLabel.setText(this.waitingSleeper.setLabellingStrategy(l));
        int n = this.progressBar.getMaximum() - this.progressBar.getMinimum();
        logging.debug(this, "process, millis " + l);
        double d = (double)l / (double)this.waitingSleeper.getOneProgressBarLengthWaitingMillis();
        logging.info(this, "process, millis/estimatedTotalWaitMillis  " + d);
        int n2 = (int)((double)n * d);
        logging.debug(this, "portion " + (n2 %= n) + " barLength  " + n);
        this.progressBar.setValue(this.progressBar.getMinimum() + n2);
    }

    @Override
    public void done() {
        logging.info(this, "done,  stopped is " + this.stopped);
        if (!this.stopped) {
            this.waitingSleeper.actAfterWaiting();
        }
    }

    public boolean isTimeoutReached() {
        return this.timeoutReached;
    }
}

