/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities.swing;

import de.uib.utilities.Globals;
import de.uib.utilities.logging.logging;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Map;
import javax.swing.JFrame;

public class SecondaryFrame
extends JFrame
implements WindowListener {
    protected Container masterFrame = Globals.masterFrame;

    public SecondaryFrame() {
        this.addWindowListener(this);
    }

    public void setGlobals(Map map) {
        this.setIconImage((Image)map.get("mainIcon"));
        this.setTitle((String)map.get("APPNAME"));
    }

    public void start() {
        this.setExtendedState(0);
        this.setVisible(true);
        logging.info(this, "started");
    }

    public void centerOnParent() {
        int n = this.getSize().height;
        int n2 = this.getSize().width;
        if (n > this.masterFrame.getSize().height) {
            n = this.masterFrame.getSize().height;
        }
        if (n2 > this.masterFrame.getSize().width) {
            n2 = this.masterFrame.getSize().width;
        }
        try {
            int n3 = this.masterFrame.getLocationOnScreen().x;
            int n4 = this.masterFrame.getLocationOnScreen().y;
            this.setLocation(n3 + (this.masterFrame.getSize().width - n2) / 2, n4 + (this.masterFrame.getSize().height - n) / 2);
        }
        catch (Exception exception) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n5 = (dimension.width - this.getSize().width) / 2;
            int n6 = (dimension.height - this.getSize().height) / 2;
            this.setLocation(n5, n6);
        }
    }

    protected void callExit() {
        this.setVisible(false);
    }

    @Override
    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.callExit();
        }
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.callExit();
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }
}

