/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities.swing;

import de.uib.configed.configed;
import de.uib.utilities.Globals;
import de.uib.utilities.logging.logging;
import de.uib.utilities.observer.DataLoadingObserver;
import de.uib.utilities.thread.WaitInfoString;
import de.uib.utilities.thread.WaitingSleeper;
import de.uib.utilities.thread.WaitingWorker;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.GregorianCalendar;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Painter;
import javax.swing.UIDefaults;

public class FLoadingWaiter
extends JFrame
implements WindowListener,
DataLoadingObserver,
WaitingSleeper {
    private final long WAITING_MILLIS_FOR_LOADING = 50000L;
    private final long ESTIMATED_TOTAL_WAIT_MILLIS = 10000L;
    JProgressBar progressBar;
    JLabel infoLabel;
    protected String info;
    protected static WaitInfoString waitInfoString;
    protected Object observingMesg = configed.getResourceValue("LoadingObserver.start");
    String[] waitStrings;
    int waitStringsIndex = -1;
    int max = 200;
    private boolean showing = true;
    private WaitingWorker worker;

    public FLoadingWaiter(String string) {
        super(string);
        this.addWindowListener(this);
        this.createGUI();
        this.setVisible(true);
        logging.info(this, "should be visible ");
        if (waitInfoString == null) {
            waitInfoString = new WaitInfoString();
        }
        this.worker = new WaitingWorker(this);
    }

    public void stopWaiting() {
        this.worker.stop();
    }

    @Override
    public void gotNotification(Object object) {
        this.observingMesg = object;
    }

    private void createGUI() {
        this.setIconImage(Globals.mainIcon);
        this.progressBar = new JProgressBar();
        this.progressBar.setEnabled(true);
        this.progressBar.setMaximum(this.max);
        UIDefaults uIDefaults = new UIDefaults();
        uIDefaults.put("ProgressBar[Enabled].foregroundPainter", new MyPainter(Globals.opsiLogoBlue));
        uIDefaults.put("ProgressBar[Enabled].backgroundPainter", new MyPainter(Globals.opsiLogoLightBlue));
        this.progressBar.putClientProperty("Nimbus.Overrides", uIDefaults);
        this.infoLabel = new JLabel();
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Globals.backLightBlue);
        GroupLayout groupLayout = new GroupLayout(jPanel);
        jPanel.setLayout(groupLayout);
        ImageIcon imageIcon = de.uib.configed.Globals.createImageIcon("images/configed_icon.png", "");
        JLabel jLabel = new JLabel(imageIcon);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel, 150, 150, 150).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, Short.MAX_VALUE).addComponent(this.infoLabel, 100, 300, Short.MAX_VALUE).addGap(10, 10, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 30).addComponent(this.progressBar, 100, 350, Short.MAX_VALUE).addGap(10, 10, 30)));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addComponent(jLabel, 150, 150, 150).addComponent(this.progressBar, 10, 10, 10).addComponent(this.infoLabel, 30, 30, 30));
        this.getContentPane().add(jPanel);
        this.setSize(new Dimension(400, 250));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }

    public void startWaiting() {
        this.worker.execute();
    }

    public void setReady() {
        this.worker.setReady();
    }

    @Override
    public void actAfterWaiting() {
        this.setVisible(false);
    }

    @Override
    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    @Override
    public JLabel getLabel() {
        return this.infoLabel;
    }

    @Override
    public long getStartActionMillis() {
        return new GregorianCalendar().getTimeInMillis();
    }

    @Override
    public long getWaitingMillis() {
        return 50000L;
    }

    @Override
    public long getOneProgressBarLengthWaitingMillis() {
        return 10000L;
    }

    @Override
    public String setLabellingStrategy(long l) {
        logging.info(this, "setLabellingStrategy millis " + l);
        return "" + this.observingMesg + " " + waitInfoString.next();
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        this.showing = false;
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    class MyPainter
    implements Painter<JProgressBar> {
        private final Color color;

        public MyPainter(Color color) {
            this.color = color;
        }

        @Override
        public void paint(Graphics2D graphics2D, JProgressBar jProgressBar, int n, int n2) {
            graphics2D.setColor(this.color);
            graphics2D.fillRect(0, 0, n, n2);
        }
    }
}

