/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities.selectionpanel;

import de.uib.configed.ConfigedMain;
import de.uib.configed.Globals;
import de.uib.configed.configed;
import de.uib.utilities.logging.logging;
import de.uib.utilities.swing.JComboBoxToolTip;
import de.uib.utilities.swing.JMenuItemFormatted;
import de.uib.utilities.swing.MissingDataPanel;
import de.uib.utilities.table.gui.ColorHeaderCellRenderer;
import de.uib.utilities.table.gui.SearchPane;
import de.uib.utilities.table.gui.StandardTableCellRenderer;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class JTableSelectionPanel
extends JPanel
implements DocumentListener,
KeyListener,
MissingDataPanel {
    JScrollPane scrollpane;
    JTable table;
    DefaultListSelectionModel selectionmodel;
    ConfigedMain main;
    List<RowSorter.SortKey> primaryOrderingKeys;
    JTextField fieldSearch;
    JComboBox comboSearch;
    JComboBox comboSearchMode;
    SearchPane.SearchMode searchMode;
    protected int hMin = 200;
    private int foundrow = -1;
    private int lastCountOfSearchWords = 0;
    private TreeMap<String, Integer> rowIndexMap;

    public JTableSelectionPanel(ConfigedMain configedMain) {
        this.main = configedMain;
        this.init();
    }

    protected void init() {
        this.searchMode = SearchPane.SearchMode.FULL_TEXT_SEARCHING_WITH_ALTERNATIVES;
        this.scrollpane = new JScrollPane();
        this.scrollpane.getViewport().setBackground(Globals.backLightBlue);
        this.table = new JTable(){

            @Override
            public Object getValueAt(int n, int n2) {
                try {
                    return super.getValueAt(n, n2);
                }
                catch (Exception exception) {
                    return "";
                }
            }
        };
        this.table.setDragEnabled(true);
        this.table.setShowGrid(true);
        this.table.setGridColor(Color.white);
        this.table.setDefaultRenderer(Object.class, new StandardTableCellRenderer());
        this.table.setAutoCreateRowSorter(true);
        this.primaryOrderingKeys = new ArrayList<RowSorter.SortKey>();
        this.primaryOrderingKeys.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
        this.table.setSelectionMode(2);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getTableHeader().setDefaultRenderer(new ColorHeaderCellRenderer(this.table.getTableHeader().getDefaultRenderer()));
        this.selectionmodel = (DefaultListSelectionModel)this.table.getSelectionModel();
        this.table.setColumnSelectionAllowed(false);
        this.addListSelectionListener(this.main);
        this.table.addKeyListener(this);
        this.scrollpane.getViewport().add(this.table);
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel(configed.getResourceValue("JTableSelectionPanel.searchin"));
        this.fieldSearch = new JTextField("");
        this.fieldSearch.setPreferredSize(Globals.buttonDimension);
        this.fieldSearch.setFont(Globals.defaultFont);
        this.fieldSearch.setBackground(Globals.backgroundLightGrey);
        this.fieldSearch.getCaret().setBlinkRate(0);
        this.fieldSearch.getDocument().addDocumentListener(this);
        this.fieldSearch.addKeyListener(this);
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItemFormatted jMenuItemFormatted = new JMenuItemFormatted();
        JMenuItemFormatted jMenuItemFormatted2 = new JMenuItemFormatted();
        JMenuItemFormatted jMenuItemFormatted3 = new JMenuItemFormatted();
        JMenuItemFormatted jMenuItemFormatted4 = new JMenuItemFormatted();
        JMenuItemFormatted jMenuItemFormatted5 = new JMenuItemFormatted();
        jPopupMenu.add(jMenuItemFormatted);
        jPopupMenu.add(jMenuItemFormatted2);
        jPopupMenu.add(jMenuItemFormatted3);
        jPopupMenu.add(jMenuItemFormatted4);
        jPopupMenu.add(jMenuItemFormatted5);
        jMenuItemFormatted.setText(configed.getResourceValue("JTableSelectionPanel.search"));
        jMenuItemFormatted.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTableSelectionPanel.this.searchTheRow();
            }
        });
        jMenuItemFormatted2.setText(configed.getResourceValue("JTableSelectionPanel.searchnext") + " ( F3 ) ");
        jMenuItemFormatted2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTableSelectionPanel.this.searchTheNextRow();
            }
        });
        jMenuItemFormatted3.setText(configed.getResourceValue("JTableSelectionPanel.searchnew"));
        jMenuItemFormatted3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTableSelectionPanel.this.searchTheRow(0);
            }
        });
        jMenuItemFormatted4.setText(configed.getResourceValue("JTableSelectionPanel.markall") + " ( F5 ) ");
        jMenuItemFormatted4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTableSelectionPanel.this.markAll();
            }
        });
        jMenuItemFormatted5.setText(configed.getResourceValue("JTableSelectionPanel.searchempty"));
        jMenuItemFormatted5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTableSelectionPanel.this.fieldSearch.setText("");
            }
        });
        this.fieldSearch.setComponentPopupMenu(jPopupMenu);
        this.fieldSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTableSelectionPanel.this.searchTheNextRow();
            }
        });
        JLabel jLabel2 = new JLabel(configed.getResourceValue("JTableSelectionPanel.searchmode"));
        this.comboSearchMode = new JComboBoxToolTip();
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put(configed.getResourceValue("SearchPane.SearchMode.fulltext_with_alternatives"), configed.getResourceValue("SearchPane.SearchMode.fulltext_with_alternatives.tooltip"));
        linkedHashMap.put(configed.getResourceValue("SearchPane.SearchMode.fulltext_one_string"), configed.getResourceValue("SearchPane.SearchMode.fulltext_one_string.tooltip"));
        linkedHashMap.put(configed.getResourceValue("SearchPane.SearchMode.starttext"), configed.getResourceValue("SearchPane.SearchMode.starttext.tooltip"));
        linkedHashMap.put(configed.getResourceValue("SearchPane.SearchMode.regex"), configed.getResourceValue("SearchPane.SearchMode.regex.tooltip"));
        ((JComboBoxToolTip)this.comboSearchMode).setValues(linkedHashMap);
        this.comboSearchMode.setSelectedIndex(this.searchMode.ordinal());
        logging.info(this, "comboSearchMode set index to " + this.searchMode.ordinal());
        this.comboSearchMode.setPreferredSize(Globals.buttonDimension);
        this.comboSearch = new JComboBox<String>(new String[]{configed.getResourceValue("ConfigedMain.pclistTableModel.allfields")});
        this.comboSearch.setPreferredSize(Globals.buttonDimension);
        GroupLayout groupLayout = new GroupLayout(jPanel);
        jPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.fieldSearch, -2, -2, Short.MAX_VALUE).addGap(5, 5, 5).addComponent(jLabel, -2, -2, -2).addGap(5, 5, 5).addComponent(this.comboSearch, -2, -2, -2).addGap(5, 5, 5).addComponent(jLabel2, -2, -2, -2).addGap(5, 5, 5).addComponent(this.comboSearchMode, 100, 200, 300).addGap(10, 10, 10)));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGap(5, 5, 5).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel, 10, -2, -2).addComponent(this.fieldSearch, 10, -2, -2).addComponent(jLabel2, -2, -2, -2).addComponent(this.comboSearchMode, -2, -2, -2).addComponent(this.comboSearch, 10, -2, -2)).addGap(5, 5, 5));
        JTableSelectionPanel jTableSelectionPanel = this;
        GroupLayout groupLayout2 = new GroupLayout(jTableSelectionPanel);
        jTableSelectionPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jPanel, this.hMin, -2, Short.MAX_VALUE).addComponent(this.scrollpane, this.hMin, -2, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createSequentialGroup().addComponent(jPanel, -2, -2, -2).addComponent(this.scrollpane, 100, -2, Short.MAX_VALUE));
    }

    @Override
    public void setMissingDataPanel(boolean bl) {
        if (bl) {
            JLabel jLabel = new JLabel(Globals.createImageIcon("images/opsi-logo.png", ""));
            JLabel jLabel2 = new JLabel(configed.getResourceValue("JTableSelectionPanel.missingDataPanel.label1"));
            jLabel2.setFont(Globals.defaultFontTitle);
            JLabel jLabel3 = new JLabel(configed.getResourceValue("JTableSelectionPanel.missingDataPanel.label2"));
            jLabel3.setFont(Globals.defaultFontTitle);
            JPanel jPanel = new JPanel();
            jPanel.setBackground(Globals.backLightBlue);
            GroupLayout groupLayout = new GroupLayout(jPanel);
            jPanel.setLayout(groupLayout);
            groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGap(10, 10, Short.MAX_VALUE).addComponent(jLabel, 10, 80, 90).addComponent(jLabel2, 10, 40, 90).addGap(10, 40, 40).addComponent(jLabel3, 10, 40, 80).addGap(10, 10, Short.MAX_VALUE));
            groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGap(10, 10, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel, -2, -2, -2).addComponent(jLabel2, -2, -2, -2).addComponent(jLabel3, -2, -2, -2)).addGap(10, 10, Short.MAX_VALUE));
            this.scrollpane.getViewport().setView(jPanel);
        } else {
            this.scrollpane.getViewport().setView(this.table);
        }
    }

    @Override
    public void setMissingDataPanel(boolean bl, JComponent jComponent) {
        if (bl) {
            this.scrollpane.getViewport().add(jComponent);
        } else {
            this.scrollpane.getViewport().add(this.table);
        }
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        this.scrollpane.addMouseListener(mouseListener);
        this.table.addMouseListener(mouseListener);
    }

    public int convertRowIndexToModel(int n) {
        return this.table.convertRowIndexToModel(n);
    }

    public int convertRowIndexToView(int n) {
        return this.table.convertRowIndexToView(n);
    }

    public boolean isSelectionEmpty() {
        return this.table.getSelectedRowCount() == 0;
    }

    public int getSelectedRow() {
        return this.table.getSelectedRow();
    }

    public Rectangle getCellRect(int n, int n2, boolean bl) {
        return this.table.getCellRect(n, n2, bl);
    }

    public Map<Integer, Integer> getSelectionMap() {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n = 0;
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            if (!this.selectionmodel.isSelectedIndex(i)) continue;
            hashMap.put(n, i);
            ++n;
        }
        return hashMap;
    }

    public TreeSet<String> getSelectedSet() {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            if (!this.selectionmodel.isSelectedIndex(i)) continue;
            treeSet.add((String)this.table.getValueAt(i, 0));
        }
        return treeSet;
    }

    public void initColumnNames() {
        Object object = this.comboSearch.getSelectedItem();
        Vector<String> vector = new Vector<String>();
        vector.add(configed.getResourceValue("ConfigedMain.pclistTableModel.allfields"));
        try {
            logging.info(this, "initColumnNames columncount " + this.table.getColumnCount());
            for (int i = 0; i < this.table.getColumnCount(); ++i) {
                logging.info(this, "initColumnName col " + i);
                logging.info(this, "initColumnName name  " + this.table.getColumnName(i));
                vector.add(this.table.getColumnName(i));
            }
            this.comboSearch.setModel(new DefaultComboBoxModel(vector));
            if (object != null) {
                this.comboSearch.setSelectedItem(object);
            }
        }
        catch (Exception exception) {
            logging.info(this, "initColumnNames " + exception);
        }
    }

    public ArrayList<String> getSelectedValues() {
        ArrayList<String> arrayList = new ArrayList<String>(this.table.getSelectedRowCount());
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            if (!this.selectionmodel.isSelectedIndex(i)) continue;
            arrayList.add((String)this.table.getValueAt(i, 0));
        }
        return arrayList;
    }

    public void clearSelection() {
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.clearSelection();
    }

    public void setSelectedValues(Collection<String> collection) {
        int n;
        logging.info(this, "setSelectedValues " + collection);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.clearSelection();
        if (collection == null || collection.size() == 0) {
            return;
        }
        TreeSet<String> treeSet = new TreeSet<String>(collection);
        logging.info(this, "setSelectedValues, (ordered) set of values " + treeSet);
        int n2 = -1;
        ListSelectionListener[] listSelectionListenerArray = (ListSelectionListener[])((DefaultListSelectionModel)listSelectionModel).getListeners(ListSelectionListener.class);
        for (n = 0; n < listSelectionListenerArray.length; ++n) {
            listSelectionModel.removeListSelectionListener(listSelectionListenerArray[n]);
        }
        logging.info(this, "setSelectedValues, table.getRowCount() " + this.table.getRowCount());
        for (n = 0; n < this.table.getRowCount(); ++n) {
            logging.info(this, "setSelectedValues checkValue for i " + n + ": " + (String)this.table.getValueAt(n, 0));
            if (!treeSet.contains(this.table.getValueAt(n, 0))) continue;
            listSelectionModel.addSelectionInterval(n, n);
            n2 = n;
            logging.info(this, "setSelectedValues add interval " + n);
        }
        listSelectionModel.removeSelectionInterval(n2, n2);
        for (n = 0; n < listSelectionListenerArray.length; ++n) {
            listSelectionModel.addListSelectionListener(listSelectionListenerArray[n]);
        }
        if (n2 > -1) {
            listSelectionModel.addSelectionInterval(n2, n2);
        }
        if (!treeSet.isEmpty()) {
            String string = treeSet.iterator().next();
            this.moveToValue(string, 0);
        }
        logging.info(this, "setSelectedValues  produced " + this.getSelectedValues());
    }

    public void setSelectedValues(String[] stringArray) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            treeSet.add(stringArray[i]);
        }
        this.setSelectedValues(treeSet);
    }

    public void selectAll() {
        this.selectionmodel.setSelectionInterval(0, this.table.getRowCount());
    }

    public void initSortKeys() {
        this.table.getRowSorter().setSortKeys(this.primaryOrderingKeys);
    }

    public List<? extends RowSorter.SortKey> getSortKeys() {
        return this.table.getRowSorter().getSortKeys();
    }

    public void setSortKeys(List<? extends RowSorter.SortKey> list) {
        this.table.getRowSorter().setSortKeys(list);
    }

    public void buildRowIndexByCol(int n) {
        int n2 = 0;
        this.rowIndexMap = new TreeMap();
        while (n2 < this.getTableModel().getRowCount()) {
            this.rowIndexMap.put((String)this.getTableModel().getValueAt(n2, n), n2);
        }
    }

    public void setValueForKey(Object object, String string, int n) {
        this.getTableModel().setValueAt(object, this.rowIndexMap.get(string), n);
    }

    public void setModel(TableModel tableModel) {
        logging.info(this, " [JTableSelectionPanel] setModel with row count " + tableModel.getRowCount());
        tableModel.addTableModelListener(this.table);
        logging.info(this, "setModel all hosts size " + this.main.getPersistenceController().getHostInfoCollections().getMapOfAllPCInfoMaps().size());
        this.table.setModel(tableModel);
    }

    public DefaultTableModel getSelectedRowsModel() {
        final Map<Integer, Integer> map = this.getSelectionMap();
        DefaultTableModel defaultTableModel = new DefaultTableModel(){

            @Override
            public Object getValueAt(int n, int n2) {
                return JTableSelectionPanel.this.table.getValueAt((Integer)map.get(n), n2);
            }

            @Override
            public int getRowCount() {
                return map.size();
            }

            @Override
            public int getColumnCount() {
                return JTableSelectionPanel.this.table.getColumnCount();
            }
        };
        return defaultTableModel;
    }

    public DefaultTableModel getTableModel() {
        return (DefaultTableModel)this.table.getModel();
    }

    public TableColumnModel getColumnModel() {
        return this.table.getColumnModel();
    }

    public ListSelectionModel getListSelectionModel() {
        return this.table.getSelectionModel();
    }

    public void listvalueChanged(ListSelectionEvent listSelectionEvent) {
        this.main.valueChanged(listSelectionEvent);
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.selectionmodel.addListSelectionListener(listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.selectionmodel.removeListSelectionListener(listSelectionListener);
    }

    public void fireListSelectionEmpty(Object object) {
        for (int i = 0; i < this.selectionmodel.getListSelectionListeners().length; ++i) {
            ListSelectionListener[] listSelectionListenerArray = this.selectionmodel.getListSelectionListeners();
            listSelectionListenerArray[i].valueChanged(new ListSelectionEvent(object, 0, 0, false));
        }
    }

    public int findModelRowFromValue(Object object, int n) {
        int n2 = -1;
        if (object == null) {
            return n2;
        }
        boolean bl = false;
        int n3 = 0;
        while (!bl && n3 < this.getTableModel().getRowCount()) {
            Object object2 = this.getTableModel().getValueAt(n3, n);
            String string = object2.toString();
            String string2 = object.toString();
            if (string2.equals(string)) {
                bl = true;
                n2 = n3;
            }
            if (bl) continue;
            ++n3;
        }
        return n2;
    }

    protected int findViewRowFromValue(int n, Object object, Set set) {
        return this.findViewRowFromValue(n, object, set, this.searchMode);
    }

    private List<String> getWords(String string) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray = string.split("\\s+")) {
            if (string2.equals(" ")) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    protected int findViewRowFromValue(int n, Object object, Set set, SearchPane.SearchMode searchMode) {
        logging.info(this, "findViewRowFromValue(int startviewrow, Object value, Set colIndices, searchMode: " + n + ", " + object + ", " + set + ", " + (Object)((Object)searchMode));
        if (object == null) {
            return -1;
        }
        String string = object.toString();
        String string2 = string.toLowerCase();
        boolean bl = false;
        int n2 = 0;
        if (n > 0) {
            n2 = n;
        }
        boolean bl2 = searchMode == SearchPane.SearchMode.FULL_TEXT_SEARCHING_WITH_ALTERNATIVES || searchMode == SearchPane.SearchMode.FULL_TEXT_SEARCHING_ONE_STRING;
        Pattern pattern = null;
        if (searchMode == SearchPane.SearchMode.REGEX_SEARCHING) {
            try {
                if (bl2) {
                    string = ".*" + string + ".*";
                }
                pattern = Pattern.compile(string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                logging.error(this, "pattern problem " + patternSyntaxException);
                return -1;
            }
        }
        List<String> list = this.getWords(string2);
        this.lastCountOfSearchWords = list.size();
        while (!bl && n2 < this.getTableModel().getRowCount()) {
            for (int i = 0; i < this.getTableModel().getColumnCount(); ++i) {
                if (set != null && !set.contains(i)) continue;
                Object object2 = this.getTableModel().getValueAt(this.table.convertRowIndexToModel(n2), this.table.convertColumnIndexToModel(i));
                if (object2 == null) {
                    bl = string == null || string.equals("");
                } else {
                    String string3 = ("" + object2).toLowerCase();
                    switch (searchMode) {
                        case REGEX_SEARCHING: {
                            bl = pattern.matcher(string3).matches();
                            break;
                        }
                        case FULL_TEXT_SEARCHING_WITH_ALTERNATIVES: {
                            String string4;
                            Iterator<String> iterator = list.iterator();
                            while (iterator.hasNext() && !(bl = string3.indexOf(string4 = iterator.next()) >= 0)) {
                            }
                            break;
                        }
                        case FULL_TEXT_SEARCHING_ONE_STRING: {
                            bl = string3.indexOf(string2) >= 0;
                            break;
                        }
                        default: {
                            bl = string3.startsWith(string2);
                        }
                    }
                }
                if (bl) break;
            }
            if (bl) continue;
            ++n2;
        }
        if (bl) {
            return n2;
        }
        return -1;
    }

    public boolean moveToValue(Object object, int n) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(n);
        int n2 = this.findViewRowFromValue(0, object, hashSet);
        this.scrollRowToVisible(n2);
        return n2 != -1;
    }

    public void scrollRowToVisible(int n) {
        Rectangle rectangle = this.table.getCellRect(n, 0, false);
        this.table.scrollRectToVisible(rectangle);
    }

    public void addSelectedRow(int n) {
        if (this.table.getRowCount() == 0) {
            return;
        }
        this.table.addRowSelectionInterval(n, n);
        this.scrollRowToVisible(n);
    }

    public void setSelectedRow(int n) {
        if (this.table.getRowCount() == 0) {
            return;
        }
        if (n == -1) {
            this.table.clearSelection();
            return;
        }
        this.table.setRowSelectionInterval(n, n);
        this.scrollRowToVisible(n);
    }

    private void searchTheNextRow() {
        this.searchTheNextRow(false);
    }

    private void markAll() {
        this.table.clearSelection();
        this.searchTheRow(0);
        int n = this.foundrow++;
        while (this.foundrow > n) {
            this.searchTheNextRow(true);
        }
    }

    private void searchTheNextRow(boolean bl) {
        int n = 0;
        if (this.table.getSelectedRow() >= 0) {
            n = this.table.getSelectedRows()[this.table.getSelectedRows().length - 1] + 1;
        }
        if (n >= this.table.getRowCount()) {
            n = 0;
        }
        this.searchTheRow(n, bl);
        if (this.foundrow == -1) {
            this.searchTheRow(0, bl);
        }
    }

    private void searchTheRow() {
        this.searchTheRow(this.table.getSelectedRow());
    }

    private void searchTheRow(int n) {
        this.searchTheRow(n, false);
    }

    private void searchTheRow(int n, boolean bl) {
        String string = this.fieldSearch.getText();
        if (string.length() > 10 && string.substring(0, 4).equalsIgnoreCase("http") && string.indexOf("host=") > 0) {
            string = string.substring(string.indexOf("host=") + "host=".length());
        }
        HashSet<Integer> hashSet = null;
        if (this.comboSearch.getSelectedIndex() > 0) {
            hashSet = new HashSet<Integer>();
            hashSet.add(this.getTableModel().findColumn((String)this.comboSearch.getSelectedItem()));
        }
        this.searchMode = SearchPane.SearchMode.FULL_TEXT_SEARCHING_WITH_ALTERNATIVES;
        switch (this.comboSearchMode.getSelectedIndex()) {
            case 0: {
                this.searchMode = SearchPane.SearchMode.FULL_TEXT_SEARCHING_WITH_ALTERNATIVES;
                break;
            }
            case 1: {
                this.searchMode = SearchPane.SearchMode.FULL_TEXT_SEARCHING_ONE_STRING;
                break;
            }
            case 2: {
                this.searchMode = SearchPane.SearchMode.START_TEXT_SEARCHING;
                break;
            }
            case 3: {
                this.searchMode = SearchPane.SearchMode.REGEX_SEARCHING;
            }
        }
        this.foundrow = this.findViewRowFromValue(n, string, hashSet, this.searchMode);
        if (this.foundrow > -1) {
            if (bl) {
                this.addSelectedRow(this.foundrow);
            } else {
                this.setSelectedRow(this.foundrow);
            }
        }
    }

    public TableCellRenderer getDefaultRenderer(Class<?> clazz) {
        return this.table.getDefaultRenderer(clazz);
    }

    private void searchOnDocumentChange() {
        if (this.fieldSearch.getText().equals("")) {
            this.setSelectedRow(0);
            this.lastCountOfSearchWords = 0;
        } else {
            if (this.searchMode == SearchPane.SearchMode.FULL_TEXT_SEARCHING_WITH_ALTERNATIVES && this.getWords(this.fieldSearch.getText()).size() > this.lastCountOfSearchWords) {
                this.setSelectedRow(0);
            }
            this.searchTheRow();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.fieldSearch.getDocument()) {
            this.searchOnDocumentChange();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.fieldSearch.getDocument()) {
            this.searchOnDocumentChange();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.fieldSearch.getDocument()) {
            this.searchOnDocumentChange();
        }
    }

    protected void keyPressedOnTable(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (!(keyEvent.getSource() instanceof JTextField)) {
            this.keyPressedOnTable(keyEvent);
        }
        if (keyEvent.getKeyCode() == 116) {
            if (!this.fieldSearch.getText().equals("")) {
                this.markAll();
            }
        } else if (keyEvent.getKeyCode() == 114 && !this.fieldSearch.getText().equals("")) {
            this.searchTheNextRow();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }
}

