/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities.datapanel;

import de.uib.configed.configed;
import de.uib.configed.gui.FTextArea;
import de.uib.utilities.Globals;
import de.uib.utilities.datapanel.DefaultEditMapPanel;
import de.uib.utilities.datapanel.ListModelProducerForVisualDatamap;
import de.uib.utilities.logging.logging;
import de.uib.utilities.swing.CellAlternatingColorizer;
import de.uib.utilities.swing.FEditText;
import de.uib.utilities.swing.PopupMenuTrait;
import de.uib.utilities.swing.XCellEditor;
import de.uib.utilities.table.DefaultListCellOptions;
import de.uib.utilities.table.ListCellOptions;
import de.uib.utilities.table.ListModelProducer;
import de.uib.utilities.table.gui.ColorTableCellRenderer;
import de.uib.utilities.table.gui.SensitiveCellEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ToolTipManager;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;
import utils.PopupMouseListener;

public class EditMapPanelX
extends DefaultEditMapPanel
implements FocusListener {
    JScrollPane jScrollPane;
    JTable table;
    TableColumn editableColumn;
    TableCellEditor theCellEditor;
    JComboBox editorfield;
    TableCellEditor defaultCellEditor;
    ListModelProducer modelProducer;
    JMenuItem popupItemDeleteEntry;
    JMenuItem popupItemAddStringListEntry;
    JMenuItem popupItemAddBooleanListEntry;
    ToolTipManager ttm = ToolTipManager.sharedInstance();
    protected boolean markDeviation = true;

    public EditMapPanelX() {
        this((TableCellRenderer)null);
    }

    public EditMapPanelX(TableCellRenderer tableCellRenderer) {
        this(tableCellRenderer, false);
    }

    public EditMapPanelX(TableCellRenderer tableCellRenderer, boolean bl) {
        this(tableCellRenderer, bl, true);
    }

    public EditMapPanelX(TableCellRenderer tableCellRenderer, boolean bl, boolean bl2) {
        this(tableCellRenderer, bl, bl2, false);
    }

    public EditMapPanelX(TableCellRenderer tableCellRenderer, boolean bl, boolean bl2, boolean bl3) {
        super(tableCellRenderer, bl, bl2, bl3);
        this.ttm.setEnabled(true);
        this.ttm.setInitialDelay(1000);
        this.ttm.setDismissDelay(20000);
        this.ttm.setReshowDelay(0);
        this.buildPanel();
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.setRowHeight(21);
        this.editableColumn = this.table.getColumnModel().getColumn(1);
        this.editorfield = new JComboBox();
        this.editorfield.setEditable(true);
        this.theCellEditor = this.defaultCellEditor = new XCellEditor(this.editorfield);
        if (tableCellRenderer == null) {
            this.editableColumn.setCellRenderer(new ColorTableCellRenderer());
        } else {
            this.editableColumn.setCellRenderer(tableCellRenderer);
        }
        this.popup = this.definePopup();
        PopupMouseListener popupMouseListener = new PopupMouseListener(this.popup);
        this.table.addMouseListener(popupMouseListener);
        this.jScrollPane.getViewport().addMouseListener(popupMouseListener);
        if (bl || bl2) {
            this.popup.addSeparator();
            this.table.getTableHeader().setToolTipText(configed.getResourceValue("EditMapPanel.PopupMenu.EditableToolTip"));
            this.popupItemAddStringListEntry = new JMenuItem(configed.getResourceValue("EditMapPanel.PopupMenu.AddEntry"));
            this.popup.add(this.popupItemAddStringListEntry);
            this.popupItemAddStringListEntry.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EditMapPanelX.this.addEntryFor("java.lang.String");
                }
            });
            this.popupItemAddBooleanListEntry = new JMenuItem(configed.getResourceValue("EditMapPanel.PopupMenu.AddBooleanEntry"));
            this.popup.add(this.popupItemAddBooleanListEntry);
            this.popupItemAddBooleanListEntry.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EditMapPanelX.this.addEntryFor("java.lang.Boolean");
                }
            });
            if (bl2) {
                this.popupItemDeleteEntry = new JMenuItem(configed.getResourceValue("EditMapPanel.PopupMenu.RemoveEntry"));
                this.popup.add(this.popupItemDeleteEntry);
                this.popupItemDeleteEntry.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (EditMapPanelX.this.table.getSelectedRowCount() == 0) {
                            FTextArea fTextArea = new FTextArea(null, Globals.APPNAME, "", true, 1);
                            fTextArea.setSize(new Dimension(200, 200));
                            fTextArea.setModal(true);
                            fTextArea.setMessage(configed.getResourceValue("EditMapPanel.RowToRemoveMustBeSelected"));
                            fTextArea.setVisible(true);
                        } else if (EditMapPanelX.this.names != null) {
                            EditMapPanelX.this.removeProperty(((String)EditMapPanelX.this.names.elementAt(EditMapPanelX.this.table.getSelectedRow())).toString());
                        }
                    }
                });
            }
        }
    }

    protected JPopupMenu definePopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (this.reloadable) {
            jPopupMenu = new PopupMenuTrait(new Integer[]{4}){

                @Override
                public void action(int n) {
                    switch (n) {
                        case 4: {
                            EditMapPanelX.this.actor.reloadData();
                        }
                    }
                }
            };
        }
        return jPopupMenu;
    }

    @Override
    protected void buildPanel() {
        this.setLayout(new BorderLayout());
        ColorTableCellRenderer colorTableCellRenderer = new ColorTableCellRenderer();
        this.table = new JTable(this.mapTableModel){

            @Override
            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (component != null && component instanceof JComponent && EditMapPanelX.this.showToolTip) {
                    JComponent jComponent = (JComponent)component;
                    String string = (String)EditMapPanelX.this.names.get(n);
                    String string2 = null;
                    if (string != null && EditMapPanelX.this.defaultsMap != null && EditMapPanelX.this.defaultsMap.get(string) != null) {
                        string2 = "default: ";
                        string2 = de.uib.configed.Globals.isKeyForSecretValue(string) ? string2 + "*****" : string2 + EditMapPanelX.this.defaultsMap.get(string);
                    }
                    if (string != null && EditMapPanelX.this.descriptionsMap != null && EditMapPanelX.this.descriptionsMap.get(string) != null) {
                        string2 = string2 + "\n\n" + (String)EditMapPanelX.this.descriptionsMap.get(string);
                    }
                    jComponent.setToolTipText(Globals.makeHTMLlines(string2));
                    Object v = EditMapPanelX.this.defaultsMap.get(EditMapPanelX.this.table.getValueAt(n, 0));
                    Object object = EditMapPanelX.this.table.getValueAt(n, 1);
                    if (v == null) {
                        jComponent.setForeground(Color.red);
                        jComponent.setToolTipText(configed.getResourceValue("EditMapPanel.MissingDefaultValue"));
                        Font font = jComponent.getFont();
                        font = font.deriveFont(1);
                        jComponent.setFont(font);
                    } else if (EditMapPanelX.this.markDeviation && !v.equals(object)) {
                        Font font = jComponent.getFont();
                        font = font.deriveFont(1);
                        jComponent.setFont(font);
                    }
                    if (n2 == 1 && de.uib.configed.Globals.isKeyForSecretValue((String)EditMapPanelX.this.mapTableModel.getValueAt(n, 0))) {
                        if (jComponent instanceof JLabel) {
                            ((JLabel)jComponent).setText("*****");
                        } else if (jComponent instanceof JTextComponent) {
                            ((JTextComponent)jComponent).setText("*****");
                        } else {
                            CellAlternatingColorizer.colorizeSecret(jComponent);
                        }
                    }
                }
                return component;
            }
        };
        this.table.setDefaultRenderer(Object.class, colorTableCellRenderer);
        this.table.setRowHeight(28);
        this.table.setShowGrid(true);
        this.table.setGridColor(Color.white);
        this.table.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                int n;
                int n2 = -1;
                n2 = EditMapPanelX.this.table.getSelectedRows() == null || EditMapPanelX.this.table.getSelectedRows().length == 0 ? -1 : EditMapPanelX.this.table.getSelectedRows()[0];
                int n3 = mouseWheelEvent.getWheelRotation();
                if ((n2 += n3) >= EditMapPanelX.this.table.getRowCount()) {
                    n2 = EditMapPanelX.this.table.getRowCount() - 1;
                }
                if (n2 < (n = 0)) {
                    n2 = n;
                }
                EditMapPanelX.this.setSelectedRow(n2);
            }
        });
        this.jScrollPane = new JScrollPane(this.table);
        this.jScrollPane.getViewport().setBackground(Globals.backLightBlue);
        this.add((Component)this.jScrollPane, "Center");
    }

    @Override
    public void init() {
        this.setEditableMap(null, null);
    }

    public void setCellEditor(SensitiveCellEditor sensitiveCellEditor) {
        this.theCellEditor = sensitiveCellEditor;
    }

    @Override
    public void setEditableMap(Map<String, Object> map, Map<String, ListCellOptions> map2) {
        super.setEditableMap(map, map2);
        this.cancelOldCellEditing();
        if (map2 != null) {
            this.modelProducer = new ListModelProducerForVisualDatamap(this.table, map2, map);
        }
        logging.info(this, "setEditableMap set modelProducer  == null " + (this.modelProducer == null));
        if (this.modelProducer != null) {
            logging.info(this, "setEditableMap test modelProducer " + this.modelProducer.getClass());
            logging.info(this, "setEditableMap test modelProducer " + this.modelProducer.getClass(0, 0));
        }
        this.mapTableModel.setModelProducer((ListModelProducerForVisualDatamap)this.modelProducer);
        if (this.theCellEditor instanceof SensitiveCellEditor) {
            ((SensitiveCellEditor)this.theCellEditor).setModelProducer(this.modelProducer);
            ((SensitiveCellEditor)this.theCellEditor).setForbiddenValues(this.mapTableModel.getShowOnlyValues());
            ((SensitiveCellEditor)this.theCellEditor).re_init();
        }
        this.editableColumn.setCellEditor(this.theCellEditor);
        if (map2 != null) {
            this.modelProducer = new ListModelProducerForVisualDatamap(this.table, map2, map);
            logging.info(this, "setEditableMap set new modelProducer " + this.modelProducer.getClass());
            logging.info(this, "setEditableMap test modelProducer " + this.modelProducer.getClass(0, 0));
        }
        this.mapTableModel.setModelProducer((ListModelProducerForVisualDatamap)this.modelProducer);
        ((SensitiveCellEditor)this.theCellEditor).setModelProducer(this.modelProducer);
        ((SensitiveCellEditor)this.theCellEditor).setForbiddenValues(this.mapTableModel.getShowOnlyValues());
        this.editableColumn.setCellEditor(this.theCellEditor);
    }

    @Override
    public void cancelOldCellEditing() {
        if (this.theCellEditor != null) {
            this.theCellEditor.cancelCellEditing();
        }
    }

    private boolean checkKey(String string) {
        boolean bl = false;
        if (string != null && !string.equals("")) {
            bl = true;
            if (this.names.indexOf(string) > -1) {
                bl = 0 == JOptionPane.showConfirmDialog(de.uib.configed.Globals.mainContainer, "Ein Eintrag mit diesem Namen existiert bereits. \u00dcberschreiben des bisherigen Eintrags?", Globals.APPNAME, 2);
            }
        }
        return bl;
    }

    private void addEntryFor(final String string) {
        String string2 = "";
        int n = this.table.getSelectedRow();
        if (n > -1) {
            string2 = (String)this.table.getValueAt(n, 0);
        }
        FEditText fEditText = new FEditText(string2, configed.getResourceValue("EditMapPanel.KeyToAdd")){

            @Override
            protected void commit() {
                super.commit();
                String string2 = this.getText();
                if (EditMapPanelX.this.checkKey(string2)) {
                    this.setVisible(false);
                    if (string.equals("java.lang.Boolean")) {
                        EditMapPanelX.this.addBooleanProperty(string2);
                    } else {
                        EditMapPanelX.this.addEmptyProperty(string2);
                    }
                }
            }
        };
        fEditText.setModal(true);
        fEditText.setSingleLine(true);
        fEditText.select(0, string2.length());
        fEditText.setTitle(Globals.APPNAME);
        fEditText.init(new Dimension(300, 50));
        if (n > -1) {
            Rectangle rectangle = this.table.getCellRect(n, 0, true);
            Point point = this.table.getLocationOnScreen();
            fEditText.setLocation((int)point.getX() + (int)rectangle.getX() + 50, (int)point.getY() + (int)rectangle.getY() + 28);
        } else {
            fEditText.centerOn(de.uib.configed.Globals.mainContainer);
        }
        fEditText.setVisible(true);
    }

    public void addEmptyProperty(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("");
        this.addProperty(string, arrayList);
        this.optionsMap.put(string, DefaultListCellOptions.getNewEmptyListCellOptions());
        this.mapTableModel.setMap(this.mapTableModel.getData());
        ((ListModelProducerForVisualDatamap)this.modelProducer).setData(this.optionsMap, this.mapTableModel.getData());
    }

    public void addBooleanProperty(String string) {
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
        arrayList.add(false);
        this.addProperty(string, arrayList);
        this.optionsMap.put(string, DefaultListCellOptions.getNewBooleanListCellOptions());
        this.mapTableModel.setMap(this.mapTableModel.getData());
        ((ListModelProducerForVisualDatamap)this.modelProducer).setData(this.optionsMap, this.mapTableModel.getData());
    }

    protected void addProperty(String string, Object object) {
        this.mapTableModel.addEntry(string, object);
        this.names = this.mapTableModel.getKeys();
        this.mapTableModel.fireTableDataChanged();
    }

    public void removeProperty(String string) {
        this.mapTableModel.removeEntry(string);
        this.names = this.mapTableModel.getKeys();
        this.mapTableModel.fireTableDataChanged();
    }

    private Map testData() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("key 1", "value 1");
        hashMap.put("key 2", "value 2");
        return hashMap;
    }

    public void stopEditing() {
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.stopEditing();
    }

    protected void setSelectedRow(int n) {
        this.table.setRowSelectionInterval(n, n);
        this.showSelectedRow();
    }

    protected void showSelectedRow() {
        int n = this.table.getSelectedRow();
        if (n != -1) {
            this.table.scrollRectToVisible(this.table.getCellRect(n, 0, false));
        }
    }
}

