/*
 * Decompiled with CFR 0.152.
 */
package de.uib.opsicommand.sshcommand;

import de.uib.configed.ConfigedMain;
import de.uib.configed.configed;
import de.uib.configed.gui.GeneralFrame;
import de.uib.configed.gui.ssh.SSHConnectionExecDialog;
import de.uib.configed.gui.ssh.SSHPackageManagerInstallParameterDialog;
import de.uib.opsicommand.sshcommand.CommandHelp;
import de.uib.opsicommand.sshcommand.CommandOpsiPackageManager;
import de.uib.opsicommand.sshcommand.SSHCommandNeedParameter;

public class CommandOpsiPackageManagerInstall
extends CommandOpsiPackageManager
implements SSHCommandNeedParameter {
    private String command = "opsi-package-manager";
    private boolean install;
    protected GeneralFrame frame;
    private boolean isMultiCommand = false;
    String opsiproduct = "";
    String depot = "";
    String verbosity = "";
    String freeInput = "";
    String updateInstalled = "";
    String setupInstalled = "";

    @Override
    public String getMenuText() {
        return configed.getResourceValue("SSHConnection.command.opsipackagemanager_install");
    }

    @Override
    public String getToolTipText() {
        return configed.getResourceValue("SSHConnection.command.opsipackagemanager_install.tooltip");
    }

    @Override
    public boolean isMultiCommand() {
        return this.isMultiCommand;
    }

    @Override
    public String getCommand() {
        this.command = "opsi-package-manager -q " + this.verbosity + this.depot + this.freeInput + this.opsiproduct;
        if (this.needSudo()) {
            return configed.getResourceValue("SSHConnection.sudoText") + " " + this.command + " 2>&1";
        }
        return this.command + " 2>&1";
    }

    @Override
    public void startParameterGui() {
        this.frame = new SSHPackageManagerInstallParameterDialog();
    }

    @Override
    public void startParameterGui(ConfigedMain configedMain) {
        this.frame = new SSHPackageManagerInstallParameterDialog(configedMain);
    }

    @Override
    public SSHConnectionExecDialog startHelpDialog() {
        CommandHelp commandHelp = new CommandHelp(this);
        SSHConnectionExecDialog sSHConnectionExecDialog = new SSHConnectionExecDialog(commandHelp, configed.getResourceValue("SSHConnection.Exec.title") + " \"" + commandHelp.getCommand() + "\" ");
        return sSHConnectionExecDialog;
    }

    @Override
    public GeneralFrame getDialog() {
        return this.frame;
    }

    public void setOpsiproduct(String string) {
        this.opsiproduct = string != "" ? " -i " + string : "";
    }

    public void setDepot(String string) {
        this.depot = string != "" ? " -d " + string : "";
    }

    public void setVerbosity(int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + "v";
        }
        this.verbosity = " -" + string + " ";
        if (n == 0) {
            this.verbosity = "";
        }
    }

    public void setFreeInput(String string) {
        this.freeInput = " " + string;
    }

    public boolean checkCommand() {
        return this.opsiproduct != "";
    }

    public void setUpdateInstalled(boolean bl) {
        this.updateInstalled = bl ? " --update " : "";
    }

    public void setSetupInstalled(boolean bl) {
        this.setupInstalled = bl ? " --setup " : "";
    }
}

