/*
 * Decompiled with CFR 0.152.
 */
package de.uib.opsicommand;

import de.uib.opsicommand.ConnectionState;
import de.uib.opsicommand.JSONExecutioner;
import de.uib.opsicommand.OpsiMethodCall;
import de.uib.utilities.logging.TimeCheck;
import de.uib.utilities.logging.logging;
import de.uib.utilities.thread.WaitCursor;
import java.awt.Cursor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import utils.Base64OutputStream;

public class JSONthroughHTTP
extends JSONExecutioner {
    public static boolean gzipTransmission = false;
    protected final int POST = 0;
    protected final int GET = 1;
    protected final String CODING_TABLE = "UTF8";
    protected String host;
    protected String username;
    protected String password;
    protected int portHTTP = 4444;
    public static final int defaultPort = 4447;
    protected int portHTTPS = 4447;
    protected boolean startConnecting = false;
    protected boolean endConnecting = false;
    protected URL serviceURL;
    protected String sessionId;
    protected String lastSessionId;
    protected int requestMethod = 0;
    public final Charset UTF8DEFAULT = Charset.forName("UTF-8");

    public JSONthroughHTTP(String string, String string2, String string3) {
        this.host = string;
        int n = string.indexOf(58);
        if (n > -1) {
            this.host = string.substring(0, n);
            this.portHTTP = this.portHTTPS = new Integer(string.substring(n + 1, string.length())).intValue();
        }
        this.username = string2;
        this.password = string3;
        this.conStat = new ConnectionState();
    }

    protected String makeRpcPath(OpsiMethodCall opsiMethodCall) {
        StringBuffer stringBuffer = new StringBuffer("/rpc");
        if (opsiMethodCall.getRpcPath() != null && !opsiMethodCall.getRpcPath().equals("")) {
            stringBuffer.append("/");
            stringBuffer.append(opsiMethodCall.getRpcPath());
        }
        return stringBuffer.toString();
    }

    protected String produceBaseURL(String string) {
        return "http://" + this.host + ":" + this.portHTTP + string;
    }

    private void appendGETParameter(String string, String string2) {
        if (this.requestMethod == 1) {
            try {
                String string3 = URLEncoder.encode(string2, "UTF8");
                string = string + "?" + string3;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                logging.error(this, unsupportedEncodingException.toString());
            }
        }
        logging.debug(this, "we shall try to connect to " + string);
        try {
            this.serviceURL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            logging.error(string + " no legal URL, " + malformedURLException.toString());
        }
    }

    public void makeURL(OpsiMethodCall opsiMethodCall) {
        logging.debug(this, "make url for " + opsiMethodCall);
        String string = this.produceBaseURL(this.makeRpcPath(opsiMethodCall));
        String string2 = opsiMethodCall.getJsonString();
        this.appendGETParameter(string, string2);
    }

    protected String produceJSONstring(List<OpsiMethodCall> list) {
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; i < list.size(); ++i) {
            stringBuffer.append(list.get(i).getJsonString());
            if (i >= list.size() - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void makeURL(List<OpsiMethodCall> list) {
        logging.debug(this, "make url for " + list);
        if (list == null || list.size() == 0) {
            logging.error("missing method call");
            return;
        }
        String string = this.makeRpcPath(list.get(0));
        for (OpsiMethodCall object2 : list) {
            String string2 = this.makeRpcPath(object2);
            if (string2.equals(string)) continue;
            logging.error("no common RPC path:  " + string + " cf. " + list.get(0));
            return;
        }
        String string3 = this.produceBaseURL(string);
        String string4 = this.produceJSONstring(list);
        this.appendGETParameter(string3, string4);
    }

    protected HttpURLConnection produceConnection() throws IOException {
        return (HttpURLConnection)this.serviceURL.openConnection();
    }

    private void setGeneralRequestProperties(HttpURLConnection httpURLConnection) {
        String string = Base64OutputStream.encode(this.username + ":" + this.password);
        httpURLConnection.setRequestProperty("Authorization", "Basic " + string);
        if (gzipTransmission) {
            httpURLConnection.setRequestProperty("Accept-Encoding", "gzip");
        }
        httpURLConnection.setRequestProperty("User-Agent", "opsi config editor 4.0.7.1.3");
    }

    @Override
    public JSONObject retrieveJSONObject(OpsiMethodCall opsiMethodCall) {
        ArrayList<OpsiMethodCall> arrayList = new ArrayList<OpsiMethodCall>();
        arrayList.add(opsiMethodCall);
        List<JSONObject> list = this.retrieveJSONObjects(arrayList);
        if (list == null) {
            return null;
        }
        return list.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public List<JSONObject> retrieveJSONObjects(List<OpsiMethodCall> var1_1) {
        block61: {
            block59: {
                logging.info(this, "retrieveJSONObjects started");
                var2_2 = null;
                if (var1_1.size() > 0 && !var1_1.get(0).isBackground()) {
                    var2_2 = new WaitCursor(null, new Cursor(0), this.getClass().getName());
                }
                var3_3 = null;
                this.conStat = new ConnectionState(2);
                this.makeURL(var1_1);
                var4_4 = new TimeCheck(this, "retrieveJSONObject  FROM " + this.serviceURL + " \n" + var1_1);
                var4_4.start();
                var5_5 = null;
                try {
                    var5_5 = this.produceConnection();
                    this.setGeneralRequestProperties(var5_5);
                    if (this.requestMethod == 0) {
                        var5_5.setRequestMethod("POST");
                        var5_5.setDoOutput(true);
                        var5_5.setDoInput(true);
                        var5_5.setUseCaches(false);
                    } else {
                        var5_5.setRequestMethod("GET");
                    }
                    if (this.sessionId != null) {
                        var5_5.setRequestProperty("Cookie", this.sessionId);
                    }
                    logging.info(this, "retrieveJSONObjects request old or  new session ");
                    logging.info(this, "retrieveJSONObjects connected  new session ");
                    var5_5.connect();
                    if (this.requestMethod != 0) break block59;
                    var6_6 = null;
                    try {
                        var6_6 = new BufferedWriter(new OutputStreamWriter(var5_5.getOutputStream(), this.UTF8DEFAULT));
                        var7_9 = this.produceJSONstring(var1_1);
                        logging.debug(this, "(POST) sending: " + (String)var7_9);
                        var6_6.write((String)var7_9);
                        var6_6.flush();
                        var6_6.close();
                    }
                    catch (IOException var7_11) {
                        logging.info(this, "exception on writing json request " + var7_11);
                    }
                    finally {
                        logging.debug(this, "handling finally json request close");
                        if (var6_6 != null) {
                            try {
                                var6_6.close();
                            }
                            catch (IOException var7_12) {
                                logging.debug(this, "handling finally json request close " + var7_12);
                            }
                        }
                    }
                }
                catch (IOException var6_7) {
                    if (var2_2 != null) {
                        var2_2.stop();
                    }
                    WaitCursor.stopAll();
                    this.conStat = new ConnectionState(10, var6_7.toString());
                    logging.error("Exception on connecting, " + var6_7.toString());
                    return null;
                }
            }
            if (this.conStat.getState() != 2) break block61;
            try {
                logging.debug(this, "Response " + var5_5.getResponseCode() + " " + var5_5.getResponseMessage());
                var6_6 = new StringBuffer("");
                if (var5_5.getErrorStream() != null) {
                    var7_9 = null;
                    try {
                        var7_9 = new BufferedReader(new InputStreamReader(var5_5.getErrorStream(), this.UTF8DEFAULT));
                        while (var7_9.ready()) {
                            var6_6.append(var7_9.readLine());
                            var6_6.append("  ");
                        }
                        var7_9.close();
                    }
                    catch (IOException var8_15) {
                        logging.info(this, "exception on reading error stream " + var8_15);
                        throw new JSONCommunicationException("error on reading error stream");
                    }
                    finally {
                        logging.info(this, "handling finally reading error stream");
                        if (var7_9 != null) {
                            try {
                                var7_9.close();
                            }
                            catch (IOException var11_22) {
                                logging.info(this, "handling finally reading error stream " + var11_22);
                            }
                        }
                    }
                }
                logging.debug(this, "response code: " + var5_5.getResponseCode());
                if (var5_5.getResponseCode() == 202) ** GOTO lbl-1000
                if (var5_5.getResponseCode() == 200) lbl-1000:
                // 2 sources

                {
                    this.conStat = new ConnectionState(3, "ok");
                } else {
                    this.conStat = new ConnectionState(10, var5_5.getResponseMessage());
                    if (var5_5.getResponseCode() != 401) {
                        logging.error(this, "Response " + var5_5.getResponseCode() + " " + var5_5.getResponseMessage() + " " + var6_6.toString());
                    }
                }
                if (this.conStat.getState() != 3) break block61;
                var7_9 = var5_5.getHeaderField("Set-Cookie");
                if (var7_9 != null) {
                    this.lastSessionId = this.sessionId;
                    this.sessionId = var7_9.substring(0, var7_9.indexOf(";"));
                    v0 = var8_16 = this.sessionId != null && this.sessionId.equals(this.lastSessionId) == false;
                    if (var8_16) {
                        logging.info(this, "retrieveJSONObjects  got new session ");
                    }
                }
                var8_17 = false;
                var9_19 = false;
                if (var5_5.getHeaderField("Content-Encoding") != null) {
                    var8_17 = var5_5.getHeaderField("Content-Encoding").equalsIgnoreCase("gzip");
                    logging.debug(this, "gzipped " + var8_17);
                    var9_19 = var5_5.getHeaderField("Content-Encoding").equalsIgnoreCase("deflate");
                    logging.debug(this, "deflated " + var9_19);
                }
                var10_21 = null;
                if (var8_17 || var9_19) {
                    if (var9_19 || var5_5.getHeaderField("Content-Type").startsWith("gzip-application")) {
                        var11_23 = var5_5.getInputStream();
                        var10_21 = new InflaterInputStream((InputStream)var11_23);
                    } else {
                        var10_21 = new GZIPInputStream(var5_5.getInputStream());
                    }
                } else {
                    var10_21 = var5_5.getInputStream();
                }
                var11_23 = null;
                try {
                    var11_23 = new BufferedReader(new InputStreamReader(var10_21, this.UTF8DEFAULT));
                    var12_24 = var11_23.readLine();
                    if (var12_24 != null) {
                        var3_3 = new ArrayList<JSONObject>();
                        if (var1_1.size() > 1) {
                            var13_25 = new JSONArray(new JSONTokener(var12_24));
                            for (var14_28 = 0; var14_28 < var13_25.length(); ++var14_28) {
                                var3_3.add(var13_25.optJSONObject(var14_28));
                            }
                        } else {
                            var3_3.add(new JSONObject(var12_24));
                        }
                    }
                }
                catch (IOException var13_27) {
                    logging.info(this, "exception on receiving json " + var13_27);
                    logging.logTrace(var13_27);
                    throw new JSONCommunicationException("receiving json");
                }
                finally {
                    logging.debug(this, "handling finally receiving json close");
                    if (var11_23 != null) {
                        try {
                            var11_23.close();
                        }
                        catch (IOException var16_30) {
                            logging.info(this, "handling finally receiving json close " + var16_30);
                        }
                    }
                }
            }
            catch (Exception var6_8) {
                if (var2_2 != null) {
                    var2_2.stop();
                }
                WaitCursor.stopAll();
                logging.error(this, "Exception while data reading, " + var6_8.toString());
            }
        }
        var4_4.stop("retrieveJSONObject  got result " + (var3_3 != null) + " ");
        logging.info(this, "retrieveJSONObject ready");
        if (var2_2 != null) {
            var2_2.stop();
        }
        return var3_3;
    }

    public static void main(String[] stringArray) {
        String string = "";
        JSONthroughHTTP jSONthroughHTTP = new JSONthroughHTTP("194.31.185.160", "cn=admin,dc=uib,dc=local", "umwelt");
        jSONthroughHTTP.retrieveJSONObject(new OpsiMethodCall("getProductStates_listOfHashes", new String[]{"pcbon1.uib.local"}));
    }

    class JSONCommunicationException
    extends Exception {
        JSONCommunicationException(String string) {
            super(string);
        }
    }
}

