/*
 * Decompiled with CFR 0.152.
 */
package de.uib.opsicommand;

import de.uib.utilities.logging.logging;

public class ConnectionState {
    public static final int UNDEFINED = 0;
    public static final int NOT_CONNECTED = 1;
    public static final int STARTED_CONNECTING = 2;
    public static final int CONNECTED = 3;
    public static final int CLOSING = 5;
    public static final int INTERRUPTED = 6;
    public static final int ERROR = 10;
    protected int myState = 1;
    public static ConnectionState ConnectionUndefined = new ConnectionState(0, "not initialized");
    protected String message = "";
    private static int instancesCount = 0;

    public ConnectionState(int n, String string) {
        this.myState = n;
        this.message = string;
        ++instancesCount;
    }

    public ConnectionState(int n) {
        this(n, "");
    }

    public ConnectionState() {
        this(0, "");
    }

    public static int getInstancesCount() {
        return instancesCount;
    }

    public int getState() {
        return this.myState;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(Object object) {
        if (object instanceof Integer) {
            return this.myState == (Integer)object;
        }
        if (object instanceof ConnectionState) {
            return this.myState == ((ConnectionState)object).getState();
        }
        return false;
    }

    public String toString() {
        switch (this.myState) {
            case 0: {
                return "Undefined state";
            }
            case 6: {
                return "Interrupted ";
            }
            case 1: {
                return "Not connected";
            }
            case 2: {
                return "Started connecting";
            }
            case 3: {
                return "Connected";
            }
            case 5: {
                return "Closing";
            }
            case 10: {
                return "Error";
            }
        }
        return "UNKNOWN State";
    }

    public void waitForConnection(int n) {
        int n2 = 200;
        int n3 = 5;
        int n4 = 0;
        int n5 = 0;
        while (this.getState() != 3 && (n == 0 || n5 < n)) {
            try {
                Thread.sleep(n2);
                logging.debug(this, "countWait " + ++n4 + " waited, thread " + Thread.currentThread().getName() + " " + this.toString());
                n5 = n4 / n3;
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

