/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.gui.ssh;

import de.uib.configed.ConfigedMain;
import de.uib.configed.Globals;
import de.uib.configed.configed;
import de.uib.configed.gui.GeneralFrame;
import de.uib.configed.gui.ssh.SSHConnectionExecDialog;
import de.uib.opsicommand.sshcommand.CommandDeployClientAgent;
import de.uib.opsicommand.sshcommand.SSHConnectExec;
import de.uib.utilities.logging.logging;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SSHDeployClientAgentParameterDialog
extends GeneralFrame {
    private GroupLayout layout;
    private JPanel inputPanel = new JPanel();
    private JPanel buttonPanel = new JPanel();
    private JPanel winAuthPanel = new JPanel();
    private JLabel lbl_client = new JLabel();
    private JLabel lbl_user = new JLabel();
    private JLabel lbl_passw = new JLabel();
    private JLabel lbl_defaultUserdata = new JLabel();
    private JLabel lbl_keepClientsOnFailure = new JLabel();
    private JLabel lbl_verbosity = new JLabel();
    private JLabel lbl_fullCommand = new JLabel();
    private JButton btn_execute;
    private JButton btn_execute_close;
    private JButton btn_close;
    private JButton btn_help;
    private JTextField tf_client;
    private JTextField tf_user;
    private JPasswordField tf_passw;
    private JCheckBox cb_passw_echo;
    private JButton btn_showPassw;
    private JCheckBox cb_defaultUserdata;
    private JCheckBox cb_keepClientsOnFailure;
    private JComboBox cb_verbosity;
    private String defaultWinUser = "Administrator";
    private final int frameLength = 500;
    private final int frameHight = 350;
    private CommandDeployClientAgent commandDeployClientAgent = new CommandDeployClientAgent();
    private ConfigedMain main;
    boolean aktive = true;

    public SSHDeployClientAgentParameterDialog() {
        this((ConfigedMain)null);
    }

    public SSHDeployClientAgentParameterDialog(ConfigedMain configedMain) {
        super((Frame)null, configed.getResourceValue("SSHConnection.ParameterDialog.deploy-clientagent.title"), false);
        this.main = configedMain;
        this.defaultWinUser = configed.getResourceValue("SSHConnection.ParameterDialog.deploy-clientagent.defaultWinUser");
        this.init();
        this.pack();
        this.centerOn(Globals.mainFrame);
        this.setBackground(Globals.backLightBlue);
        this.setSize(500, 350);
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
        logging.info(this, "SSHDeployClientAgentParameterDialog build");
    }

    protected void init() {
        this.inputPanel.setBackground(Globals.backLightBlue);
        this.buttonPanel.setBackground(Globals.backLightBlue);
        this.winAuthPanel.setBackground(Globals.backLightBlue);
        this.getContentPane().add((Component)this.inputPanel, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.buttonPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.inputPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.winAuthPanel.setBorder(new LineBorder(Globals.blueGrey));
        this.inputPanel.setPreferredSize(new Dimension(376, 220));
        this.lbl_verbosity.setText(configed.getResourceValue("SSHConnection.ParameterDialog.jLabelVerbosity"));
        this.cb_verbosity = new JComboBox();
        this.cb_verbosity.setToolTipText(configed.getResourceValue("SSHConnection.ParameterDialog.tooltip.verbosity"));
        for (int i = 0; i < 5; ++i) {
            this.cb_verbosity.addItem(i);
        }
        this.cb_verbosity.setSelectedItem(1);
        this.cb_verbosity.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SSHDeployClientAgentParameterDialog.this.changeVerbosity();
            }
        });
        this.lbl_client.setText(configed.getResourceValue("SSHConnection.ParameterDialog.deploy-clientagent.jLabelClient"));
        this.tf_client = new JTextField();
        this.tf_client.setToolTipText(configed.getResourceValue("SSHConnection.ParameterDialog.deploy-clientagent.tooltip.tf_client"));
        this.tf_client.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                SSHDeployClientAgentParameterDialog.this.changeClient();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                SSHDeployClientAgentParameterDialog.this.changeClient();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                SSHDeployClientAgentParameterDialog.this.changeClient();
            }
        });
        this.lbl_user.setText(configed.getResourceValue("SSHConnection.ParameterDialog.deploy-clientagent.jLabelUser"));
        this.tf_user = new JTextField(this.defaultWinUser);
        this.tf_user.setToolTipText(configed.getResourceValue("SSHConnection.ParameterDialog.deploy-clientagent.tooltip.tf_user"));
        this.tf_user.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                SSHDeployClientAgentParameterDialog.this.changeUser();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                SSHDeployClientAgentParameterDialog.this.changeUser();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                SSHDeployClientAgentParameterDialog.this.changeUser();
            }
        });
        this.lbl_passw.setText(configed.getResourceValue("SSHConnection.ParameterDialog.deploy-clientagent.jLabelPassword"));
        this.tf_passw = new JPasswordField("nt123", 15);
        this.tf_passw.setEchoChar('*');
        this.cb_passw_echo = new JCheckBox(configed.getResourceValue("SSHConnection.ParameterDialog.deploy-clientagent.showPassword"));
        this.btn_showPassw = new JButton("", Globals.createImageIcon("images/eye_open.png", ""));
        this.btn_showPassw.setPreferredSize(new Dimension(24, 24));
        this.btn_showPassw.setToolTipText(configed.getResourceValue("SSHConnection.ParameterDialog.deploy-clientagent.showPassword.tooltip"));
        this.btn_showPassw.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SSHDeployClientAgentParameterDialog.this.changeEchoChar();
            }
        });
        this.tf_passw.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                SSHDeployClientAgentParameterDialog.this.changePassw();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                SSHDeployClientAgentParameterDialog.this.changePassw();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                SSHDeployClientAgentParameterDialog.this.changePassw();
            }
        });
        this.lbl_defaultUserdata.setText(configed.getResourceValue("SSHConnection.ParameterDialog.deploy-clientagent.useDefaultWinAuthentication"));
        this.cb_defaultUserdata = new JCheckBox();
        this.addListener(this.cb_defaultUserdata, "winAuth");
        this.cb_defaultUserdata.setSelected(true);
        this.lbl_keepClientsOnFailure.setText(configed.getResourceValue("SSHConnection.ParameterDialog.deploy-clientagent.jLabelkeepClientsOnFailure"));
        this.cb_keepClientsOnFailure = new JCheckBox();
        this.cb_keepClientsOnFailure.setSelected(true);
        this.cb_keepClientsOnFailure.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SSHDeployClientAgentParameterDialog.this.changeKeepClient();
            }
        });
        this.btn_help = new JButton("", Globals.createImageIcon("images/help.gif", ""));
        this.btn_help.setToolTipText(configed.getResourceValue("SSHConnection.buttonHelp"));
        this.btn_help.setText(configed.getResourceValue("SSHConnection.buttonHelp"));
        this.buttonPanel.add(this.btn_help);
        this.btn_help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SSHDeployClientAgentParameterDialog.this.doActionHelp();
            }
        });
        this.btn_execute = new JButton();
        this.buttonPanel.add(this.btn_execute);
        this.btn_execute.setText(configed.getResourceValue("SSHConnection.buttonExec"));
        this.btn_execute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SSHDeployClientAgentParameterDialog.this.doAction1();
            }
        });
        this.btn_execute_close = new JButton();
        this.buttonPanel.add(this.btn_execute_close);
        this.btn_execute_close.setText(configed.getResourceValue("SSHConnection.buttonExecClose"));
        this.btn_execute_close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SSHDeployClientAgentParameterDialog.this.doAction1();
                SSHDeployClientAgentParameterDialog.this.doAction2();
            }
        });
        this.btn_close = new JButton();
        this.buttonPanel.add(this.btn_close);
        this.btn_close.setText(configed.getResourceValue("SSHConnection.buttonClose"));
        this.btn_close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SSHDeployClientAgentParameterDialog.this.doAction2();
            }
        });
        this.lbl_fullCommand.setText("opsi-deploy-client-agent ");
        this.updateCommand();
        String[] stringArray = this.main.getSelectedClients();
        if (stringArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            for (String string : stringArray) {
                stringBuffer.append(string);
                stringBuffer.append(" ");
            }
            this.tf_client.setText(stringBuffer.toString());
        }
        this.changeClient();
        this.changeUser();
        this.changePassw();
        this.changeKeepClient();
        this.changeVerbosity();
        this.initLayout();
    }

    private void updateCommand() {
        this.lbl_fullCommand.setText(this.commandDeployClientAgent.getCommand());
    }

    private void changeVerbosity() {
        this.commandDeployClientAgent.setVerbosity((Integer)this.cb_verbosity.getSelectedItem());
    }

    private void changeKeepClient() {
        this.commandDeployClientAgent.setKeepClient(this.cb_keepClientsOnFailure.isSelected());
    }

    private void changeClient() {
        this.commandDeployClientAgent.setClient(this.tf_client.getText().trim());
        this.updateCommand();
    }

    private void changeUser() {
        if (!this.tf_user.getText().equals(this.defaultWinUser)) {
            this.commandDeployClientAgent.setUser(this.tf_user.getText().trim());
        } else {
            this.commandDeployClientAgent.setUser("");
        }
        this.updateCommand();
    }

    private void changePassw() {
        this.commandDeployClientAgent.setPassw(this.tf_passw.getText().trim());
        this.updateCommand();
    }

    public void changeEchoChar() {
        if (this.aktive) {
            this.aktive = false;
            this.tf_passw.setEchoChar('*');
        } else {
            this.aktive = true;
            this.tf_passw.setEchoChar('\u0000');
        }
    }

    public void setComponentsEditable(boolean bl) {
        this.tf_user.setEnabled(bl);
        this.tf_passw.setEnabled(bl);
    }

    private void addListener(Object object, String string) {
        if (object instanceof JCheckBox && string != null && string.equals("winAuth")) {
            ((JCheckBox)object).addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        SSHDeployClientAgentParameterDialog.this.setComponentsEditable(false);
                    } else {
                        SSHDeployClientAgentParameterDialog.this.setComponentsEditable(true);
                    }
                }
            });
        }
    }

    protected void doAction2() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    protected void doAction1() {
        try {
            logging.info(this, "doAction1 deploy-clientagent ");
            SSHConnectExec sSHConnectExec = new SSHConnectExec();
            sSHConnectExec.exec(this.commandDeployClientAgent);
        }
        catch (Exception exception) {
            logging.warning(this, "doAction1, exception occurred " + exception);
            logging.logTrace(exception);
        }
    }

    protected void doActionHelp() {
        SSHConnectionExecDialog sSHConnectionExecDialog = this.commandDeployClientAgent.startHelpDialog();
        sSHConnectionExecDialog.setVisible(true);
    }

    private void initLayout() {
        int n = -2;
        int n2 = Short.MAX_VALUE;
        GroupLayout.Alignment alignment = GroupLayout.Alignment.LEADING;
        GroupLayout groupLayout = new GroupLayout(this.winAuthPanel);
        this.winAuthPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(alignment).addGroup(groupLayout.createSequentialGroup().addGap(10).addGroup(groupLayout.createParallelGroup(alignment).addGap(10).addGroup(groupLayout.createSequentialGroup().addGap(5).addComponent(this.lbl_user)).addGap(10).addGroup(groupLayout.createSequentialGroup().addGap(5).addComponent(this.lbl_passw)).addGap(10)).addGap(10).addGroup(groupLayout.createParallelGroup(alignment).addGap(10).addComponent(this.tf_user, n, n, n2).addGap(10).addComponent(this.tf_passw, n, n, n2).addGap(10)).addGroup(groupLayout.createParallelGroup(alignment).addGap(10).addComponent(this.btn_showPassw, n, n, n).addGap(10)).addGap(10))));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(alignment).addGroup(groupLayout.createSequentialGroup().addGap(10).addGroup(groupLayout.createParallelGroup(alignment).addGap(10).addComponent(this.lbl_user).addGap(10).addComponent(this.tf_user)).addGap(10).addGroup(groupLayout.createParallelGroup(alignment).addGap(10).addComponent(this.lbl_passw).addGap(10).addComponent(this.tf_passw, n, n, n).addGap(10).addComponent(this.btn_showPassw, n, n, n).addGap(10)).addGap(10))));
        GroupLayout groupLayout2 = new GroupLayout(this.inputPanel);
        this.inputPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup().addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup().addComponent(this.lbl_client, n, n, n)).addGap(10).addGroup(groupLayout2.createParallelGroup().addComponent(this.tf_client, n, n, n2))).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup().addComponent(this.lbl_defaultUserdata, n, n, n2)).addGap(10).addGroup(groupLayout2.createParallelGroup().addComponent(this.cb_defaultUserdata, n, n, n))).addComponent(this.winAuthPanel, n, n, n2).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup().addComponent(this.lbl_keepClientsOnFailure, n, n, n2)).addGap(10).addGroup(groupLayout2.createParallelGroup().addComponent(this.cb_keepClientsOnFailure, n, n, n))).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup().addComponent(this.lbl_verbosity, n, n, n2)).addGap(10).addGroup(groupLayout2.createParallelGroup().addComponent(this.cb_verbosity, n, n, n)))).addContainerGap());
        groupLayout2.setVerticalGroup(groupLayout2.createSequentialGroup().addGap(10).addGroup(groupLayout2.createParallelGroup(alignment).addComponent(this.lbl_client, alignment, n, n, n).addGap(10).addComponent(this.tf_client, alignment, n, n, n)).addGap(10).addGroup(groupLayout2.createParallelGroup(alignment).addComponent(this.lbl_defaultUserdata, alignment, n, n, n2).addGap(10).addComponent(this.cb_defaultUserdata, alignment, n, n, n)).addGap(10).addComponent(this.winAuthPanel, n, n, n).addGap(10).addGroup(groupLayout2.createParallelGroup(alignment).addComponent(this.lbl_keepClientsOnFailure, alignment, n, n, n).addGap(10).addComponent(this.cb_keepClientsOnFailure, alignment, n, n, n)).addGap(10).addGroup(groupLayout2.createParallelGroup(alignment).addComponent(this.lbl_verbosity, alignment, n, n, n).addGap(10).addComponent(this.cb_verbosity, alignment, n, n, n)));
    }
}

