/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.gui.ssh;

import de.uib.configed.ConfigedMain;
import de.uib.configed.Globals;
import de.uib.configed.configed;
import de.uib.configed.gui.GeneralFrame;
import de.uib.configed.gui.MainFrame;
import de.uib.opsicommand.sshcommand.SSHConnect;
import de.uib.utilities.logging.logging;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class SSHConfigDialog
extends GeneralFrame {
    private GroupLayout gpl;
    private JPanel serverPanel = new JPanel();
    private JPanel buttonPanel = new JPanel();
    private JCheckBox cb_useDefault;
    private JCheckBox cb_useOuputColor;
    private JCheckBox cb_execInBackground;
    private JButton btn_save;
    private JButton btn_close;
    private JLabel lbl_serverConfig = new JLabel();
    private JLabel lbl_host = new JLabel();
    private JLabel lbl_user = new JLabel();
    private JLabel lbl_passw = new JLabel();
    private JTextField tf_host;
    private JTextField tf_user;
    private JPasswordField tf_passw;
    private MainFrame main;
    private static SSHConfigDialog instance;

    private SSHConfigDialog(Frame frame) {
        super(frame, configed.getResourceValue("SSHConnection.Config.title"), false);
        this.main = (MainFrame)frame;
        this.init();
        this.pack();
        this.centerOn(this.main);
        this.setSize(450, 350);
        this.setVisible(true);
    }

    public static SSHConfigDialog getInstance(Frame frame) {
        if (instance == null) {
            instance = new SSHConfigDialog(frame);
        }
        instance.setVisible(true);
        return instance;
    }

    protected void init() {
        logging.debug(this, "sshConfigDialog init ");
        this.serverPanel.setBackground(Globals.backLightBlue);
        this.buttonPanel.setBackground(Globals.backLightBlue);
        this.getContentPane().add((Component)this.serverPanel, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        GroupLayout groupLayout = new GroupLayout(this.serverPanel);
        this.serverPanel.setLayout(groupLayout);
        this.buttonPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.serverPanel.setBorder(BorderFactory.createTitledBorder(configed.getResourceValue("SSHConnection.Config.serverPanelTitle")));
        this.serverPanel.setPreferredSize(new Dimension(376, 220));
        this.lbl_host = new JLabel();
        this.lbl_host.setText(configed.getResourceValue("SSHConnection.Config.jLabelHost"));
        this.tf_host = new JTextField();
        this.tf_host.setText(ConfigedMain.HOST);
        this.lbl_user = new JLabel();
        this.lbl_user.setText(configed.getResourceValue("SSHConnection.Config.jLabelUser"));
        this.tf_user = new JTextField();
        this.tf_user.setText(ConfigedMain.USER);
        this.lbl_passw = new JLabel();
        this.lbl_passw.setText(configed.getResourceValue("SSHConnection.Config.jLabelPassword"));
        this.tf_passw = new JPasswordField();
        this.tf_passw.setText(ConfigedMain.PASSWORD);
        this.btn_save = new JButton();
        this.buttonPanel.add(this.btn_save);
        this.btn_save.setText(configed.getResourceValue("SSHConnection.buttonSave"));
        this.btn_save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SSHConfigDialog.this.doAction1();
            }
        });
        this.btn_close = new JButton();
        this.buttonPanel.add(this.btn_close);
        this.btn_close.setText(configed.getResourceValue("SSHConnection.buttonClose"));
        this.btn_close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SSHConfigDialog.this.doAction2();
            }
        });
        this.cb_useDefault = new JCheckBox();
        this.cb_useDefault.setText(configed.getResourceValue("SSHConnection.Config.useDefaultAuthentication"));
        this.cb_useDefault.setSelected(true);
        this.setComponentsEditable(false);
        this.cb_useDefault.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    SSHConfigDialog.this.setComponentsEditable(false);
                } else {
                    SSHConfigDialog.this.setComponentsEditable(true);
                }
            }
        });
        this.cb_useOuputColor = new JCheckBox();
        this.cb_useOuputColor.setText(configed.getResourceValue("SSHConnection.Config.coloredOutput"));
        this.cb_useOuputColor.setSelected(true);
        Globals.ssh_colored_output = true;
        this.cb_useOuputColor.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                Globals.ssh_colored_output = itemEvent.getStateChange() == 1;
            }
        });
        this.cb_execInBackground = new JCheckBox();
        this.cb_execInBackground.setText(configed.getResourceValue("SSHConnection.Config.AlwaysExecBackground"));
        this.cb_execInBackground.setSelected(Globals.ssh_always_exec_in_background);
        this.cb_execInBackground.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                Globals.ssh_always_exec_in_background = itemEvent.getStateChange() == 1;
            }
        });
        logging.debug(this, "sshConfigDialog building layout ");
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup().addComponent(this.cb_useDefault, -2, -2, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup().addComponent(this.lbl_host, -2, -2, -2).addComponent(this.lbl_user, -2, -2, -2).addComponent(this.lbl_passw, -2, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup().addComponent(this.tf_host, -2, -2, Short.MAX_VALUE).addComponent(this.tf_user, -2, -2, Short.MAX_VALUE).addComponent(this.tf_passw, -2, -2, Short.MAX_VALUE))).addComponent(this.cb_useOuputColor, -2, -2, Short.MAX_VALUE).addComponent(this.cb_execInBackground, -2, -2, Short.MAX_VALUE)).addContainerGap());
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGap(10).addComponent(this.cb_useDefault, -2, -2, -2).addGap(10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tf_host, GroupLayout.Alignment.BASELINE, -2, -2, -2).addComponent(this.lbl_host, GroupLayout.Alignment.BASELINE, -2, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tf_user, GroupLayout.Alignment.BASELINE, -2, -2, -2).addComponent(this.lbl_user, GroupLayout.Alignment.BASELINE, -2, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tf_passw, GroupLayout.Alignment.BASELINE, -2, -2, -2).addComponent(this.lbl_passw, GroupLayout.Alignment.BASELINE, -2, -2, -2)).addGap(10).addComponent(this.cb_useOuputColor, -2, -2, -2).addGap(10).addComponent(this.cb_execInBackground, -2, -2, -2).addGap(10).addContainerGap(70, 70));
    }

    public void setComponentsEditable(boolean bl) {
        this.tf_host.setEnabled(bl);
        this.tf_user.setEnabled(bl);
        this.tf_passw.setEnabled(bl);
    }

    @Override
    protected void doAction1() {
        SSHConnect.setUserData(this.tf_host.getText(), this.tf_user.getText(), this.tf_passw.getText());
        this.doAction2();
    }

    protected void doAction2() {
        this.setVisible(false);
    }
}

