/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.gui;

import de.uib.configed.ConfigedMain;
import de.uib.configed.Globals;
import de.uib.configed.configed;
import de.uib.opsicommand.ConnectionState;
import de.uib.opsicommand.JSONthroughHTTP;
import de.uib.opsidatamodel.PersistenceController;
import de.uib.opsidatamodel.PersistenceControllerFactory;
import de.uib.utilities.logging.logging;
import de.uib.utilities.swing.Containership;
import de.uib.utilities.swing.PanelLinedComponents;
import de.uib.utilities.swing.ProgressBarPainter;
import de.uib.utilities.thread.WaitCursor;
import de.uib.utilities.thread.WaitingSleeper;
import de.uib.utilities.thread.WaitingWorker;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DPassword
extends JDialog {
    private final String TESTSERVER = "";
    private final String TESTUSER = "";
    private final String TESTPASSWORD = "";
    private static final int SECS_WAIT_FOR_CONNECTION = 100;
    final long TIMEOUT_MS = 100000L;
    private boolean localApp;
    private final long ESTIMATED_TOTAL_WAIT_MILLIS = 10000L;
    ConfigedMain main;
    PersistenceController persis;
    Cursor saveCursor;
    WaitCursor waitCursor;
    boolean connected = false;
    Globals dm;
    Dimension screenSize;
    WaitInfo waitInfo;
    WaitingWorker waitingTask;
    JPanel panel;
    Containership containership;
    int defaultBlinkRate;
    JLabel jLabelVersion = new JLabel();
    JLabel jLabelUser = new JLabel();
    JTextField fieldUser = new JTextField();
    JPasswordField passwordField = new JPasswordField();
    JLabel jLabelPassword = new JLabel();
    JLabel jLabelHost = new JLabel();
    JComboBox fieldHost = new JComboBox();
    JPanel jPanelParameters1;
    JPanel jPanelParameters2;
    JPanel jPanelButtons = new JPanel();
    FlowLayout flowLayoutButtons = new FlowLayout();
    JButton jButtonCommit = new JButton();
    JButton jButtonCancel = new JButton();
    TitledBorder titledBorder1;
    JPanel jPanelRadioButtons = new JPanel();
    FlowLayout flowLayoutRadioButtons = new FlowLayout();
    JRadioButton jRadioButton_ssh2 = new JRadioButton();
    JRadioButton jRadioButton_localfs = new JRadioButton();
    MyKeyListener myKeyListener = new MyKeyListener(this);
    ButtonGroup buttonGroup1 = new ButtonGroup();

    public void setHost(String string) {
        if (string == null) {
            string = "";
        }
        this.fieldHost.setSelectedItem(string);
        this.fieldUser.requestFocus();
    }

    public void setServers(Vector<String> vector) {
        this.fieldHost.setModel(new DefaultComboBoxModel<String>(vector));
        ((JTextField)this.fieldHost.getEditor().getEditorComponent()).setCaretPosition(((String)this.fieldHost.getSelectedItem()).length());
    }

    public void setUser(String string) {
        if (string == null) {
            string = "";
        }
        this.fieldUser.setText(string);
        this.passwordField.requestFocus();
    }

    public void setPassword(String string) {
        if (string == null) {
            string = "";
        }
        this.passwordField.setText(string);
    }

    public DPassword(Frame frame, String string, boolean bl, ConfigedMain configedMain) {
        super(frame, string, bl);
        this.main = configedMain;
        this.screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        try {
            this.guiInit();
            this.pack();
            this.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public DPassword(ConfigedMain configedMain) {
        this(null, "", false, configedMain);
    }

    public DPassword(Frame frame, ConfigedMain configedMain) {
        this(frame, "", false, configedMain);
    }

    static void addComponent(Container container, GridBagLayout gridBagLayout, Component component, int n, int n2, int n3, int n4, double d, double d2) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    public void activate() {
        logging.info(this, "activate");
        this.panel.setEnabled(true);
        this.jButtonCommit.setEnabled(true);
    }

    void guiInit() throws Exception {
        MessageFormat messageFormat = new MessageFormat(configed.getResourceValue("DPassword.title"));
        this.setTitle(messageFormat.format(new Object[]{"opsi config editor"}));
        this.setIconImage(Globals.mainIcon);
        this.titledBorder1 = new TitledBorder("");
        this.panel = new JPanel();
        this.panel.setEnabled(false);
        Border border = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        this.panel.setBorder(border);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - 450) / 2, 200);
        this.jLabelHost.setText(configed.getResourceValue("DPassword.jLabelHost"));
        this.containership = new Containership(this.panel);
        this.defaultBlinkRate = this.fieldUser.getCaret().getBlinkRate();
        this.fieldHost.setEditable(true);
        this.fieldHost.setSelectedItem("");
        this.fieldHost.addKeyListener(this.myKeyListener);
        this.jLabelUser.setText(configed.getResourceValue("DPassword.jLabelUser"));
        this.fieldUser.setText("");
        this.fieldUser.addKeyListener(this.myKeyListener);
        this.fieldUser.setMargin(new Insets(0, 3, 0, 3));
        this.jLabelPassword.setText(configed.getResourceValue("DPassword.jLabelPassword"));
        this.passwordField.setText("");
        this.passwordField.addKeyListener(this.myKeyListener);
        this.passwordField.setMargin(new Insets(0, 3, 0, 3));
        JCheckBox jCheckBox = new JCheckBox(configed.getResourceValue("DPassword.checkGzip"), JSONthroughHTTP.gzipTransmission);
        jCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                JSONthroughHTTP.gzipTransmission = itemEvent.getStateChange() == 1;
                logging.debug(this, "itemStateChanged " + JSONthroughHTTP.gzipTransmission);
            }
        });
        final JTextField jTextField = new JTextField("" + configed.refreshMinutes);
        jTextField.setToolTipText(configed.getResourceValue("DPassword.pullReachableInfoTooltip"));
        jTextField.setPreferredSize(new Dimension(Globals.shortlabelDimension));
        jTextField.setHorizontalAlignment(4);
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            private void setRefreshMinutes() {
                String string = jTextField.getText();
                try {
                    configed.refreshMinutes = Integer.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    jTextField.setText("");
                }
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.setRefreshMinutes();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.setRefreshMinutes();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.setRefreshMinutes();
            }
        });
        this.jPanelParameters1 = new PanelLinedComponents(new JComponent[]{jCheckBox});
        this.jPanelParameters2 = new PanelLinedComponents(new JComponent[]{new JLabel(configed.getResourceValue("DPassword.pullReachableInfo")), jTextField, new JLabel(configed.getResourceValue("DPassword.pullReachableInfoMinutes"))});
        this.jPanelButtons.setLayout(this.flowLayoutButtons);
        this.jButtonCommit.setText(configed.getResourceValue("DPassword.jButtonCommit"));
        this.jButtonCommit.setMaximumSize(new Dimension(100, 20));
        this.jButtonCommit.setPreferredSize(new Dimension(100, 20));
        this.jButtonCommit.setToolTipText("");
        this.jButtonCommit.setSelected(true);
        this.jButtonCommit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPassword.this.jButtonCommit_actionPerformed(actionEvent);
            }
        });
        this.jButtonCancel.setText(configed.getResourceValue("DPassword.jButtonCancel"));
        this.jButtonCancel.setMaximumSize(new Dimension(100, 20));
        this.jButtonCancel.setPreferredSize(new Dimension(100, 20));
        this.jButtonCancel.setToolTipText("");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPassword.this.jButtonCancel_actionPerformed(actionEvent);
            }
        });
        this.jPanelButtons.add(this.jButtonCommit);
        this.jPanelButtons.add(this.jButtonCancel);
        GroupLayout groupLayout = new GroupLayout(this.panel);
        this.panel.setLayout(groupLayout);
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addComponent(this.jLabelVersion, -2, -2, -2).addGap(28).addComponent(this.jLabelHost, -2, -2, -2).addGap(2).addComponent(this.fieldHost, 28, 28, 28).addGap(28).addComponent(this.jLabelUser, -2, -2, -2).addGap(2).addComponent(this.fieldUser, 28, 28, 28).addGap(2).addComponent(this.jLabelPassword, -2, -2, -2).addGap(2).addComponent(this.passwordField, 28, 28, 28).addGap(28).addComponent(this.jPanelParameters1, 33, 33, 33).addComponent(this.jPanelParameters2, 33, 33, 33).addGap(28).addComponent(this.jPanelButtons, -2, -2, -2));
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup().addGroup(groupLayout.createSequentialGroup().addGap(10, 40, Short.MAX_VALUE).addComponent(this.jLabelVersion, -2, -2, -2).addGap(10, 40, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(10).addComponent(this.jLabelHost, -2, -2, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(this.fieldHost, -2, -2, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(10).addComponent(this.jLabelUser, -2, -2, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(this.fieldUser, -2, -2, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(10).addComponent(this.jLabelPassword, -2, -2, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(this.passwordField, -2, -2, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(10).addComponent(this.jPanelParameters1, -2, -2, Short.MAX_VALUE).addGap(10)).addGroup(groupLayout.createSequentialGroup().addGap(10).addComponent(this.jPanelParameters2, -2, -2, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(10).addComponent(this.jPanelButtons, -2, -2, Short.MAX_VALUE)));
        this.getContentPane().add(this.panel);
        Containership containership = new Containership(this.getContentPane());
        containership.doForAllContainedCompisOfClass("setBackground", new Object[]{Globals.backLightBlue}, JPanel.class);
        MessageFormat messageFormat2 = new MessageFormat(configed.getResourceValue("DPassword.jLabelVersion"));
        this.jLabelVersion.setText(messageFormat2.format(new Object[]{"4.0.7.1.3", "2016/06/24"}));
        String string = System.getProperty("os.name");
        String string2 = System.getProperty("os.version");
        logging.debugOut(3, " OS " + string + "  Version " + string2);
        String string3 = "";
        this.pack();
        if (string3.equals("")) {
            this.setHost("localhost");
            this.fieldHost.requestFocus();
            ((JTextField)this.fieldHost.getEditor().getEditorComponent()).setCaretPosition(((String)this.fieldHost.getSelectedItem()).length());
        }
        this.saveCursor = this.getCursor();
    }

    @Override
    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        try {
            this.containership.doForAllContainedCompis("setCursor", new Object[]{cursor});
        }
        catch (Exception exception) {
            logging.warning(this, "containership error " + exception);
            logging.logTrace(exception);
        }
    }

    public void ok_action() {
        if (this.waitCursor != null) {
            this.waitCursor.stop();
        }
        this.try_connecting();
    }

    public void try_connecting() {
        logging.info(this, "started  try_connecting");
        this.jButtonCommit.setEnabled(false);
        this.waitCursor = new WaitCursor((Component)this, "ok_action");
        ConfigedMain.HOST = (String)this.fieldHost.getSelectedItem();
        ConfigedMain.USER = this.fieldUser.getText();
        ConfigedMain.PASSWORD = String.valueOf(this.passwordField.getPassword());
        logging.info(this, "invoking PersistenceControllerFactory host, user, " + this.fieldHost.getSelectedItem() + ", " + this.fieldUser.getText());
        if (this.waitingTask != null && !this.waitingTask.isReady()) {
            logging.info(this, "old waiting task not ready");
            return;
        }
        if (this.waitInfo != null) {
            this.waitInfo.dispose();
            this.waitInfo = null;
        }
        this.waitInfo = new WaitInfo(100000L);
        Dimension dimension = this.waitInfo.getSize();
        this.waitInfo.setLocation((this.screenSize.width - dimension.width) / 2, (this.screenSize.height - dimension.height) / 2);
        this.waitInfo.setVisible(true);
        logging.info(this, "we are in EventDispatchThread " + SwingUtilities.isEventDispatchThread());
        logging.info(this, "we are in applet " + configed.isApplet);
        logging.info(this, "  Thread.currentThread() " + Thread.currentThread());
        this.localApp = ("" + Thread.currentThread()).indexOf("main]") > -1;
        logging.info(this, "is local app  " + this.localApp);
        if (this.localApp && !configed.isApplet) {
            this.waitInfo.setAlwaysOnTop(true);
            logging.info(this, "start WaitingWorker");
            this.waitingTask = new WaitingWorker(this.waitInfo);
            this.waitingTask.execute();
            new Thread(){

                @Override
                public void run() {
                    logging.info(this, "get persis");
                    DPassword.this.persis = PersistenceControllerFactory.getNewPersistenceController((String)DPassword.this.fieldHost.getSelectedItem(), DPassword.this.fieldUser.getText(), String.valueOf(DPassword.this.passwordField.getPassword()));
                    logging.info(this, "got persis, == null " + (DPassword.this.persis == null));
                    DPassword.this.waitingTask.setReady();
                }
            }.start();
        } else {
            this.persis = PersistenceControllerFactory.getNewPersistenceController((String)this.fieldHost.getSelectedItem(), this.fieldUser.getText(), String.valueOf(this.passwordField.getPassword()));
            long l = 2000L;
            long l2 = 0L;
            while (PersistenceControllerFactory.getConnectionState() == ConnectionState.ConnectionUndefined && l2 < 100000L) {
                try {
                    Thread.sleep(l);
                    l2 += l;
                }
                catch (Exception exception) {}
            }
            if (l2 >= 100000L) {
                logging.error(" no connection");
            }
            this.waitInfo.actAfterWaiting();
        }
    }

    void jButtonCommit_actionPerformed(ActionEvent actionEvent) {
        this.ok_action();
    }

    void end_program() {
        this.main.finishApp(false, 0);
    }

    void jButtonCancel_actionPerformed(ActionEvent actionEvent) {
        if (this.waitCursor != null) {
            this.waitCursor.stop();
        }
        this.end_program();
    }

    void passwordField_componentShown(ComponentEvent componentEvent) {
        this.passwordField.requestFocus();
    }

    @Override
    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            this.end_program();
        }
    }

    class MyKeyListener
    extends KeyAdapter {
        DPassword myHome;

        MyKeyListener(DPassword dPassword2) {
            this.myHome = dPassword2;
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                this.myHome.ok_action();
            } else if (keyEvent.getKeyCode() == 27) {
                this.myHome.end_program();
            }
        }
    }

    class WaitInfo
    extends JFrame
    implements WaitingSleeper {
        JLabel waitLabel;
        JProgressBar waitingProgressBar;
        long timeOutMillis;

        WaitInfo(long l) {
            logging.info(this, "created with timeout " + l);
            this.timeOutMillis = l;
            this.setIconImage(Globals.mainIcon);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    if (DPassword.this.persis.getConnectionState().getState() == 2) {
                        DPassword.this.persis.setConnectionState(new ConnectionState(6));
                    }
                    WaitInfo.this.setCursor(DPassword.this.saveCursor);
                }
            });
            this.setTitle("opsi config editor login");
            this.waitLabel = new JLabel();
            this.waitLabel.setText(configed.getResourceValue("DPassword.WaitInfo.label"));
            this.waitingProgressBar = new JProgressBar();
            this.waitingProgressBar.setValue(0);
            this.waitingProgressBar.setEnabled(true);
            UIDefaults uIDefaults = new UIDefaults();
            uIDefaults.put("ProgressBar[Enabled].foregroundPainter", new ProgressBarPainter(Globals.opsiLogoBlue));
            uIDefaults.put("ProgressBar[Enabled].backgroundPainter", new ProgressBarPainter(Globals.opsiLogoLightBlue));
            this.waitingProgressBar.putClientProperty("Nimbus.Overrides", uIDefaults);
            JPanel jPanel = new JPanel();
            GroupLayout groupLayout = new GroupLayout(jPanel);
            jPanel.setLayout(groupLayout);
            groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGap(10).addGroup(groupLayout.createSequentialGroup().addGap(5, 10, 10).addComponent(this.waitingProgressBar, 10, 10, 10).addGap(5, 10, 10).addComponent(this.waitLabel, -2, -2, -2).addGap(5, 10, 10)).addGap(5));
            groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGap(5).addGroup(groupLayout.createParallelGroup().addGroup(groupLayout.createSequentialGroup().addGap(10, 10, Short.MAX_VALUE).addComponent(this.waitingProgressBar, -2, -2, -2).addGap(10, 10, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, Short.MAX_VALUE).addComponent(this.waitLabel, -2, -2, -2).addGap(10, 10, Short.MAX_VALUE))).addGap(5));
            this.getContentPane().add(jPanel);
            this.pack();
            this.setAlwaysOnTop(true);
        }

        @Override
        public void actAfterWaiting() {
            DPassword.this.waitCursor.stop();
            if (PersistenceControllerFactory.getConnectionState().getState() == 3) {
                logging.info(this, "connected with persis " + DPassword.this.persis);
                DPassword.this.main.setPersistenceController(DPassword.this.persis);
                MessageFormat messageFormat = new MessageFormat(configed.getResourceValue("ConfigedMain.appTitle"));
                DPassword.this.main.setAppTitle(messageFormat.format(new Object[]{"opsi config editor", DPassword.this.fieldHost.getSelectedItem(), DPassword.this.fieldUser.getText()}));
                this.setVisible(false);
                DPassword.this.main.loadDataAndGo();
            } else {
                this.setVisible(true);
                if (PersistenceControllerFactory.getConnectionState().getState() == 6) {
                    logging.info(this, "interrupted");
                } else {
                    logging.info(this, "not connected, timeout or not authorized");
                    MessageFormat messageFormat = new MessageFormat(configed.getResourceValue("DPassword.noConnectionMessageDialog.content"));
                    if (DPassword.this.waitingTask != null && DPassword.this.waitingTask.isTimeoutReached()) {
                        messageFormat = new MessageFormat("Timeout in connecting");
                    }
                    JOptionPane.showMessageDialog(this, messageFormat.format(new Object[]{PersistenceControllerFactory.getConnectionState().getMessage()}), configed.getResourceValue("DPassword.noConnectionMessageDialog.title"), 1);
                }
                DPassword.this.passwordField.setText("");
                if (PersistenceControllerFactory.getConnectionState().getMessage().indexOf("authorized") > -1) {
                    logging.info(this, "(not) authorized");
                    DPassword.this.fieldUser.requestFocus();
                    DPassword.this.fieldUser.setCaretPosition(DPassword.this.fieldUser.getText().length());
                } else {
                    DPassword.this.fieldHost.requestFocus();
                }
                DPassword.this.activate();
            }
        }

        @Override
        public JProgressBar getProgressBar() {
            return this.waitingProgressBar;
        }

        @Override
        public JLabel getLabel() {
            return this.waitLabel;
        }

        @Override
        public long getStartActionMillis() {
            return new GregorianCalendar().getTimeInMillis();
        }

        @Override
        public long getWaitingMillis() {
            return this.timeOutMillis;
        }

        @Override
        public long getOneProgressBarLengthWaitingMillis() {
            return 10000L;
        }

        @Override
        public String setLabellingStrategy(long l) {
            return this.waitLabel.getText();
        }
    }
}

