/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities.observer;

import de.uib.configed.Globals;
import de.uib.configed.configed;
import de.uib.utilities.logging.logging;
import de.uib.utilities.observer.RunningInstancesObserver;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JOptionPane;

public class RunningInstances<T> {
    private Boolean reallyLeave = null;
    private String classname;
    private String askForLeave;
    private ConcurrentHashMap<T, String> instances;
    private List<RunningInstancesObserver<T>> observers;

    public RunningInstances(Class clazz, String string) {
        this.classname = clazz.getName();
        this.askForLeave = string;
        logging.info(this, "created for class " + this.classname);
        this.instances = new ConcurrentHashMap();
        this.observers = new ArrayList<RunningInstancesObserver<T>>();
    }

    public void add(T t, String string) {
        this.instances.put(t, string);
        this.sendChangeEvent();
    }

    public void forget(T t) {
        this.instances.remove(t);
        this.sendChangeEvent();
    }

    public Set<T> getAll() {
        return this.instances.keySet();
    }

    public boolean isEmpty() {
        boolean bl = this.instances.keySet().isEmpty();
        logging.info(this, " isEmpty " + bl);
        return bl;
    }

    public boolean askStop() {
        this.reallyLeave = false;
        int n = 1;
        n = JOptionPane.showOptionDialog(Globals.mainFrame, this.askForLeave, "opsi config editor " + configed.getResourceValue("ConfigedMain.Licences.AllowLeaveApp.title"), 0, 3, null, null, null);
        this.reallyLeave = n == 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        return this.reallyLeave;
    }

    public String toString() {
        return this.instances.toString();
    }

    public void addObserver(RunningInstancesObserver<T> runningInstancesObserver) {
        this.observers.add(runningInstancesObserver);
    }

    public void removeObserver(RunningInstancesObserver<T> runningInstancesObserver) {
        this.observers.remove(runningInstancesObserver);
    }

    protected void sendChangeEvent() {
        logging.debug(this, "sendChangeEvent observers: " + this.observers.size());
        for (RunningInstancesObserver<T> runningInstancesObserver : this.observers) {
            runningInstancesObserver.instancesChanged(this.getAll());
        }
    }
}

