/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities.datapanel;

import de.uib.configed.configed;
import de.uib.configed.guidata.ListMerger;
import de.uib.utilities.Globals;
import de.uib.utilities.datapanel.AbstractEditMapPanel;
import de.uib.utilities.datapanel.DefaultEditMapPanel;
import de.uib.utilities.datapanel.EditMapPanelX;
import de.uib.utilities.datapanel.SensitiveCellEditorForDataPanel;
import de.uib.utilities.logging.logging;
import de.uib.utilities.pdf.DocumentToPdf;
import de.uib.utilities.swing.PopupMenuTrait;
import de.uib.utilities.table.ListCellOptions;
import de.uib.utilities.tree.SimpleIconNodeRenderer;
import de.uib.utilities.tree.SimpleTreeModel;
import de.uib.utilities.tree.SimpleTreePath;
import de.uib.utilities.tree.XTree;
import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;
import utils.PopupMouseListener;

public class EditMapPanelGrouped
extends DefaultEditMapPanel
implements TreeSelectionListener {
    protected JSplitPane splitPane;
    final int initialSplitLoc = 350;
    protected XTree tree;
    protected JPanel rightPane;
    protected JLabel labelForRightPane;
    protected SimpleTreeModel treemodel;
    protected TreeMap<String, String> givenClasses;
    protected TreeSet<String> keyclasses;
    protected Map<String, String> tooltips4Keys;
    protected Map<String, AbstractEditMapPanel> partialPanels;
    protected TreeMap<String, Map<String, Object>> virtualLines;
    protected DocumentToPdf tableToPDF;
    protected int hGap = 5;
    protected int vGap = 5;

    public EditMapPanelGrouped() {
        this((TableCellRenderer)null);
    }

    public EditMapPanelGrouped(TableCellRenderer tableCellRenderer) {
        this(tableCellRenderer, false);
    }

    public EditMapPanelGrouped(TableCellRenderer tableCellRenderer, boolean bl) {
        this(tableCellRenderer, bl, true);
    }

    public EditMapPanelGrouped(TableCellRenderer tableCellRenderer, boolean bl, boolean bl2) {
        this(tableCellRenderer, bl, bl2, false);
    }

    public EditMapPanelGrouped(TableCellRenderer tableCellRenderer, boolean bl, boolean bl2, boolean bl3) {
        this(tableCellRenderer, bl, bl2, bl3, null);
    }

    public EditMapPanelGrouped(TableCellRenderer tableCellRenderer, boolean bl, boolean bl2, boolean bl3, TreeMap<String, String> treeMap) {
        this(tableCellRenderer, bl, bl2, bl3, treeMap, null);
    }

    public EditMapPanelGrouped(TableCellRenderer tableCellRenderer, boolean bl, boolean bl2, boolean bl3, TreeMap<String, String> treeMap, final AbstractEditMapPanel.Actor actor) {
        super(tableCellRenderer, bl, bl2, bl3);
        this.buildPanel();
        this.actor = actor;
        this.givenClasses = treeMap;
        this.popup = new PopupMenuTrait(new Integer[]{8, 4}){

            @Override
            public void action(int n) {
                logging.info(this, "popup " + n);
                switch (n) {
                    case 4: {
                        EditMapPanelGrouped.this.reload();
                        break;
                    }
                    case 8: {
                        actor.saveData();
                    }
                }
            }
        };
        PopupMouseListener popupMouseListener = new PopupMouseListener(this.popup);
        this.tree.addMouseListener(popupMouseListener);
    }

    protected void generateParts() {
        this.tooltips4Keys = this.givenClasses;
        this.partialPanels = new HashMap<String, AbstractEditMapPanel>();
        for (String string : this.keyclasses) {
            EditMapPanelX editMapPanelX = new EditMapPanelX(this.tableCellRenderer, this.keylistExtendible, this.keylistEditable, this.reloadable){

                protected void reload() {
                    TreePath treePath = EditMapPanelGrouped.this.tree.getSelectionPath();
                    int n = EditMapPanelGrouped.this.tree.getRowForPath(treePath);
                    this.actor.reloadData();
                    if (treePath != null) {
                        EditMapPanelGrouped.this.tree.setExpandsSelectedPaths(true);
                        EditMapPanelGrouped.this.tree.setSelectionInterval(n, n);
                        EditMapPanelGrouped.this.tree.scrollRowToVisible(n);
                    }
                }

                @Override
                protected JPopupMenu definePopup() {
                    PopupMenuTrait popupMenuTrait = new PopupMenuTrait(new Integer[]{8, 4, 12}){

                        @Override
                        public void action(int n) {
                            switch (n) {
                                case 4: {
                                    this.reload();
                                    break;
                                }
                                case 8: {
                                    actor.saveData();
                                    break;
                                }
                                case 12: {
                                    EditMapPanelGrouped.this.createPDF();
                                }
                            }
                        }
                    };
                    return popupMenuTrait;
                }
            };
            editMapPanelX.setCellEditor(SensitiveCellEditorForDataPanel.getInstance(string));
            editMapPanelX.setActor(this.actor);
            this.partialPanels.put(string, editMapPanelX);
        }
    }

    private void createPDF() {
        String string = "";
        string = this.tree.getSelectionPath().getPathComponent(0).toString().trim();
        logging.info(this, "------------- create report");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("header", configed.getResourceValue("EditMapPanelGrouped.createPDF.title"));
        hashMap.put("title", configed.getResourceValue("Client: " + string));
        hashMap.put("subject", "report of table");
        hashMap.put("keywords", configed.getResourceValue("EditMapPanelGrouped.createPDF.title") + " " + string);
        this.tableToPDF = new DocumentToPdf(null, hashMap);
        this.tableToPDF.createContentElement("table", this.createJTableForPDF());
        this.tableToPDF.setPageSizeA4();
        this.tableToPDF.toPDF();
    }

    private JTable createJTableForPDF() {
        DefaultTableModel defaultTableModel = new DefaultTableModel();
        JTable jTable = new JTable(defaultTableModel);
        defaultTableModel.addColumn(configed.getResourceValue("EditMapPanelGrouped.createJTableForPDF.property_name"));
        defaultTableModel.addColumn(configed.getResourceValue("EditMapPanelGrouped.createJTableForPDF.property_value"));
        Vector<String> vector = this.mapTableModel.getKeys();
        Iterator<String> iterator = vector.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            String string2 = "";
            ListMerger listMerger = (ListMerger)this.mapTableModel.getData().get(string);
            if (!listMerger.isEmpty()) {
                string2 = listMerger.getValue().get(0).toString();
            }
            Vector<String> vector2 = new Vector<String>();
            if (string.contains("saved_search")) continue;
            vector2.add(string);
            vector2.add(string2);
            defaultTableModel.addRow(vector2);
        }
        return jTable;
    }

    protected void reload() {
        logging.info(this, "reload");
        TreePath treePath = this.tree.getSelectionPath();
        int n = this.tree.getRowForPath(treePath);
        this.actor.reloadData();
        logging.debug(this, "reloaded, return to " + treePath);
        if (treePath != null) {
            this.tree.setExpandsSelectedPaths(true);
            this.tree.setSelectionInterval(n, n);
            this.tree.scrollRowToVisible(n);
        }
    }

    @Override
    protected void buildPanel() {
        this.splitPane = new JSplitPane();
        this.splitPane.setBackground(Color.red);
        this.setBackground(Globals.backNimbus);
        this.tree = new XTree();
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.tree.setCellRenderer(new SimpleIconNodeRenderer());
        this.tree.expandAll();
        this.tree.addTreeSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jScrollPane.setVerticalScrollBarPolicy(22);
        this.rightPane = new JPanel();
        this.labelForRightPane = new JLabel("");
        this.rightPane.add(this.labelForRightPane);
        this.splitPane.setLeftComponent(jScrollPane);
        this.splitPane.setRightComponent(this.rightPane);
        this.splitPane.setDividerLocation(350);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGap(this.hGap, this.hGap, this.hGap).addComponent(this.splitPane, -2, -2, Short.MAX_VALUE).addGap(this.hGap, this.hGap, this.hGap));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGap(this.vGap, this.vGap, this.vGap).addComponent(this.splitPane, 50, -2, Short.MAX_VALUE).addGap(this.vGap, this.vGap, this.vGap));
    }

    protected void classify(Map<String, Object> map, TreeSet<String> treeSet) {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>(map);
        this.virtualLines = new TreeMap();
        for (String object2 : treeSet.descendingSet()) {
            this.virtualLines.put(object2, new TreeMap());
        }
        this.virtualLines.put("", new TreeMap());
        String string = "NONE";
        if (map == null) {
            return;
        }
        NavigableSet<String> navigableSet = treeSet.descendingSet();
        for (String string2 : new TreeSet<String>(map.keySet()).descendingSet()) {
            logging.debug(this, "classify key ------- " + string2);
            boolean bl = false;
            for (String string3 : navigableSet) {
                if (!string2.startsWith(string3)) continue;
                this.virtualLines.get(string3).put(string2, map.get(string2));
                logging.debug(this, "classify idCollect -------- " + string3);
                bl = true;
                break;
            }
            if (bl) continue;
            this.virtualLines.get("").put(string2, map.get(string2));
        }
    }

    @Override
    public void setEditableMap(Map<String, Object> map, Map<String, ListCellOptions> map2) {
        super.setEditableMap(map, map2);
        logging.debug(this, " setEditableMap, visualdata keys " + map);
        if (map != null) {
            logging.debug(this, " setEditableMap, visualdata keys " + map.keySet());
            this.treemodel = new SimpleTreeModel(this.givenClasses.keySet(), this.tooltips4Keys);
            this.tree.setModel(this.treemodel);
            this.tree.expandAll();
            logging.info(this, "generated keys " + this.treemodel.getGeneratedKeys());
            this.keyclasses = this.treemodel.getGeneratedKeys();
            this.generateParts();
            this.classify(map, this.keyclasses);
            for (String string : this.keyclasses) {
                this.partialPanels.get(string).setEditableMap(this.virtualLines.get(string), map2);
                this.partialPanels.get((Object)string).mapTableModel.setObservers(this.mapTableModel.getObservers());
            }
        }
    }

    @Override
    public void setStoreData(Collection collection) {
        super.setStoreData(collection);
        for (String string : this.keyclasses) {
            this.partialPanels.get(string).setStoreData(collection);
        }
    }

    @Override
    public void setUpdateCollection(Collection collection) {
        super.setUpdateCollection(collection);
        for (String string : this.keyclasses) {
            this.partialPanels.get(string).setUpdateCollection(collection);
        }
    }

    @Override
    public void setLabel(String string) {
        if (this.treemodel == null) {
            return;
        }
        this.treemodel.setRootLabel(string);
    }

    protected String getCurrentKey() {
        boolean bl;
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        boolean bl2 = bl = treePath.getPathCount() == 1;
        if (bl) {
            return null;
        }
        return SimpleTreePath.dottedString(1, treePath);
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        boolean bl;
        TreePath treePath = this.tree.getSelectionPath();
        int n = this.splitPane.getDividerLocation();
        if (treePath == null) {
            this.splitPane.setRightComponent(this.rightPane);
            this.splitPane.setDividerLocation(n);
            return;
        }
        boolean bl2 = bl = treePath.getPathCount() == 1;
        if (bl) {
            this.splitPane.setRightComponent(this.rightPane);
        } else {
            String string = SimpleTreePath.dottedString(1, treePath);
            if (this.partialPanels.get(string) == null) {
                this.splitPane.setRightComponent(this.rightPane);
            } else {
                this.splitPane.setRightComponent(this.partialPanels.get(string));
            }
        }
        this.splitPane.setDividerLocation(n);
    }
}

