/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.type;

import de.uib.configed.Globals;
import de.uib.configed.configed;
import de.uib.configed.type.SWAuditEntry;
import de.uib.configed.type.StringIdentityMap;
import de.uib.opsidatamodel.PersistenceController;
import de.uib.utilities.logging.logging;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SWAuditClientEntry {
    public static final String CLIENT_ID = "clientId";
    public static final String LICENCEkEY = "licenseKey";
    public static final String LAST_MODIFICATION = "lastseen";
    public static final String UNINSTALL_STRING = "uninstallString";
    protected final Map<String, String> data = new HashMap<String, String>();
    protected List<String> software;
    protected Integer swId;
    protected String swIdent;
    protected String lastModificationS;
    PersistenceController controller;
    public static List<String> KEYS = new LinkedList<String>();
    private static List<String> KEYS_FOR_GUI_TABLES;
    protected static Map<String, String> locale;
    public static final String DB_TABLE_NAME = "SOFTWARE_CONFIG";
    public static final LinkedHashMap<String, String> DB_COLUMNS;
    public static final List<String> DB_COLUMN_NAMES;
    public static final int columnIndexLastStateChange;

    public static void setLocale() {
        locale.put("ID", "ID");
        locale.put("name", configed.getResourceValue("PanelSWInfo.tableheader_displayName"));
        locale.put("version", configed.getResourceValue("PanelSWInfo.tableheader_displayVersion"));
        locale.put("architecture", configed.getResourceValue("PanelSWInfo.tableheader_architecture"));
        locale.put("language", configed.getResourceValue("PanelSWInfo.tableheader_displayLanguage"));
        locale.put(LICENCEkEY, configed.getResourceValue("PanelSWInfo.tableheader_displayLicenseKey"));
        locale.put("windowsSoftwareID", configed.getResourceValue("PanelSWInfo.tableheader_softwareId"));
    }

    public SWAuditClientEntry(List<String> list, List<String> list2, PersistenceController persistenceController) {
        this.data.put("ID", list2.get(list.indexOf(DB_COLUMNS.get(CLIENT_ID))));
        this.data.put(LICENCEkEY, list2.get(list.indexOf(DB_COLUMNS.get(LICENCEkEY))));
        this.lastModificationS = list2.get(list.indexOf(DB_COLUMNS.get(LAST_MODIFICATION)));
        this.swIdent = SWAuditClientEntry.produceSWident(list, list2);
        this.controller = persistenceController;
        this.software = persistenceController.getSoftwareList();
        this.produceSWid();
    }

    public SWAuditClientEntry(Map<String, Object> map, PersistenceController persistenceController) {
        this.data.put("ID", Globals.produceNonNull(map.get(CLIENT_ID)));
        this.swIdent = SWAuditClientEntry.produceSWident(map);
        this.controller = persistenceController;
        this.software = persistenceController.getSoftwareList();
        this.produceSWid();
        this.data.put(LICENCEkEY, Globals.produceNonNull(map.get(LICENCEkEY)));
        this.lastModificationS = Globals.produceNonNull(map.get(LAST_MODIFICATION));
    }

    public static String produceSWident(List<String> list, List<String> list2) {
        String string = "";
        try {
            string = de.uib.utilities.Globals.pseudokey(new String[]{list2.get(list.indexOf(DB_COLUMNS.get("name"))), list2.get(list.indexOf(DB_COLUMNS.get("version"))), list2.get(list.indexOf(DB_COLUMNS.get("subVersion"))), list2.get(list.indexOf(DB_COLUMNS.get("language"))), list2.get(list.indexOf(DB_COLUMNS.get("architecture")))});
        }
        catch (Exception exception) {
            logging.info("SWAuditClientEntry:: produceSWident keys -- value : " + list + " -- " + list2);
            logging.info("SWAuditClientEntry:: produceSWident key " + DB_COLUMNS.get("name"));
            logging.info("SWAuditClientEntry:: produceSWident value " + list2.get(list.indexOf(DB_COLUMNS.get("name"))));
            logging.info("SWAuditClientEntry:: produceSWident key " + DB_COLUMNS.get("version"));
            logging.info("SWAuditClientEntry:: produceSWident value " + list2.get(list.indexOf(DB_COLUMNS.get("version"))));
            logging.info("SWAuditClientEntry:: produceSWident key " + DB_COLUMNS.get("subVersion"));
            logging.info("SWAuditClientEntry:: produceSWident value " + list2.get(list.indexOf(DB_COLUMNS.get("subVersion"))));
            logging.info("SWAuditClientEntry:: produceSWident key " + DB_COLUMNS.get("language"));
            logging.info("SWAuditClientEntry:: produceSWident value " + list2.get(list.indexOf(DB_COLUMNS.get("language"))));
            logging.info("SWAuditClientEntry:: produceSWident key " + DB_COLUMNS.get("architecture"));
            logging.info("SWAuditClientEntry:: produceSWident value " + list2.get(list.indexOf(DB_COLUMNS.get("architecture"))));
        }
        return string;
    }

    protected void updateSoftware() {
        this.controller.installedSoftwareInformationRequestRefresh();
        this.software = this.controller.getSoftwareList();
    }

    protected Integer produceSWid() {
        this.swId = this.software.indexOf(this.swIdent);
        if (this.swId == -1) {
            logging.info(this, "software with ident " + this.swIdent + " not yet indexed");
            this.updateSoftware();
            this.swId = this.software.indexOf(this.swIdent);
            if (this.swId == -1) {
                logging.warning(this, "swIdent not found in softwarelist");
            }
        }
        return this.swId;
    }

    public static String produceSWident(Map<String, Object> map) {
        return de.uib.utilities.Globals.pseudokey(new String[]{(String)map.get(SWAuditEntry.key2serverKey.get("name")), (String)map.get(SWAuditEntry.key2serverKey.get("version")), (String)map.get(SWAuditEntry.key2serverKey.get("subVersion")), (String)map.get(SWAuditEntry.key2serverKey.get("language")), (String)map.get(SWAuditEntry.key2serverKey.get("architecture"))});
    }

    public String getClientId() {
        return this.data.get("ID");
    }

    public String getLicenceKey() {
        return this.data.get(this.data.get(LICENCEkEY));
    }

    public String getLastModification() {
        return this.lastModificationS;
    }

    public Integer getSWid() {
        return this.swId;
    }

    public String getSWident() {
        return this.swIdent;
    }

    public static List<String> getDisplayKeys() {
        return KEYS_FOR_GUI_TABLES;
    }

    public static String getDisplayKey(int n) {
        return locale.get(KEYS.get(n));
    }

    public Map<String, String> getExpandedMap(Map<String, SWAuditEntry> map, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>(this.data);
        hashMap.putAll(map.get(string));
        return hashMap;
    }

    public String[] getExpandedData(Map<String, SWAuditEntry> map, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>(this.data);
        hashMap.putAll(map.get(string));
        String[] stringArray = new String[KEYS.size()];
        for (int i = 0; i < KEYS.size(); ++i) {
            stringArray[i] = (String)hashMap.get(KEYS.get(i));
        }
        return stringArray;
    }

    public String toString() {
        return "<" + this.data.toString() + ", swIdent= " + this.swIdent + ">";
    }

    static {
        KEYS.add("ID");
        KEYS.add("name");
        KEYS.add("version");
        KEYS.add("subVersion");
        KEYS.add("architecture");
        KEYS.add("language");
        KEYS.add(LICENCEkEY);
        KEYS.add("windowsSoftwareID");
        KEYS_FOR_GUI_TABLES = new LinkedList<String>();
        KEYS_FOR_GUI_TABLES.add("ID");
        KEYS_FOR_GUI_TABLES.add("name");
        KEYS_FOR_GUI_TABLES.add("version");
        KEYS_FOR_GUI_TABLES.add("architecture");
        KEYS_FOR_GUI_TABLES.add("language");
        KEYS_FOR_GUI_TABLES.add(LICENCEkEY);
        KEYS_FOR_GUI_TABLES.add("windowsSoftwareID");
        locale = new StringIdentityMap(KEYS);
        DB_COLUMNS = new LinkedHashMap();
        DB_COLUMNS.put(CLIENT_ID, "SOFTWARE_CONFIG.clientId");
        DB_COLUMNS.put("name", "SOFTWARE_CONFIG.name");
        DB_COLUMNS.put("version", "SOFTWARE_CONFIG.version");
        DB_COLUMNS.put("subVersion", "SOFTWARE_CONFIG.subVersion");
        DB_COLUMNS.put("architecture", "SOFTWARE_CONFIG.architecture");
        DB_COLUMNS.put("language", "SOFTWARE_CONFIG.language");
        DB_COLUMNS.put(LICENCEkEY, "SOFTWARE_CONFIG.licenseKey");
        DB_COLUMNS.put(LAST_MODIFICATION, "SOFTWARE_CONFIG.lastseen");
        DB_COLUMN_NAMES = new ArrayList<String>();
        for (String string : DB_COLUMNS.keySet()) {
            DB_COLUMN_NAMES.add(DB_COLUMNS.get(string));
        }
        columnIndexLastStateChange = DB_COLUMN_NAMES.indexOf("modificationTime");
    }
}

