/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.tree;

import de.uib.configed.tree.ClientTree;
import de.uib.configed.tree.GroupNode;
import de.uib.utilities.logging.logging;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import utils.PopupMouseListener;

public class TreePopupMouseListener
extends PopupMouseListener {
    protected ClientTree tree;
    protected Integer acceptedMouseButton;
    protected int mouseRow = -1;
    protected TreePath mousePath = null;
    protected JPopupMenu myMenu;
    public static int createSubnodePosition = -1;
    public static int editNodePosition = -1;
    public static int deleteNodePosition = -1;
    public static int deleteGroupNodePosition = -1;
    public static int activateElementsPosition = -1;
    public static int removeElementsPosition = -1;

    public TreePopupMouseListener(JPopupMenu jPopupMenu, ClientTree clientTree, Integer n) {
        super(jPopupMenu);
        this.myMenu = jPopupMenu;
        this.tree = clientTree;
        this.acceptedMouseButton = n;
    }

    public int getPopupSourceRow() {
        return this.mouseRow;
    }

    public TreePath getPopupSourcePath() {
        return this.mousePath;
    }

    protected boolean checkAccepted(MouseEvent mouseEvent) {
        if (!this.tree.isEnabled()) {
            return false;
        }
        if (this.acceptedMouseButton != null && mouseEvent.getButton() != this.acceptedMouseButton.intValue()) {
            return false;
        }
        this.mouseRow = this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
        this.mousePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (this.mouseRow == -1) {
            this.mousePath = null;
            return false;
        }
        logging.debug(this, "checkAccepted clickPath  " + this.mousePath);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.mousePath.getLastPathComponent();
        String string = defaultMutableTreeNode.getUserObject().toString();
        if (this.tree.getGroupNode(string) != null && defaultMutableTreeNode != this.tree.getGroupNode(string)) {
            logging.warning(this, "checkAccepted clickNode != tree.getGroupNode(nodeName)");
            defaultMutableTreeNode = this.tree.getGroupNode(string);
        }
        logging.debug(this, "checkAccepted clickNode.getParent() " + defaultMutableTreeNode.getParent());
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        String string2 = defaultMutableTreeNode2.getUserObject().toString();
        if (string.equals(ClientTree.ALL_NAME) || ((DefaultMutableTreeNode)defaultMutableTreeNode.getParent()).getUserObject().toString().equals(ClientTree.ALL_NAME) && !string.equals(ClientTree.GROUPS_NAME)) {
            return false;
        }
        ((JMenuItem)this.myMenu.getSubElements()[createSubnodePosition]).setVisible(false);
        ((JMenuItem)this.myMenu.getSubElements()[editNodePosition]).setVisible(false);
        ((JMenuItem)this.myMenu.getSubElements()[deleteNodePosition]).setVisible(false);
        ((JMenuItem)this.myMenu.getSubElements()[deleteGroupNodePosition]).setVisible(false);
        ((JMenuItem)this.myMenu.getSubElements()[removeElementsPosition]).setVisible(false);
        ((JMenuItem)this.myMenu.getSubElements()[activateElementsPosition]).setVisible(false);
        int n = 0;
        if (defaultMutableTreeNode.getAllowsChildren()) {
            if (((GroupNode)defaultMutableTreeNode).allowsSubGroups()) {
                ((JMenuItem)this.myMenu.getSubElements()[createSubnodePosition]).setVisible(true);
                ++n;
            }
            if (((GroupNode)defaultMutableTreeNode).allowsSubGroups() && !((GroupNode)defaultMutableTreeNode).isFixed()) {
                ((JMenuItem)this.myMenu.getSubElements()[editNodePosition]).setVisible(true);
                ++n;
            }
            if (!((GroupNode)defaultMutableTreeNode).isFixed()) {
                ((JMenuItem)this.myMenu.getSubElements()[deleteGroupNodePosition]).setVisible(true);
                ++n;
            }
            ((JMenuItem)this.myMenu.getSubElements()[activateElementsPosition]).setVisible(true);
            ++n;
            if (!((GroupNode)defaultMutableTreeNode).isFixed()) {
                ((JMenuItem)this.myMenu.getSubElements()[removeElementsPosition]).setVisible(true);
                ++n;
            }
        } else if (!((GroupNode)defaultMutableTreeNode2).isFixed()) {
            ((JMenuItem)this.myMenu.getSubElements()[deleteNodePosition]).setVisible(true);
            ++n;
        }
        return n > 0;
    }

    @Override
    protected void maybeShowPopup(MouseEvent mouseEvent) {
        if (this.checkAccepted(mouseEvent)) {
            super.maybeShowPopup(mouseEvent);
        }
    }
}

