/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.productaction;

import de.uib.configed.ConfigedMain;
import de.uib.configed.Globals;
import de.uib.configed.configed;
import de.uib.configed.productaction.PanelMountShare;
import de.uib.connectx.SmbConnect;
import de.uib.opsidatamodel.PersistenceController;
import de.uib.utilities.NameProducer;
import de.uib.utilities.logging.logging;
import de.uib.utilities.observer.DataRefreshedObserver;
import de.uib.utilities.thread.WaitCursor;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.io.FileUtils;

public class PanelCompleteWinProducts
extends JPanel
implements DataRefreshedObserver,
NameProducer {
    String winProduct = "";
    String server = "";
    String selectedDepot = null;
    Set<String> depots = new HashSet<String>();
    String depotProductDirectory;
    boolean smbMounted;
    int firstLabelWidth = Globals.firstLabelWidth;
    JComboBox comboChooseDepot;
    JComboBox comboChooseWinProduct;
    JTextField fieldTargetPath;
    JButton buttonCallSelectFolderWinPE;
    JButton buttonCallSelectFolderInstallFiles;
    JTextField fieldProductKey;
    JTextField fieldPathWinPE;
    JTextField fieldPathInstallFiles;
    PanelMountShare panelMountShare;
    JButton buttonCallExecute;
    JTextField fieldResult;
    JFileChooser chooserFolder;
    PersistenceController persist;
    ConfigedMain main;
    JFrame rootFrame;
    Vector<String> winProducts;

    public PanelCompleteWinProducts(ConfigedMain configedMain, PersistenceController persistenceController, JFrame jFrame) {
        this.main = configedMain;
        this.persist = persistenceController;
        this.rootFrame = jFrame;
        this.server = configedMain.getConfigserver();
        this.defineChoosers();
        this.initComponentsForNameProducer();
        this.selectedDepot = "" + this.comboChooseDepot.getSelectedItem();
        this.depotProductDirectory = SmbConnect.getInstance().buildSambaTarget(this.selectedDepot, "opsi_depot_rw");
        this.panelMountShare = new PanelMountShare(this, configedMain, jFrame){

            @Override
            protected boolean checkConnectionToShare() {
                boolean bl = super.checkConnectionToShare();
                if (PanelCompleteWinProducts.this.comboChooseWinProduct != null && bl) {
                    PanelCompleteWinProducts.this.evaluateWinProducts();
                }
                return bl;
            }
        };
        this.initComponents();
        this.smbMounted = new File(this.depotProductDirectory).exists();
        this.panelMountShare.mount(this.smbMounted);
        this.evaluateWinProducts();
        this.defineLayout();
        persistenceController.registerDataRefreshedObserver(this);
    }

    private void evaluateWinProducts() {
        this.retrieveWinProducts();
        this.winProduct = "" + this.comboChooseWinProduct.getSelectedItem();
        this.produceTarget();
    }

    @Override
    public void gotNotification(Object object) {
        this.evaluateWinProducts();
    }

    private void retrieveWinProducts() {
        if (this.depotProductDirectory == null) {
            return;
        }
        this.smbMounted = new File(this.depotProductDirectory).exists();
        Vector<String> vector = this.persist.getWinProducts(this.server, this.depotProductDirectory);
        this.comboChooseWinProduct.setModel(new DefaultComboBoxModel<String>(vector));
    }

    private void defineChoosers() {
        this.chooserFolder = new JFileChooser();
        this.chooserFolder.setFileSelectionMode(1);
        this.chooserFolder.setApproveButtonText(configed.getResourceValue("FileChooser.approve"));
        UIManager.put("FileChooser.cancelButtonText", configed.getResourceValue("FileChooser.cancel"));
        SwingUtilities.updateComponentTreeUI(this.chooserFolder);
        this.chooserFolder.setDialogType(0);
        this.chooserFolder.setDialogTitle("opsi config editor " + configed.getResourceValue("CompleteWinProducts.chooser"));
        this.comboChooseDepot = new JComboBox();
        this.comboChooseDepot.setSize(Globals.textfieldDimension);
        this.comboChooseDepot.setModel(new DefaultComboBoxModel<String>(this.main.getLinkedDepots()));
        this.comboChooseDepot.setEnabled(false);
        this.comboChooseDepot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PanelCompleteWinProducts.this.selectedDepot = "" + PanelCompleteWinProducts.this.comboChooseDepot.getSelectedItem();
                logging.info(this, "actionPerformed  depot selected " + PanelCompleteWinProducts.this.selectedDepot);
                SmbConnect.getInstance().buildSambaTarget(PanelCompleteWinProducts.this.selectedDepot, "opsi_depot_rw");
                PanelCompleteWinProducts.this.evaluateWinProducts();
            }
        });
        this.comboChooseWinProduct = new JComboBox();
        this.comboChooseWinProduct.setSize(Globals.textfieldDimension);
        this.comboChooseWinProduct.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PanelCompleteWinProducts.this.winProduct = "" + PanelCompleteWinProducts.this.comboChooseWinProduct.getSelectedItem();
                PanelCompleteWinProducts.this.produceTarget();
            }
        });
    }

    private void produceTarget() {
        if (this.fieldTargetPath != null) {
            this.fieldTargetPath.setText(this.depotProductDirectory + File.separator + this.winProduct);
            if (this.buttonCallExecute != null) {
                this.buttonCallExecute.setEnabled(new File(this.fieldTargetPath.getText()).isDirectory());
            }
        }
    }

    @Override
    public String produceName() {
        logging.info(this, "produceName ? fieldTargetPath , depotProductDirectory " + this.fieldTargetPath + " , " + this.depotProductDirectory);
        if (this.fieldTargetPath == null || this.fieldTargetPath.getText().equals("") || this.fieldTargetPath.getText().startsWith(this.depotProductDirectory)) {
            return this.depotProductDirectory;
        }
        return this.fieldTargetPath.getText();
    }

    @Override
    public String getDefaultName() {
        return "opsi_depot_rw";
    }

    private void initComponentsForNameProducer() {
        this.fieldTargetPath = new JTextField("");
        this.fieldPathWinPE = new JTextField();
    }

    private void initComponents() {
        final PanelCompleteWinProducts panelCompleteWinProducts = this;
        this.fieldProductKey = new JTextField("");
        this.fieldProductKey.setPreferredSize(Globals.textfieldDimension);
        this.buttonCallSelectFolderWinPE = new JButton("", Globals.createImageIcon("images/folder_16.png", ""));
        this.buttonCallSelectFolderWinPE.setSelectedIcon(Globals.createImageIcon("images/folder_16.png", ""));
        this.buttonCallSelectFolderWinPE.setPreferredSize(Globals.graphicButtonDimension);
        this.buttonCallSelectFolderWinPE.setToolTipText(configed.getResourceValue("CompleteWinProducts.chooserFolderPE"));
        this.buttonCallSelectFolderWinPE.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = PanelCompleteWinProducts.this.chooserFolder.showOpenDialog(panelCompleteWinProducts);
                if (n == 0) {
                    String string = PanelCompleteWinProducts.this.chooserFolder.getSelectedFile().getPath();
                    PanelCompleteWinProducts.this.fieldPathWinPE.setText(string);
                    PanelCompleteWinProducts.this.fieldPathWinPE.setCaretPosition(string.length());
                } else {
                    PanelCompleteWinProducts.this.fieldPathWinPE.setText("");
                }
            }
        });
        this.buttonCallSelectFolderInstallFiles = new JButton("", Globals.createImageIcon("images/folder_16.png", ""));
        this.buttonCallSelectFolderInstallFiles.setSelectedIcon(Globals.createImageIcon("images/folder_16.png", ""));
        this.buttonCallSelectFolderInstallFiles.setPreferredSize(Globals.graphicButtonDimension);
        this.buttonCallSelectFolderInstallFiles.setToolTipText(configed.getResourceValue("CompleteWinProducts.chooserFolderInstallFiles"));
        this.fieldPathInstallFiles = new JTextField();
        this.buttonCallSelectFolderInstallFiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = PanelCompleteWinProducts.this.chooserFolder.showOpenDialog(panelCompleteWinProducts);
                if (n == 0) {
                    String string = PanelCompleteWinProducts.this.chooserFolder.getSelectedFile().getPath();
                    PanelCompleteWinProducts.this.fieldPathInstallFiles.setText(string);
                    PanelCompleteWinProducts.this.fieldPathInstallFiles.setCaretPosition(string.length());
                } else {
                    PanelCompleteWinProducts.this.fieldPathInstallFiles.setText("");
                }
            }
        });
        this.buttonCallExecute = new JButton("", Globals.createImageIcon("images/upload2product.png", ""));
        this.buttonCallExecute.setSelectedIcon(Globals.createImageIcon("images/upload2product.png", ""));
        this.buttonCallExecute.setPreferredSize(Globals.graphicButtonDimension);
        this.buttonCallExecute.setToolTipText(configed.getResourceValue("CompleteWinProducts.execute"));
        this.buttonCallExecute.setEnabled(false);
        this.buttonCallExecute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                logging.debug(this, "actionPerformed on buttonCallExecute pathWinPE, pathInstallFiles, productKey, winproduct " + PanelCompleteWinProducts.this.fieldPathWinPE.getText() + ", " + PanelCompleteWinProducts.this.fieldPathInstallFiles.getText() + ", " + PanelCompleteWinProducts.this.fieldProductKey.getText() + ", " + PanelCompleteWinProducts.this.comboChooseWinProduct.getSelectedItem());
                Color color = PanelCompleteWinProducts.this.buttonCallExecute.getBackground();
                PanelCompleteWinProducts.this.buttonCallExecute.setBackground(Globals.failedBackColor);
                PanelCompleteWinProducts.this.execute();
                PanelCompleteWinProducts.this.buttonCallExecute.setBackground(color);
            }
        });
    }

    protected void execute() {
        WaitCursor waitCursor = null;
        try {
            waitCursor = new WaitCursor(this.rootFrame);
            File file = null;
            String string = this.fieldPathWinPE.getText().trim();
            logging.debug(this, "copy  " + string + " to " + file);
            if (!string.equals("")) {
                file = new File(this.fieldTargetPath.getText() + File.separator + "winpe");
                FileUtils.copyDirectory(new File(string), file);
            }
            String string2 = this.fieldPathInstallFiles.getText().trim();
            logging.debug(this, "copy  " + string2 + " to " + file);
            if (!string2.equals("")) {
                file = new File(this.fieldTargetPath.getText() + File.separator + "installfiles");
                FileUtils.copyDirectory(new File(string2), file);
            }
            this.persist.setRights("/" + SmbConnect.unixPath(SmbConnect.directoryProducts) + "/" + this.winProduct + "/" + "winpe");
            this.persist.setRights("/" + SmbConnect.unixPath(SmbConnect.directoryProducts) + "/" + this.winProduct + "/" + "installfiles");
            waitCursor.stop();
            JOptionPane.showMessageDialog(this.rootFrame, "Ready", configed.getResourceValue("CompleteWinProduct.reportTitle"), 1);
            ArrayList<String> arrayList = new ArrayList<String>();
            String string3 = this.fieldProductKey.getText().trim();
            arrayList.add(string3);
            Map<String, Object> map = this.persist.getProductproperties(this.server, this.winProduct);
            logging.debug(this, " getProductproperties " + map);
            String string4 = null;
            if (map != null && map.get("productkey") != null && map.get("productkey") instanceof List && ((List)map.get("productkey")).size() > 0 && !((List)map.get("productkey")).get(0).equals("")) {
                string4 = (String)((List)map.get("productkey")).get(0);
            }
            if (string4 == null) {
                string4 = "";
            }
            if (!string4.equals(string3)) {
                int n = 1;
                n = JOptionPane.showOptionDialog(this.rootFrame, configed.getResourceValue("PanelCompleteWinProducts.setChangedProductKey"), configed.getResourceValue("ConfigedMain.dataNotFetched.title"), 0, 3, null, null, null);
                if (n == 0) {
                    waitCursor = new WaitCursor(this.rootFrame);
                    this.persist.setCommonProductPropertyValue(this.depots, this.winProduct, "productkey", arrayList);
                    waitCursor.stop();
                }
            }
        }
        catch (Exception exception) {
            waitCursor.stop();
            logging.error("copy error:\n" + exception, exception);
        }
        waitCursor = null;
    }

    public void defineLayout() {
        this.setBorder(Globals.createPanelBorder());
        JLabel jLabel = new JLabel(configed.getResourceValue("CompleteWinProducts.topic"));
        JLabel jLabel2 = new JLabel(configed.getResourceValue("CompleteWinProducts.labelServer"));
        JLabel jLabel3 = new JLabel(configed.getResourceValue("CompleteWinProducts.labelWinProduct"));
        JLabel jLabel4 = new JLabel(configed.getResourceValue("CompleteWinProducts.labelFolderWinPE"));
        JLabel jLabel5 = new JLabel(configed.getResourceValue("CompleteWinProducts.labelFolderInstallFiles"));
        JLabel jLabel6 = new JLabel(configed.getResourceValue("CompleteWinProducts.labelTargetPath"));
        JLabel jLabel7 = new JLabel(configed.getResourceValue("CompleteWinProducts.labelProductKey"));
        PanelCompleteWinProducts panelCompleteWinProducts = this;
        GroupLayout groupLayout = new GroupLayout(panelCompleteWinProducts);
        panelCompleteWinProducts.setLayout(groupLayout);
        int n = Globals.hFirstGap;
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGap(10, 30, 40).addComponent(jLabel, -2, -2, -2).addGap(10, 10, 20).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel2, 28, 28, 28).addComponent(this.comboChooseDepot, 28, 28, 28)).addGap(5, 5, 5).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel3, 28, 28, 28).addComponent(this.comboChooseWinProduct, 28, 28, 28)).addGap(5, 5, 5).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel4, 28, 28, 28).addComponent(this.buttonCallSelectFolderWinPE, 28, 28, 28).addComponent(this.fieldPathWinPE, 28, 28, 28)).addGap(5, 5, 5).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel5, 28, 28, 28).addComponent(this.buttonCallSelectFolderInstallFiles, 28, 28, 28).addComponent(this.fieldPathInstallFiles, 28, 28, 28)).addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.panelMountShare, 28, 28, 28)).addGap(5, 5, 5).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel6, 28, 28, 28).addComponent(this.fieldTargetPath, 28, 28, 28)).addGap(5, 5, 5).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel7, 28, 28, 28).addComponent(this.fieldProductKey, 28, 28, 28)).addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.buttonCallExecute, 28, 28, 28)).addGap(10, 10, 20));
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup().addGroup(groupLayout.createSequentialGroup().addGap(10, 20, Short.MAX_VALUE).addComponent(jLabel, -2, -2, -2).addGap(10, 20, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(n, n, n).addComponent(jLabel2, this.firstLabelWidth, this.firstLabelWidth, this.firstLabelWidth).addGap(10, 10, 10).addGap(Globals.graphicButtonWidth, Globals.graphicButtonWidth, Globals.graphicButtonWidth).addGap(n, n, n).addComponent(this.comboChooseDepot, 280, 280, 280).addGap(10, 30, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(n, n, n).addComponent(jLabel3, this.firstLabelWidth, this.firstLabelWidth, this.firstLabelWidth).addGap(10, 10, 10).addGap(Globals.graphicButtonWidth, Globals.graphicButtonWidth, Globals.graphicButtonWidth).addGap(n, n, n).addComponent(this.comboChooseWinProduct, 280, 280, 280).addGap(10, 30, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(n, n, n).addComponent(jLabel4, this.firstLabelWidth, this.firstLabelWidth, this.firstLabelWidth).addGap(10, 10, 10).addComponent(this.buttonCallSelectFolderWinPE, Globals.graphicButtonWidth, Globals.graphicButtonWidth, Globals.graphicButtonWidth).addGap(n, n, n).addComponent(this.fieldPathWinPE, 280, 280, Short.MAX_VALUE).addGap(10, 30, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(n, n, n).addComponent(jLabel5, this.firstLabelWidth, this.firstLabelWidth, this.firstLabelWidth).addGap(10, 10, 10).addComponent(this.buttonCallSelectFolderInstallFiles, Globals.graphicButtonWidth, Globals.graphicButtonWidth, Globals.graphicButtonWidth).addGap(n, n, n).addComponent(this.fieldPathInstallFiles, 280, 280, Short.MAX_VALUE).addGap(10, 30, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addComponent(this.panelMountShare, -2, -2, -2)).addGroup(groupLayout.createSequentialGroup().addGap(n, n, n).addComponent(jLabel6, this.firstLabelWidth, this.firstLabelWidth, this.firstLabelWidth).addGap(10, 10, 10).addGap(Globals.graphicButtonWidth, Globals.graphicButtonWidth, Globals.graphicButtonWidth).addGap(n, n, n).addComponent(this.fieldTargetPath, 280, 280, Short.MAX_VALUE).addGap(10, 30, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(n, n, n).addComponent(jLabel7, this.firstLabelWidth, this.firstLabelWidth, this.firstLabelWidth).addGap(10, 10, 10).addGap(Globals.graphicButtonWidth, Globals.graphicButtonWidth, Globals.graphicButtonWidth).addGap(n, n, n).addComponent(this.fieldProductKey, 280, 280, 280).addGap(10, 30, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(n, n, n).addGap(0, this.firstLabelWidth, this.firstLabelWidth).addGap(0, 10, 10).addGap(0, Globals.graphicButtonWidth, Globals.graphicButtonWidth).addGap(0, n, n).addGap(0, 280, Short.MAX_VALUE).addComponent(this.buttonCallExecute, -2, -2, -2).addGap(n, n, Short.MAX_VALUE)));
    }
}

