/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.gui.ssh;

import de.uib.configed.ConfigedMain;
import de.uib.configed.Globals;
import de.uib.configed.configed;
import de.uib.configed.gui.ssh.SSHPackageManagerParameterDialog;
import de.uib.opsicommand.sshcommand.CommandOpsiPackageManagerUninstall;
import de.uib.opsicommand.sshcommand.SSHConnectExec;
import de.uib.utilities.logging.logging;
import de.uib.utilities.thread.WaitCursor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SSHPackageManagerUninstallParameterDialog
extends SSHPackageManagerParameterDialog {
    private GroupLayout gpl;
    private JPanel uninstallPanel = new JPanel();
    private JLabel lbl_uninstall = new JLabel();
    private JLabel lbl_product = new JLabel();
    private JLabel lbl_on = new JLabel();
    private JLabel lbl_fullCommand = new JLabel();
    private JLabel lbl_keepFiles = new JLabel();
    private JComboBox cb_opsiproducts;
    private JComboBox cb_verbosity;
    private JComboBox cb_depots;
    private JCheckBox checkb_keepFiles;
    private JTextField tf_freeInput;
    protected final int frameLength = 500;
    protected final int frameHight = 270;
    public String wgetResult = "";
    private CommandOpsiPackageManagerUninstall commandPMUninstall = new CommandOpsiPackageManagerUninstall();
    boolean execFinished;

    public SSHPackageManagerUninstallParameterDialog() {
        this((ConfigedMain)null);
    }

    public SSHPackageManagerUninstallParameterDialog(ConfigedMain configedMain) {
        super(configed.getResourceValue("SSHConnection.ParameterDialog.opsipackagemanager_uninstall.title"));
        WaitCursor waitCursor = new WaitCursor(this.getContentPane());
        this.main = configedMain;
        this.init();
        this.pack();
        this.setSize(500, 270);
        this.setDefaultCloseOperation(2);
        waitCursor.stop();
        this.setVisible(true);
    }

    protected void init() {
        this.uninstallPanel.setBackground(Globals.backLightBlue);
        this.buttonPanel.setBackground(Globals.backLightBlue);
        this.getContentPane().add((Component)this.uninstallPanel, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.buttonPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.uninstallPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.uninstallPanel.setPreferredSize(new Dimension(376, 220));
        this.lbl_uninstall.setText(configed.getResourceValue("SSHConnection.ParameterDialog.opsipackagemanager_uninstall.jLabelUninstall"));
        this.cb_verbosity = new JComboBox();
        this.cb_verbosity.setToolTipText(configed.getResourceValue("SSHConnection.ParameterDialog.tooltip.verbosity"));
        for (int i = 0; i < 5; ++i) {
            this.cb_verbosity.addItem(i);
        }
        this.cb_verbosity.setSelectedItem(1);
        this.cb_verbosity.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SSHPackageManagerUninstallParameterDialog.this.changeVerbosity();
            }
        });
        this.lbl_keepFiles.setText(configed.getResourceValue("SSHConnection.ParameterDialog.opsipackagemanager_uninstall.jLabelKeepFiles"));
        this.checkb_keepFiles = new JCheckBox();
        this.checkb_keepFiles.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SSHPackageManagerUninstallParameterDialog.this.changeKeepFiles();
            }
        });
        this.lbl_product.setText(configed.getResourceValue("SSHConnection.ParameterDialog.opsipackagemanager_uninstall.jLabelProduct"));
        this.cb_opsiproducts = new JComboBox();
        this.cb_opsiproducts.setToolTipText(configed.getResourceValue("SSHConnection.ParameterDialog.opsipackagemanager_uninstall.tooltip.jLabelProduct"));
        this.cb_opsiproducts.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SSHPackageManagerUninstallParameterDialog.this.changeProduct();
            }
        });
        this.lbl_on.setText(configed.getResourceValue("SSHConnection.ParameterDialog.opsipackagemanager_uninstall.jLabelOn"));
        this.cb_depots = new JComboBox();
        this.cb_depots.setToolTipText(configed.getResourceValue("SSHConnection.ParameterDialog.opsipackagemanager_uninstall.tooltip.opsidepot"));
        this.cb_depots.addItem(this.defaultDepot);
        this.cb_depots.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SSHPackageManagerUninstallParameterDialog.this.updateProductsOnDepot();
                SSHPackageManagerUninstallParameterDialog.this.changeDepot();
            }
        });
        this.cb_depots.addItem("all");
        LinkedList<String> linkedList = this.persist.getHostInfoCollections().getDepotNamesList();
        for (String string : linkedList) {
            this.cb_depots.addItem(string);
        }
        this.cb_depots.setSelectedItem(this.defaultDepot);
        this.initLabels();
        this.initButtons(this);
        this.initLayout();
        this.updateProductsOnDepot();
        this.changeDepot();
        this.changeProduct();
        this.changeVerbosity();
    }

    private void updateProductsOnDepot() {
        LinkedList linkedList;
        logging.info(this, "updateProductsOnDepot in cb_opsiproducts");
        this.cb_opsiproducts.removeAllItems();
        if (this.persist == null) {
            logging.error(this, "updateProductsOnDepot PersistenceController null");
        }
        if ((String)this.cb_depots.getSelectedItem() == this.defaultDepot) {
            linkedList = new LinkedList((ArrayList)this.persist.getAllNetbootProductNames());
            linkedList.addAll((ArrayList)this.persist.getAllLocalbootProductNames());
        } else {
            linkedList = new LinkedList((ArrayList)this.persist.getAllNetbootProductNames((String)this.cb_depots.getSelectedItem()));
            linkedList.addAll((ArrayList)this.persist.getAllLocalbootProductNames((String)this.cb_depots.getSelectedItem()));
        }
        Collections.sort(linkedList);
        for (String string : linkedList) {
            this.cb_opsiproducts.addItem(string);
        }
    }

    private void updateCommand() {
        this.lbl_fullCommand.setText(this.commandPMUninstall.getCommand());
    }

    private void changeKeepFiles() {
        this.commandPMUninstall.setKeepFiles(this.checkb_keepFiles.isSelected());
        this.updateCommand();
    }

    private void changeVerbosity() {
        this.commandPMUninstall.setVerbosity((Integer)this.cb_verbosity.getSelectedItem());
        this.updateCommand();
    }

    private void changeDepot() {
        if (this.cb_depots.getSelectedItem().equals(this.defaultDepot)) {
            this.commandPMUninstall.setDepot("");
        } else {
            this.commandPMUninstall.setDepot((String)this.cb_depots.getSelectedItem());
        }
        this.updateCommand();
    }

    private void changeProduct() {
        this.commandPMUninstall.setOpsiproduct((String)this.cb_opsiproducts.getSelectedItem());
        this.updateCommand();
    }

    @Override
    protected void doAction1() {
        logging.info(this, "doAction1 uninstall  ");
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    logging.info(this, "start exec thread ");
                    if (SSHPackageManagerUninstallParameterDialog.this.commandPMUninstall.checkCommand()) {
                        logging.info(this, "start exec from doAction1");
                        SSHConnectExec sSHConnectExec = new SSHConnectExec();
                        sSHConnectExec.exec(SSHPackageManagerUninstallParameterDialog.this.commandPMUninstall);
                        SSHPackageManagerUninstallParameterDialog.this.cb_opsiproducts.removeItem((String)SSHPackageManagerUninstallParameterDialog.this.cb_opsiproducts.getSelectedItem());
                        SSHPackageManagerUninstallParameterDialog.this.execFinished = true;
                    }
                    logging.debug(this, "end exec thread");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        Thread thread2 = new Thread(){

            @Override
            public void run() {
                try {
                    boolean bl = false;
                    logging.info(this, "start reload thread ");
                    while (!bl) {
                        if (SSHPackageManagerUninstallParameterDialog.this.execFinished) {
                            logging.info(this, "start reload from doAction1");
                            SSHPackageManagerUninstallParameterDialog.this.main.reload();
                            bl = true;
                            continue;
                        }
                        Thread.sleep(1000L);
                    }
                    logging.info(this, "end reload thread ");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        try {
            thread.start();
            thread2.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    protected void doAction2() {
        this.execFinished = true;
        this.setVisible(false);
        this.dispose();
    }

    private void initLayout() {
        int n = -2;
        int n2 = Short.MAX_VALUE;
        GroupLayout.Alignment alignment = GroupLayout.Alignment.LEADING;
        GroupLayout groupLayout = new GroupLayout(this.uninstallPanel);
        this.uninstallPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lbl_uninstall, n, n, n2).addGap(20).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup().addComponent(this.lbl_product, 250, 250, 250).addComponent(this.lbl_on, 250, 250, 250)).addGap(10).addGroup(groupLayout.createParallelGroup().addComponent(this.cb_opsiproducts, n, n, n2).addComponent(this.cb_depots, n, n, n2))).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup().addComponent(this.lbl_verbosity, n, n, n2).addComponent(this.lbl_keepFiles, n, n, n2)).addGap(10).addGroup(groupLayout.createParallelGroup().addComponent(this.cb_verbosity, n, n, n).addGroup(groupLayout.createSequentialGroup().addGap(25).addComponent(this.checkb_keepFiles, n, n, n)))));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addComponent(this.lbl_uninstall).addGap(20).addGroup(groupLayout.createParallelGroup(alignment).addComponent(this.lbl_product, n, n, n).addComponent(this.cb_opsiproducts, n, n, n)).addGap(5).addGroup(groupLayout.createParallelGroup(alignment).addComponent(this.lbl_on, n, n, n).addComponent(this.cb_depots, n, n, n)).addGap(5).addGroup(groupLayout.createParallelGroup(alignment).addComponent(this.lbl_verbosity, n, n, n).addComponent(this.cb_verbosity, n, n, n)).addGap(5).addGroup(groupLayout.createParallelGroup(alignment).addGroup(groupLayout.createSequentialGroup().addGap(5).addComponent(this.lbl_keepFiles, n, n, n)).addComponent(this.checkb_keepFiles, n, n, n)).addGap(5));
    }
}

