/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.clientselection.backends.opsidatamodel;

import de.uib.configed.clientselection.Backend;
import de.uib.configed.clientselection.Client;
import de.uib.configed.clientselection.SelectElement;
import de.uib.configed.clientselection.SelectGroupOperation;
import de.uib.configed.clientselection.SelectOperation;
import de.uib.configed.clientselection.backends.opsidatamodel.OpsiDataClient;
import de.uib.configed.clientselection.backends.opsidatamodel.operations.OpsiDataBigIntEqualsOperation;
import de.uib.configed.clientselection.backends.opsidatamodel.operations.OpsiDataBigIntGreaterOrEqualOperation;
import de.uib.configed.clientselection.backends.opsidatamodel.operations.OpsiDataBigIntGreaterThanOperation;
import de.uib.configed.clientselection.backends.opsidatamodel.operations.OpsiDataBigIntLessOrEqualOperation;
import de.uib.configed.clientselection.backends.opsidatamodel.operations.OpsiDataBigIntLessThanOperation;
import de.uib.configed.clientselection.backends.opsidatamodel.operations.OpsiDataDateEqualsOperation;
import de.uib.configed.clientselection.backends.opsidatamodel.operations.OpsiDataDateGreaterOrEqualOperation;
import de.uib.configed.clientselection.backends.opsidatamodel.operations.OpsiDataDateGreaterThanOperation;
import de.uib.configed.clientselection.backends.opsidatamodel.operations.OpsiDataDateLessOrEqualOperation;
import de.uib.configed.clientselection.backends.opsidatamodel.operations.OpsiDataDateLessThanOperation;
import de.uib.configed.clientselection.backends.opsidatamodel.operations.OpsiDataGroupEqualsOperation;
import de.uib.configed.clientselection.backends.opsidatamodel.operations.OpsiDataHardwareOperation;
import de.uib.configed.clientselection.backends.opsidatamodel.operations.OpsiDataIntEqualsOperation;
import de.uib.configed.clientselection.backends.opsidatamodel.operations.OpsiDataIntGreaterOrEqualOperation;
import de.uib.configed.clientselection.backends.opsidatamodel.operations.OpsiDataIntGreaterThanOperation;
import de.uib.configed.clientselection.backends.opsidatamodel.operations.OpsiDataIntLessOrEqualOperation;
import de.uib.configed.clientselection.backends.opsidatamodel.operations.OpsiDataIntLessThanOperation;
import de.uib.configed.clientselection.backends.opsidatamodel.operations.OpsiDataSoftwareOperation;
import de.uib.configed.clientselection.backends.opsidatamodel.operations.OpsiDataStringEqualsOperation;
import de.uib.configed.clientselection.backends.opsidatamodel.operations.OpsiDataSwAuditOperation;
import de.uib.configed.clientselection.backends.opsidatamodel.operations.OpsiSoftwareEqualsOperation;
import de.uib.configed.clientselection.elements.DescriptionElement;
import de.uib.configed.clientselection.elements.GenericBigIntegerElement;
import de.uib.configed.clientselection.elements.GenericEnumElement;
import de.uib.configed.clientselection.elements.GenericIntegerElement;
import de.uib.configed.clientselection.elements.GenericTextElement;
import de.uib.configed.clientselection.elements.GroupElement;
import de.uib.configed.clientselection.elements.IPElement;
import de.uib.configed.clientselection.elements.NameElement;
import de.uib.configed.clientselection.elements.SoftwareActionProgressElement;
import de.uib.configed.clientselection.elements.SoftwareActionResultElement;
import de.uib.configed.clientselection.elements.SoftwareInstallationStatusElement;
import de.uib.configed.clientselection.elements.SoftwareLastActionElement;
import de.uib.configed.clientselection.elements.SoftwareModificationTimeElement;
import de.uib.configed.clientselection.elements.SoftwareNameElement;
import de.uib.configed.clientselection.elements.SoftwarePackageVersionElement;
import de.uib.configed.clientselection.elements.SoftwareRequestElement;
import de.uib.configed.clientselection.elements.SoftwareTargetConfigurationElement;
import de.uib.configed.clientselection.elements.SoftwareVersionElement;
import de.uib.configed.clientselection.elements.SwAuditArchitectureElement;
import de.uib.configed.clientselection.elements.SwAuditLanguageElement;
import de.uib.configed.clientselection.elements.SwAuditLicenseKeyElement;
import de.uib.configed.clientselection.elements.SwAuditNameElement;
import de.uib.configed.clientselection.elements.SwAuditSoftwareIdElement;
import de.uib.configed.clientselection.elements.SwAuditVersionElement;
import de.uib.configed.clientselection.operations.AndOperation;
import de.uib.configed.clientselection.operations.BigIntEqualsOperation;
import de.uib.configed.clientselection.operations.BigIntGreaterOrEqualOperation;
import de.uib.configed.clientselection.operations.BigIntGreaterThanOperation;
import de.uib.configed.clientselection.operations.BigIntLessOrEqualOperation;
import de.uib.configed.clientselection.operations.BigIntLessThanOperation;
import de.uib.configed.clientselection.operations.DateEqualsOperation;
import de.uib.configed.clientselection.operations.DateGreaterOrEqualOperation;
import de.uib.configed.clientselection.operations.DateGreaterThanOperation;
import de.uib.configed.clientselection.operations.DateLessOrEqualOperation;
import de.uib.configed.clientselection.operations.DateLessThanOperation;
import de.uib.configed.clientselection.operations.HardwareOperation;
import de.uib.configed.clientselection.operations.HostOperation;
import de.uib.configed.clientselection.operations.IntEqualsOperation;
import de.uib.configed.clientselection.operations.IntGreaterOrEqualOperation;
import de.uib.configed.clientselection.operations.IntGreaterThanOperation;
import de.uib.configed.clientselection.operations.IntLessOrEqualOperation;
import de.uib.configed.clientselection.operations.IntLessThanOperation;
import de.uib.configed.clientselection.operations.NotOperation;
import de.uib.configed.clientselection.operations.OrOperation;
import de.uib.configed.clientselection.operations.SoftwareOperation;
import de.uib.configed.clientselection.operations.StringEqualsOperation;
import de.uib.configed.clientselection.operations.SwAuditOperation;
import de.uib.configed.type.HostInfo;
import de.uib.configed.type.SWAuditClientEntry;
import de.uib.messages.Messages;
import de.uib.opsidatamodel.PersistenceController;
import de.uib.opsidatamodel.PersistenceControllerFactory;
import de.uib.utilities.logging.logging;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class OpsiDataBackend
extends Backend {
    List<Client> clients;
    Map<String, HostInfo> clientMaps;
    Map<String, Set<String>> groups;
    Map softwareMap;
    Map<String, List<SWAuditClientEntry>> swauditMap;
    List<Map<String, Object>> hardwareOnClient;
    Map<String, List<Map<String, Object>>> clientToHardware;
    private List hwConfig;
    private List hwConfigLocalized;
    private Map<String, String> hwUiToOpsi;
    private Map<String, List> hwClassToValues;
    private PersistenceController controller = PersistenceControllerFactory.getPersistenceController();
    private static OpsiDataBackend instance;

    public static OpsiDataBackend getInstance() {
        if (instance == null) {
            instance = new OpsiDataBackend();
        }
        return instance;
    }

    private OpsiDataBackend() {
        if (this.controller == null) {
            logging.warning(this, "Warning, controller is null!");
        }
        this.getHardwareConfig();
    }

    @Override
    protected SelectOperation createOperation(SelectOperation selectOperation) {
        logging.debug(this, "createOperation operation, data, element: " + selectOperation.getClassName() + ", " + selectOperation.getData().toString() + ",  " + selectOperation.getElement().getClassName());
        SelectElement selectElement = selectOperation.getElement();
        String[] stringArray = selectElement.getPathArray();
        Object object = selectOperation.getData();
        String string = null;
        if (selectElement instanceof NameElement) {
            string = "id";
        } else if (selectElement instanceof IPElement) {
            string = "ipAddress";
        } else if (selectElement instanceof DescriptionElement) {
            string = "description";
        }
        if (string != null) {
            if (selectOperation instanceof StringEqualsOperation) {
                return new OpsiDataStringEqualsOperation("HostMap", string, (String)selectOperation.getData(), selectElement);
            }
            throw new IllegalArgumentException("Wrong operation for this element.");
        }
        if (selectElement instanceof GroupElement && selectOperation instanceof StringEqualsOperation) {
            return new OpsiDataGroupEqualsOperation((String)selectOperation.getData(), selectElement);
        }
        String string2 = null;
        if (selectElement instanceof SoftwareNameElement) {
            string2 = "productId";
        } else if (selectElement instanceof SoftwareVersionElement) {
            string2 = "productVersion";
        } else if (selectElement instanceof SoftwarePackageVersionElement) {
            string2 = "packageVersion";
        } else if (selectElement instanceof SoftwareRequestElement) {
            string2 = "actionRequest";
        } else if (selectElement instanceof SoftwareTargetConfigurationElement) {
            string2 = "targetConfiguration";
        } else if (selectElement instanceof SoftwareInstallationStatusElement) {
            string2 = "installationStatus";
        } else if (selectElement instanceof SoftwareActionProgressElement) {
            string2 = "installationStatus";
        } else if (selectElement instanceof SoftwareActionResultElement) {
            string2 = "actionResult";
        } else if (selectElement instanceof SoftwareLastActionElement) {
            string2 = "lastAction";
        } else if (selectElement instanceof SoftwareModificationTimeElement) {
            string2 = "stateChange";
        }
        if (string2 != null) {
            if (selectOperation instanceof StringEqualsOperation) {
                return new OpsiSoftwareEqualsOperation(string2, (String)selectOperation.getData(), selectElement);
            }
            if (selectOperation instanceof DateEqualsOperation) {
                return new OpsiDataDateEqualsOperation("SoftwareMap", string2, (String)selectOperation.getData(), selectElement);
            }
            if (selectOperation instanceof DateLessThanOperation) {
                return new OpsiDataDateLessThanOperation("SoftwareMap", string2, (String)selectOperation.getData(), selectElement);
            }
            if (selectOperation instanceof DateLessOrEqualOperation) {
                return new OpsiDataDateLessOrEqualOperation("SoftwareMap", string2, (String)selectOperation.getData(), selectElement);
            }
            if (selectOperation instanceof DateGreaterThanOperation) {
                return new OpsiDataDateGreaterThanOperation("SoftwareMap", string2, (String)selectOperation.getData(), selectElement);
            }
            if (selectOperation instanceof DateGreaterOrEqualOperation) {
                return new OpsiDataDateGreaterOrEqualOperation("SoftwareMap", string2, (String)selectOperation.getData(), selectElement);
            }
            throw new IllegalArgumentException("Wrong operation for this element.");
        }
        String string3 = null;
        if (selectElement instanceof SwAuditArchitectureElement) {
            string3 = "architecture";
        } else if (selectElement instanceof SwAuditLanguageElement) {
            string3 = "language";
        } else if (selectElement instanceof SwAuditLicenseKeyElement) {
            string3 = "licenseKey";
        } else if (selectElement instanceof SwAuditNameElement) {
            string3 = "name";
        } else if (selectElement instanceof SwAuditVersionElement) {
            string3 = "version";
        } else if (selectElement instanceof SwAuditSoftwareIdElement) {
            string3 = "windowsSoftwareID";
        }
        if (string3 != null && selectOperation instanceof StringEqualsOperation) {
            return new OpsiDataStringEqualsOperation("SwAuditMap", string3, (String)selectOperation.getData(), selectElement);
        }
        if (selectElement instanceof GenericTextElement || selectElement instanceof GenericIntegerElement || selectElement instanceof GenericBigIntegerElement || selectElement instanceof GenericEnumElement) {
            String string4 = this.hwUiToOpsi.get(stringArray[0]);
            String string5 = this.getKey(stringArray);
            if (selectOperation instanceof StringEqualsOperation) {
                return new OpsiDataStringEqualsOperation(string4, string5, (String)object, selectElement);
            }
            if (selectOperation instanceof IntLessThanOperation) {
                return new OpsiDataIntLessThanOperation(string4, string5, (Integer)object, selectElement);
            }
            if (selectOperation instanceof IntLessOrEqualOperation) {
                return new OpsiDataIntLessOrEqualOperation(string4, string5, (Integer)object, selectElement);
            }
            if (selectOperation instanceof IntGreaterThanOperation) {
                return new OpsiDataIntGreaterThanOperation(string4, string5, (Integer)object, selectElement);
            }
            if (selectOperation instanceof IntGreaterOrEqualOperation) {
                return new OpsiDataIntGreaterOrEqualOperation(string4, string5, (Integer)object, selectElement);
            }
            if (selectOperation instanceof IntEqualsOperation) {
                return new OpsiDataIntEqualsOperation(string4, string5, (Integer)object, selectElement);
            }
            if (selectOperation instanceof BigIntLessThanOperation) {
                return new OpsiDataBigIntLessThanOperation(string4, string5, (Long)object, selectElement);
            }
            if (selectOperation instanceof BigIntLessOrEqualOperation) {
                return new OpsiDataBigIntLessOrEqualOperation(string4, string5, (Long)object, selectElement);
            }
            if (selectOperation instanceof BigIntGreaterThanOperation) {
                return new OpsiDataBigIntGreaterThanOperation(string4, string5, (Long)object, selectElement);
            }
            if (selectOperation instanceof BigIntGreaterOrEqualOperation) {
                return new OpsiDataBigIntGreaterOrEqualOperation(string4, string5, (Long)object, selectElement);
            }
            if (selectOperation instanceof BigIntEqualsOperation) {
                return new OpsiDataBigIntEqualsOperation(string4, string5, (Long)object, selectElement);
            }
        }
        logging.error("IllegalArgument: The operation " + selectOperation + " was not found on " + selectElement);
        throw new IllegalArgumentException("The operation " + selectOperation + " was not found on " + selectElement);
    }

    @Override
    protected SelectGroupOperation createGroupOperation(SelectGroupOperation selectGroupOperation, List<SelectOperation> list) {
        if (selectGroupOperation instanceof AndOperation && list.size() >= 2) {
            return new AndOperation(list);
        }
        if (selectGroupOperation instanceof OrOperation && list.size() >= 2) {
            return new OrOperation(list);
        }
        if (selectGroupOperation instanceof NotOperation && list.size() == 1) {
            return new NotOperation(list.get(0));
        }
        if (selectGroupOperation instanceof SoftwareOperation && list.size() == 1) {
            return new OpsiDataSoftwareOperation(list.get(0));
        }
        if (selectGroupOperation instanceof SwAuditOperation && list.size() == 1) {
            return new OpsiDataSwAuditOperation(list.get(0));
        }
        if (selectGroupOperation instanceof HardwareOperation && list.size() == 1) {
            return new OpsiDataHardwareOperation(list.get(0));
        }
        if (selectGroupOperation instanceof HostOperation && list.size() == 1) {
            return new HostOperation(list.get(0));
        }
        logging.error(this, "IllegalArgument: The group operation " + selectGroupOperation + " was not found with " + list.size() + " operations");
        throw new IllegalArgumentException("The group operation " + selectGroupOperation + " was not found with " + list.size() + " operations");
    }

    @Override
    public void setReloadRequested() {
        logging.info(this, "setReloadRequested");
        super.setReloadRequested();
        this.clientMaps = null;
        this.groups = null;
        this.softwareMap = null;
        this.controller.productDataRequestRefresh();
        this.swauditMap = null;
        this.controller.softwareAuditOnClientsRequestRefresh();
        this.hardwareOnClient = null;
        this.clientToHardware = null;
        System.gc();
    }

    private void checkInitData() {
        logging.info(this, "checkInitData ");
        this.clientMaps = this.controller.getHostInfoCollections().getMapOfPCInfoMaps();
        logging.info(this, "client maps size " + this.clientMaps.size());
        this.groups = this.controller.getFObject2Groups();
        String[] stringArray = this.clientMaps.keySet().toArray(new String[0]);
        if (this.hasSoftware) {
            this.softwareMap = this.controller.getMapOfProductStatesAndActions(stringArray);
            logging.debug(this, "getClients softwareMap ");
        }
        this.swauditMap = this.getSwAuditOnClients();
        this.getHardwareConfig();
        logging.debug(this, "getClients hasHardware " + this.hasHardware);
        if (this.hasHardware) {
            this.getHardwareOnClient(stringArray);
        } else {
            this.hardwareOnClient = null;
        }
        this.reloadRequested = false;
    }

    @Override
    protected List<Client> getClients() {
        LinkedList<Client> linkedList = new LinkedList<Client>();
        this.checkInitData();
        logging.info(this, "getClients hasSoftware " + this.hasSoftware);
        logging.info(this, "getClients hasHardware " + this.hasHardware);
        logging.info(this, "getClients hasSoftware " + this.hasSoftware);
        logging.info(this, "getClients swauditMap != null  " + (this.swauditMap != null));
        for (String string : this.clientMaps.keySet()) {
            OpsiDataClient opsiDataClient = new OpsiDataClient(string);
            opsiDataClient.setInfoMap(this.clientMaps.get(string).getMap());
            if (this.hasHardware) {
                opsiDataClient.setHardwareInfo(this.clientToHardware.get(string));
            }
            if (this.groups.containsKey(string)) {
                opsiDataClient.setGroups(this.groups.get(string));
            }
            if (this.hasSoftware && this.softwareMap.containsKey(string) && this.softwareMap.get(string) instanceof List) {
                opsiDataClient.setOpsiProductList((List)this.softwareMap.get(string));
            }
            if (this.swauditMap != null && this.swauditMap.containsKey(string)) {
                opsiDataClient.setSwAuditList(this.swauditMap.get(string));
            }
            linkedList.add(opsiDataClient);
        }
        return linkedList;
    }

    @Override
    public List<String> getGroups() {
        return this.controller.getHostGroupIds();
    }

    @Override
    public TreeSet<String> getProductIDs() {
        return this.controller.getProductIds();
    }

    @Override
    public Map<String, List<SelectElement>> getHardwareList() {
        HashMap<String, List<SelectElement>> hashMap = new HashMap<String, List<SelectElement>>();
        for (int i = 0; i < this.hwConfig.size(); ++i) {
            Map map = (Map)this.hwConfig.get(i);
            Map map2 = (Map)this.hwConfigLocalized.get(i);
            String string = (String)((Map)map.get("Class")).get("UI");
            String string2 = (String)((Map)map2.get("Class")).get("UI");
            LinkedList<SelectElement> linkedList = new LinkedList<SelectElement>();
            List list = (List)map.get("Values");
            List list2 = (List)map2.get("Values");
            for (int j = 0; j < list.size(); ++j) {
                Map map3 = (Map)list.get(j);
                String string3 = (String)map3.get("Type");
                String string4 = (String)map3.get("UI");
                String string5 = (String)((Map)list2.get(j)).get("UI");
                if (string3.equals("int") || string3.equals("tinyint")) {
                    linkedList.add(new GenericIntegerElement(new String[]{string, string4}, string2, string5));
                    continue;
                }
                if (string3.equals("bigint")) {
                    linkedList.add(new GenericBigIntegerElement(new String[]{string, string4}, string2, string5));
                    continue;
                }
                linkedList.add(new GenericTextElement(new String[]{string, string4}, string2, string5));
            }
            hashMap.put(string, linkedList);
            logging.debug(this, "" + linkedList);
        }
        return hashMap;
    }

    @Override
    public Map<String, List<SelectElement>> getLocalizedHardwareList() {
        HashMap<String, List<SelectElement>> hashMap = new HashMap<String, List<SelectElement>>();
        for (int i = 0; i < this.hwConfig.size(); ++i) {
            Map map = (Map)this.hwConfig.get(i);
            Map map2 = (Map)this.hwConfigLocalized.get(i);
            String string = (String)((Map)map.get("Class")).get("UI");
            String string2 = (String)((Map)map2.get("Class")).get("UI");
            LinkedList<SelectElement> linkedList = new LinkedList<SelectElement>();
            List list = (List)map.get("Values");
            List list2 = (List)map2.get("Values");
            for (int j = 0; j < list.size(); ++j) {
                Map map3 = (Map)list.get(j);
                String string3 = (String)map3.get("Type");
                String string4 = (String)map3.get("UI");
                String string5 = (String)((Map)list2.get(j)).get("UI");
                if (string3.equals("int") || string3.equals("tinyint")) {
                    linkedList.add(new GenericIntegerElement(new String[]{string, string4}, string2, string5));
                    continue;
                }
                if (string3.equals("bigint")) {
                    linkedList.add(new GenericBigIntegerElement(new String[]{string, string4}, string2, string5));
                    continue;
                }
                linkedList.add(new GenericTextElement(new String[]{string, string4}, string2, string5));
            }
            hashMap.put(string2, linkedList);
            logging.debug(this, "" + linkedList);
        }
        return hashMap;
    }

    private String getKey(String[] stringArray) {
        logging.debug(this, stringArray[0]);
        List list = this.hwClassToValues.get(this.hwUiToOpsi.get(stringArray[0]));
        if (list != null) {
            for (Object e : list) {
                Map map = (Map)e;
                if (!stringArray[1].equals((String)map.get("UI"))) continue;
                return (String)map.get("Opsi");
            }
        }
        logging.error(this, "Element not found: " + Arrays.toString(stringArray));
        return "";
    }

    private void getHardwareOnClient(String[] stringArray) {
        this.hardwareOnClient = this.controller.getHardwareOnClient();
        this.clientToHardware = new HashMap<String, List<Map<String, Object>>>();
        for (int i = 0; i < stringArray.length; ++i) {
            this.clientToHardware.put(stringArray[i], new LinkedList());
        }
        for (Map<String, Object> map : this.hardwareOnClient) {
            String string = (String)map.get("hostId");
            if (!this.clientToHardware.containsKey(string)) {
                logging.debug(this, "Non-client hostid: " + string);
                continue;
            }
            this.clientToHardware.get(string).add(map);
        }
    }

    private Map<String, List<SWAuditClientEntry>> getSwAuditOnClients() {
        Map<String, List<SWAuditClientEntry>> map = new HashMap<String, List<SWAuditClientEntry>>();
        if (!this.hasSwAudit) {
            return map;
        }
        this.controller.fillClient2Software(new ArrayList<String>(this.clientMaps.keySet()));
        map = this.controller.getClient2Software();
        return map;
    }

    private void getHardwareConfig() {
        String string = Messages.getLocale().getLanguage() + "_" + Messages.getLocale().getCountry();
        logging.debug(this, string);
        this.hwConfig = this.controller.getOpsiHWAuditConf("en_");
        this.hwConfigLocalized = this.controller.getOpsiHWAuditConf(string);
        logging.debug(this, "" + this.hwConfig);
        this.hwUiToOpsi = new HashMap<String, String>();
        this.hwClassToValues = new HashMap<String, List>();
        for (Object e : this.hwConfig) {
            Map map = (Map)e;
            String string2 = (String)((Map)map.get("Class")).get("UI");
            String string3 = (String)((Map)map.get("Class")).get("Opsi");
            List list = (List)map.get("Values");
            this.hwUiToOpsi.put(string2, string3);
            this.hwClassToValues.put(string3, list);
        }
    }

    private String getHardwareTableName(String string) {
        return this.hwUiToOpsi.get(string);
    }
}

