/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities.observer.swing;

import de.uib.utilities.logging.logging;
import de.uib.utilities.observer.DataEditListener;
import de.uib.utilities.observer.ObservableSubject;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;

public class JTextFieldObserved
extends JTextField
implements KeyListener {
    protected String startText = "";
    protected ObservableSubject globalEditingSubject;

    public JTextFieldObserved() {
        this((ObservableSubject)null);
    }

    public JTextFieldObserved(ObservableSubject observableSubject) {
        this("", observableSubject);
    }

    public JTextFieldObserved(String string, ObservableSubject observableSubject) {
        super(string);
        this.addKeyListener(this);
        this.setGlobalObservableSubject(observableSubject);
    }

    public void setGlobalObservableSubject(ObservableSubject observableSubject) {
        logging.debug(this, "setGlobalObservableSubject " + observableSubject);
        this.globalEditingSubject = observableSubject;
        this.addKeyListener(new DataEditListener(observableSubject, this));
        this.getDocument().addDocumentListener(new DataEditListener(observableSubject, this));
    }

    @Override
    public void setText(String string) {
        super.setText(string);
        this.startText = string;
        this.setCaretPosition(0);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.setText(this.startText);
            this.setCaretPosition(this.startText.length());
        } else if (keyEvent.getKeyCode() == 10) {
            this.transferFocus();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }
}

