/*
 * Decompiled with CFR 0.152.
 */
package de.uib.opsicommand;

import de.uib.utilities.logging.logging;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OpsiMethodCall {
    private HashMap theCall;
    private String methodname;
    private Object[] parameters;
    public static final boolean BACKGROUND = true;
    private boolean background;
    protected static final int defaultJsonId = 1;
    public static String extendRpcPath = "extend/configed";
    private String rpcPath = "";
    public static final Vector<String> collectedCalls = new Vector();
    public static int maxCollectSize = -1;

    public OpsiMethodCall(String string, Object[] objectArray, boolean bl) {
        this.methodname = string;
        this.parameters = objectArray;
        this.theCall = new HashMap();
        this.theCall.put("method", string);
        this.theCall.put("params", objectArray);
        this.theCall.put("rpcpath", this.rpcPath);
        this.background = bl;
        this.collectCall();
    }

    public OpsiMethodCall(String string, Object[] objectArray) {
        this.methodname = string;
        this.parameters = objectArray;
        this.theCall = new HashMap();
        this.theCall.put("method", string);
        this.theCall.put("params", objectArray);
        this.theCall.put("rpcpath", this.rpcPath);
        this.background = false;
        this.collectCall();
    }

    private void collectCall() {
        if (maxCollectSize < 0 || maxCollectSize != 0 && collectedCalls.size() >= maxCollectSize) {
            return;
        }
        collectedCalls.add(this.getMethodname() + "\n\t" + this.getParameter());
    }

    public static void report() {
        logging.check("==========   collected calls");
        for (String string : collectedCalls) {
            logging.check(string);
        }
        logging.check("==========");
    }

    public String getRpcPath() {
        return this.rpcPath;
    }

    public OpsiMethodCall activateExtendedRpcPath() {
        logging.info(this, "activateExtendedRpcPath");
        this.rpcPath = extendRpcPath;
        return this;
    }

    public String getMethodname() {
        return this.methodname;
    }

    public String getParameter() {
        return Arrays.toString(this.parameters);
    }

    public boolean isBackground() {
        return this.background;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{");
        stringBuffer.append("rpcpath=");
        stringBuffer.append(this.rpcPath);
        stringBuffer.append(", ");
        stringBuffer.append("method=");
        stringBuffer.append(this.methodname);
        stringBuffer.append(", ");
        stringBuffer.append("params=");
        stringBuffer.append("[");
        if (this.parameters != null && this.parameters.length > 0) {
            for (int i = 0; i < this.parameters.length; ++i) {
                Object object = this.parameters[i];
                if (object instanceof Object[]) {
                    stringBuffer.append(Arrays.toString((Object[])object));
                    continue;
                }
                if (object instanceof Map) {
                    stringBuffer.append("{");
                    for (Object k : ((Map)object).keySet()) {
                        stringBuffer.append("" + k + ": ");
                        if (((Map)object).get(k) instanceof Object[]) {
                            stringBuffer.append(Arrays.toString((Object[])((Map)object).get(k)));
                        } else {
                            stringBuffer.append("" + ((Map)object).get(k));
                        }
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append("}");
                    continue;
                }
                stringBuffer.append("" + object);
            }
        }
        stringBuffer.append("]");
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public String getCommandLineString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.methodname);
        stringBuffer.append("(");
        if (this.parameters.length > 0) {
            stringBuffer.append(this.parameters[0].toString());
            for (int i = 1; i < this.parameters.length; ++i) {
                stringBuffer.append("&");
                stringBuffer.append(this.parameters[i].toString());
            }
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String getJsonString() {
        String string = "";
        try {
            JSONObject jSONObject = new JSONObject();
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < this.parameters.length; ++i) {
                Object object;
                if (this.parameters[i] instanceof Object[]) {
                    object = (Object[])this.parameters[i];
                    JSONArray jSONArray2 = new JSONArray();
                    for (int j = 0; j < ((Object[])object).length; ++j) {
                        jSONArray2.put(object[j]);
                    }
                    jSONArray.put(jSONArray2);
                    continue;
                }
                if (this.parameters[i] instanceof Map) {
                    object = new JSONObject((Map)this.parameters[i]);
                    jSONArray.put(object);
                    continue;
                }
                jSONArray.put(this.parameters[i]);
            }
            jSONObject.put("id", 1);
            jSONObject.put("method", this.methodname);
            jSONObject.put("params", jSONArray);
            string = jSONObject.toString();
        }
        catch (JSONException jSONException) {
            logging.error(this, "Exception while producing a JSONObject, " + jSONException.toString());
        }
        return string;
    }
}

