/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.tree;

import de.uib.configed.Globals;
import de.uib.configed.tree.IconNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultTreeCellRenderer;

public class IconNodeRenderer
extends DefaultTreeCellRenderer {
    public static int labelWidth = 200;
    public static int labelHeight = 20;

    public IconNodeRenderer() {
        this.setOpaque(true);
        this.setForeground(Globals.lightBlack);
        this.setTextSelectionColor(Globals.lightBlack);
        this.setBackground(Color.white);
        this.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.setPreferredSize(new Dimension(labelWidth, labelHeight));
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        if (object instanceof IconNode) {
            String string = jTree.convertValueToText(object, bl, bl2, bl3, n, bl4);
            this.setText(string);
            IconNode iconNode = (IconNode)object;
            boolean bl5 = jTree.isEnabled();
            this.setEnabled(bl5);
            iconNode.setEnabled(bl5);
            if (bl) {
                this.setBackground(Globals.backLightBlue);
            } else {
                this.setBackground(Color.white);
            }
            if (bl3) {
                this.setIcon(iconNode.getLeafIcon());
            } else if (bl2) {
                this.setIcon(iconNode.getOpenIcon());
            } else {
                this.setIcon(iconNode.getClosedIcon());
            }
            this.setComponentOrientation(jTree.getComponentOrientation());
            return this;
        }
        return this;
    }
}

