/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities;

import de.uib.utilities.logging.logging;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.TreeSet;

public class PropertiesStore {
    File myStore;
    protected static final String keySeparator = "=";
    private HashMap<String, String> internalStore = new HashMap();

    public PropertiesStore() {
        this(null);
    }

    public PropertiesStore(File file) {
        this.myStore = file;
    }

    public void setStore(File file) {
        this.myStore = file;
    }

    public void load() throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.myStore));
        String string = bufferedReader.readLine();
        while (string != null) {
            logging.debug(this, "line: " + string);
            String string2 = string.trim();
            if (string2.length() != 0 && string2.charAt(0) != '#' && string2.charAt(0) != ';') {
                int n = string.indexOf(keySeparator);
                String string3 = string.substring(0, n);
                String string4 = null;
                if (string.length() > n) {
                    string4 = string.substring(n + 1);
                }
                if (string4 != null) {
                    this.setProperty(string3, string4);
                }
                logging.debug(this, "key, value " + string3 + ", " + string4);
            }
            string = bufferedReader.readLine();
        }
        bufferedReader.close();
    }

    public String getProperty(String string) {
        return this.getProperty(string, null);
    }

    public String getProperty(String string, String string2) {
        return this.getProp(string, string2);
    }

    protected final String getProp(String string, String string2) {
        String string3 = this.internalStore.get(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public void setProperty(String string, String string2) {
        this.setProp(string, string2);
    }

    protected final void setProp(String string, String string2) {
        this.internalStore.put(string, string2);
    }

    private TreeSet<String> formOutputLines() {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String string : this.internalStore.keySet()) {
            if (this.getProperty(string) == null) continue;
            treeSet.add(string + keySeparator + this.getProperty(string));
        }
        return treeSet;
    }

    public void store(String string) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null) {
            arrayList.add("# " + string);
        }
        arrayList.add("# " + DateFormat.getDateTimeInstance(1, 1).format(new Date()));
        arrayList.addAll(this.formOutputLines());
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.myStore));
        for (String string2 : arrayList) {
            bufferedWriter.write(string2);
            bufferedWriter.newLine();
        }
        bufferedWriter.close();
    }
}

