/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.clientselection.backends.opsidatamodel.operations;

import de.uib.configed.clientselection.Client;
import de.uib.configed.clientselection.ExecutableOperation;
import de.uib.configed.clientselection.SelectElement;
import de.uib.configed.clientselection.backends.opsidatamodel.OpsiDataClient;
import de.uib.configed.clientselection.operations.StringEqualsOperation;
import de.uib.utilities.logging.logging;
import java.util.Map;

public class OpsiDataStringEqualsOperation
extends StringEqualsOperation
implements ExecutableOperation {
    protected String map;
    protected String key;
    protected String data;
    protected String[] dataSplitted = null;
    protected boolean startsWith;
    protected boolean endsWith;

    public OpsiDataStringEqualsOperation(String string, String string2, String string3, SelectElement selectElement) {
        super(selectElement);
        logging.debug(this, "OpsiDataStringEqualsOperation maptype, key, data: " + string + ", " + string2 + ", " + string3);
        this.map = string;
        this.key = string2;
        this.data = string3.toLowerCase();
        if (string3.contains("*")) {
            this.dataSplitted = this.data.split("\\*");
            logging.debug(this, "OpsiDataStringEqualsOperation " + String.valueOf(this.dataSplitted.length));
        }
        this.startsWith = string3.startsWith("*");
        this.endsWith = string3.endsWith("*");
    }

    @Override
    public boolean doesMatch(Client client) {
        OpsiDataClient opsiDataClient = (OpsiDataClient)client;
        Map map = opsiDataClient.getMap(this.map);
        if (!map.containsKey(this.key) || map.get(this.key) == null) {
            return false;
        }
        String string = map.get(this.key).toString().toLowerCase();
        return this.checkData(string);
    }

    protected boolean checkData(String string) {
        String string2 = string.toLowerCase();
        if (this.dataSplitted == null) {
            return string2.equals(this.data);
        }
        if (this.dataSplitted.length == 0) {
            return string.length() > 0;
        }
        if (!this.startsWith && !string2.startsWith(this.dataSplitted[0])) {
            return false;
        }
        int n = 0;
        for (int i = 0; i < this.dataSplitted.length && n >= 0; ++i) {
            if (this.dataSplitted[i].isEmpty() || (n = string2.indexOf(this.dataSplitted[i], n)) < 0) continue;
            n += this.dataSplitted[i].length();
        }
        if (n < 0) {
            return false;
        }
        return this.endsWith || string2.endsWith(this.dataSplitted[this.dataSplitted.length - 1]);
    }
}

