/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities.table.provider;

import de.uib.utilities.logging.logging;
import de.uib.utilities.table.provider.TableSource;
import java.util.Map;
import java.util.Vector;

public class MapSource
implements TableSource {
    protected Vector<String> columnNames;
    protected Vector<String> classNames;
    protected Map<String, Map> table;
    protected Vector<Vector> rows;
    protected boolean reloadRequested = true;

    public MapSource(Vector<String> vector, Vector<String> vector2, Map<String, Map> map) {
        this.columnNames = vector;
        this.classNames = vector2;
        this.table = map;
        this.rows = new Vector();
    }

    private static boolean dynInstanceOf(Object object, Class clazz) {
        return clazz.isAssignableFrom(object.getClass());
    }

    protected void fetchData() {
        this.rows.clear();
        for (String string : this.table.keySet()) {
            Vector vector = new Vector();
            Map map = this.table.get(string);
            for (int i = 0; i < this.columnNames.size(); ++i) {
                Object v = map.get(this.columnNames.get(i));
                vector.add(v);
                if (v == null) {
                    logging.warning(this, " ob == null, possibly the column name is not correct, column " + i + ", " + this.columnNames.get(i));
                    continue;
                }
                try {
                    Class<?> clazz = Class.forName(this.classNames.get(i));
                    if (MapSource.dynInstanceOf(v, clazz)) continue;
                    logging.warning(this, "MapSource fetchData(): data type does not fit");
                    logging.debug(this, " ob " + v + " class " + v.getClass().getName());
                    logging.debug(this, "class should be " + clazz);
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    logging.warning(this, " " + nullPointerException + ", could not get dyninstance " + i + ", " + this.columnNames.get(i));
                    continue;
                }
                catch (Exception exception) {
                    logging.debugOut(1, "MapSource fetchData(): class " + this.classNames.get(i) + " not found, " + exception);
                }
            }
            this.rows.add(vector);
        }
    }

    @Override
    public Vector<String> retrieveColumnNames() {
        return this.columnNames;
    }

    @Override
    public Vector<String> retrieveClassNames() {
        return this.classNames;
    }

    @Override
    public Vector<Vector> retrieveRows() {
        if (this.reloadRequested) {
            this.fetchData();
            this.reloadRequested = false;
        }
        return this.rows;
    }

    @Override
    public void requestReload() {
        this.reloadRequested = true;
    }
}

