/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities.swing.list;

import de.uib.configed.Globals;
import de.uib.utilities.swing.list.StandardListCellRenderer;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;

public class ListCellRendererByIndex
extends StandardListCellRenderer {
    protected Map<String, String> mapOfStrings;
    protected Map<String, String> mapOfTooltips;
    protected Map<String, ImageIcon> mapOfImages;
    static final int imageDefaultWidth = 30;
    protected boolean showOnlyIcon = false;

    public ListCellRendererByIndex(Map<String, String> map, Map<String, String> map2, String string, int n, boolean bl, String string2) {
        super(string2);
        this.showOnlyIcon = bl;
        this.mapOfStrings = map;
        this.mapOfTooltips = map2;
        this.mapOfImages = new HashMap<String, ImageIcon>();
        for (Map.Entry<String, String> entry : this.mapOfStrings.entrySet()) {
            String string3 = entry.getKey();
            String string4 = entry.getValue();
            ImageIcon imageIcon = null;
            if (string == null || string3 == null || string4 == null) continue;
            String string5 = string + "/" + string3 + ".png";
            imageIcon = Globals.createImageIcon(string5, string4);
            if (imageIcon == null) {
                string5 = string + "/" + string4 + ".gif";
                imageIcon = Globals.createImageIcon(string5, string4);
            }
            if (imageIcon == null) continue;
            this.mapOfImages.put(string3, imageIcon);
        }
    }

    @Override
    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        JComponent jComponent;
        Component component = super.getListCellRendererComponent(jList, object, n, bl, bl2);
        if (component == null || !(component instanceof JComponent)) {
            return component;
        }
        if (object == null) {
            return component;
        }
        String string = this.mapOfTooltips.get(object);
        if (string == null || string.equals("")) {
            string = this.mapOfStrings.get(object);
        }
        if ((jComponent = (JComponent)component) instanceof JLabel) {
            ((JLabel)jComponent).setToolTipText(Globals.fillStringToLength(this.tooltipPrefix + " " + string + " ", this.FILL_LENGTH));
        }
        return jComponent;
    }
}

