/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities.datapanel;

import de.uib.utilities.logging.logging;
import de.uib.utilities.table.DefaultListCellOptions;
import de.uib.utilities.table.DefaultListModelProducer;
import de.uib.utilities.table.ListCellOptions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JTable;
import javax.swing.ListModel;

public class ListModelProducerForVisualDatamap
extends DefaultListModelProducer {
    Map<Integer, ListModel> listmodels = new HashMap<Integer, ListModel>();
    Map<String, ListCellOptions> optionsMap;
    Map<String, List> currentData;
    Map<String, Class> originalTypes;
    JTable table;

    public ListModelProducerForVisualDatamap(JTable jTable, Map<String, ListCellOptions> map, Map map2) {
        this.table = jTable;
        this.setData(map, map2);
    }

    public void setData(Map<String, ListCellOptions> map, Map map2) {
        this.optionsMap = map;
        this.mapTypes(map2);
    }

    public void updateData(Map map) {
        this.mapTypes(map);
    }

    private ListCellOptions getListCellOptions(String string) {
        ListCellOptions listCellOptions = this.optionsMap.get(string);
        if (listCellOptions == null) {
            listCellOptions = new DefaultListCellOptions();
            this.optionsMap.put(string, listCellOptions);
        }
        return listCellOptions;
    }

    private void mapTypes(Map map) {
        this.currentData = new HashMap<String, List>();
        logging.debug(this, "mapTypes  " + map);
        this.originalTypes = new HashMap<String, Class>();
        for (Object k : map.keySet()) {
            Object v = map.get(k);
            this.originalTypes.put((String)k, v.getClass());
            this.currentData.put((String)k, this.toList(v));
        }
    }

    @Override
    public ListModel getListModel(int n, int n2) {
        if (this.listmodels.get(n) != null) {
            return this.listmodels.get(n);
        }
        String string = (String)this.table.getValueAt(n, 0);
        ListCellOptions listCellOptions = this.getListCellOptions(string);
        List list = listCellOptions.getPossibleValues();
        DefaultListModel defaultListModel = new DefaultListModel();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            defaultListModel.addElement(iterator.next());
        }
        if (this.currentData.get(string) != null && this.currentData.get(string) instanceof List) {
            for (Object e : this.currentData.get(string)) {
                if (defaultListModel.contains(e)) continue;
                defaultListModel.addElement(e);
            }
        }
        this.listmodels.put(n, defaultListModel);
        return defaultListModel;
    }

    @Override
    public List getSelectedValues(int n, int n2) {
        String string = (String)this.table.getValueAt(n, 0);
        return this.currentData.get(string);
    }

    @Override
    public void setSelectedValues(List list, int n, int n2) {
        String string = (String)this.table.getValueAt(n, 0);
        this.currentData.put(string, list);
        this.table.setValueAt(list, n, 1);
    }

    @Override
    public int getSelectionMode(int n, int n2) {
        String string = (String)this.table.getValueAt(n, 0);
        return this.getListCellOptions(string).getSelectionMode();
    }

    @Override
    public boolean getEditable(int n, int n2) {
        String string = (String)this.table.getValueAt(n, 0);
        return this.getListCellOptions(string).isEditable();
    }

    @Override
    public String getCaption(int n, int n2) {
        return (String)this.table.getValueAt(n, 0);
    }

    @Override
    public Class getClass(int n, int n2) {
        String string = (String)this.table.getValueAt(n, 0);
        return this.originalTypes.get(string);
    }
}

