/*
 * Decompiled with CFR 0.152.
 */
package de.uib.opsidatamodel.productstate;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class ActionProgress {
    public static final String KEY = "actionProgress";
    public static final int CONFLICT = -4;
    public static final int INVALID = -2;
    public static final int NOT_AVAILABLE = -6;
    public static final int NONE = 0;
    public static final int INSTALLING = 1;
    private static Map<Integer, String> state2label;
    private static Map<String, Integer> label2state;
    private static Map<String, String> label2displayLabel;
    private static Map<String, String> displayLabel2label;
    private static Vector<Integer> states;
    private static Vector<String> labels;
    private static String[] choiceLabels;
    private int state = -2;

    private static void checkCollections() {
        if (states != null) {
            return;
        }
        states = new Vector();
        states.add(-4);
        states.add(-2);
        states.add(-6);
        states.add(0);
        states.add(1);
        labels = new Vector();
        labels.add("mixed");
        labels.add("");
        labels.add("not_available");
        labels.add("none");
        labels.add("installing");
        state2label = new HashMap<Integer, String>();
        state2label.put(-4, "mixed");
        state2label.put(-2, "");
        state2label.put(-6, "not_available");
        state2label.put(0, "none");
        state2label.put(1, "installing");
        label2state = new HashMap<String, Integer>();
        label2state.put("mixed", -4);
        label2state.put("", -2);
        label2state.put("not_available", -6);
        label2state.put("none", 0);
        label2state.put("installing", 1);
        label2displayLabel = new HashMap<String, String>();
        label2displayLabel.put("mixed", "mixed");
        label2displayLabel.put("", "");
        label2displayLabel.put("not_available", "not_available");
        label2displayLabel.put("none", "no process reported");
        label2displayLabel.put("installing", "installing");
        displayLabel2label = new HashMap<String, String>();
        displayLabel2label.put("mixed", "mixed");
        displayLabel2label.put("", "");
        displayLabel2label.put("not_available", "not_available");
        displayLabel2label.put("no process reported", "none");
        displayLabel2label.put("installing", "installing");
        choiceLabels = new String[]{label2displayLabel.get("none")};
    }

    public static Map<String, String> getLabel2DisplayLabel() {
        ActionProgress.checkCollections();
        return label2displayLabel;
    }

    public static boolean existsState(int n) {
        ActionProgress.checkCollections();
        return states.contains(n);
    }

    public static boolean existsLabel(String string) {
        ActionProgress.checkCollections();
        return labels.contains(string);
    }

    public static String getLabel(int n) {
        ActionProgress.checkCollections();
        if (!ActionProgress.existsState(n)) {
            return null;
        }
        return state2label.get(n);
    }

    public static Vector<String> getLabels() {
        ActionProgress.checkCollections();
        return labels;
    }

    public static Integer getVal(String string) {
        ActionProgress.checkCollections();
        if (string == null || string.equals("")) {
            return 0;
        }
        if (!ActionProgress.existsLabel(string)) {
            return null;
        }
        return label2state.get(string);
    }

    public static String getDisplayLabel(int n) {
        ActionProgress.checkCollections();
        return label2displayLabel.get(ActionProgress.getLabel(n));
    }

    public int getVal() {
        return this.state;
    }

    public String getString() {
        return ActionProgress.getLabel(this.state);
    }

    public String toString() {
        return ActionProgress.getLabel(this.state);
    }

    public static ActionProgress produceFromDisplayLabel(String string) {
        return ActionProgress.produceFromLabel(displayLabel2label.get(string));
    }

    public static ActionProgress produceFromLabel(String string) {
        ActionProgress.checkCollections();
        if (string == null) {
            return new ActionProgress(-6);
        }
        if (!labels.contains(string)) {
            return new ActionProgress(-2);
        }
        return new ActionProgress(ActionProgress.getVal(string));
    }

    public ActionProgress() {
    }

    public ActionProgress(int n) {
        this.state = ActionProgress.existsState(n) ? n : -6;
    }

    public static void main(String[] stringArray) {
        System.out.println(" test ActionProgress.java");
        ActionProgress.checkCollections();
        Iterator<Integer> iterator = states.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ++n;
            int n2 = iterator.next();
        }
    }
}

