/*
 * Decompiled with CFR 0.152.
 */
package de.uib.messages;

import de.uib.messages.LocaleRepresentation;
import de.uib.utilities.logging.logging;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.TreeSet;
import utils.ResourceBundleUtf8;

public class Messages {
    private static final String prefix = "configed_";
    private static final String BUNDLE_NAME = "de/uib/messages/configed";
    private static final String FILE_TYPE = "properties";
    private static final String LOCALISATIONS_CONF = "valid_localisations.conf";
    static List<LocaleRepresentation> existingLocales;
    static List<String> existingLocalesNames;
    static Map<String, String> localeInfo;
    static String selectedLocaleString;
    static Locale myLocale;
    public static ResourceBundle messages;
    public static ResourceBundle messagesEN;
    static List<String> myLocaleCharacteristics;
    static List<String> myLocaleCharacteristicsEN;

    private static String findSelectedLocale(String string, String string2) {
        String string3 = null;
        myLocaleCharacteristics = new ArrayList<String>();
        String string4 = string + "_" + string2;
        myLocaleCharacteristics.add(string4);
        if (existingLocalesNames.indexOf(string4) > -1) {
            string3 = string4;
        }
        string4 = string;
        myLocaleCharacteristics.add(string4);
        if (string3 == null && existingLocalesNames.indexOf(string4) > -1) {
            string3 = string4;
        }
        return string3;
    }

    public static String getSelectedLocale() {
        selectedLocaleString = Messages.findSelectedLocale(myLocale.getLanguage(), myLocale.getCountry());
        if (selectedLocaleString == null) {
            Messages.produceLocale();
            selectedLocaleString = Messages.findSelectedLocale(myLocale.getLanguage(), myLocale.getCountry());
            if (selectedLocaleString == null) {
                Messages.produceLocale_enUS();
                selectedLocaleString = Messages.findSelectedLocale(myLocale.getLanguage(), myLocale.getCountry());
            }
        }
        return selectedLocaleString;
    }

    public static ResourceBundle getResource() throws MissingResourceException {
        try {
            logging.debug("Messages, getResource from de/uib/messages/configed");
            messages = ResourceBundleUtf8.getBundle(BUNDLE_NAME, myLocale);
            logging.debug("Messages messages " + messages);
            for (String string : messages.keySet()) {
                logging.debug("key " + string + ", value " + messages.getString(string));
            }
        }
        catch (MissingResourceException missingResourceException) {
            messages = Messages.getResourceEN();
        }
        return messages;
    }

    public static ResourceBundle getResourceEN() throws MissingResourceException {
        messagesEN = ResourceBundleUtf8.getBundle(BUNDLE_NAME, new Locale("en", "US"));
        myLocaleCharacteristicsEN = new ArrayList<String>();
        myLocaleCharacteristicsEN.add("en_US");
        myLocaleCharacteristicsEN.add("en");
        return messagesEN;
    }

    private static Locale giveLocale(String string) {
        logging.debug("Messages: selected locale " + myLocale + " by " + string);
        return myLocale;
    }

    private static Locale produceLocale() {
        myLocale = Locale.getDefault();
        return Messages.giveLocale("default");
    }

    private static Locale produceLocale(String string) {
        myLocale = new Locale(string);
        return Messages.giveLocale("language " + string);
    }

    private static Locale produceLocale(String string, String string2) {
        myLocale = new Locale(string, string2);
        return Messages.giveLocale("language " + string + ", country " + string2);
    }

    private static Locale produceLocale_enUS() {
        myLocale = new Locale("en", "US");
        return Messages.giveLocale("fallback (en_US)");
    }

    public static Locale getLocale() {
        return myLocale;
    }

    public static Locale setLocale(String string) {
        logging.debug("Messages, setLocale");
        Locale locale = null;
        if (string != null && !string.equals("")) {
            if (string.length() == 5 && string.indexOf(95) == 2) {
                try {
                    locale = Messages.produceLocale(string.substring(0, 2), string.substring(3, 5));
                    logging.info("Locale " + locale.getLanguage() + "_" + locale.getCountry() + " set by param");
                }
                catch (Exception exception) {
                    logging.info("Failed to set locale '" + string + "': " + exception);
                }
            } else if (string.length() == 2) {
                try {
                    locale = Messages.produceLocale(string);
                    logging.info("Locale " + locale + " set by param");
                }
                catch (Exception exception) {
                    logging.info("Failed to set locale '" + string + "': " + exception);
                }
            } else {
                logging.info("Bad format for locale, use <language>_<country> or <language>, each component consisting of two chars, or just a two char <language>");
            }
        }
        if (locale == null) {
            locale = Messages.produceLocale();
        }
        try {
            messages = Messages.getResource();
            messagesEN = Messages.getResourceEN();
        }
        catch (MissingResourceException missingResourceException) {
            logging.info("Missing messages for locale EN");
        }
        return locale;
    }

    public static List<String> getLocaleNames() {
        if (existingLocalesNames == null) {
            Messages.getLocaleRepresentations();
        }
        return existingLocalesNames;
    }

    public static Map<String, String> getLocaleInfo() {
        if (localeInfo == null) {
            Messages.getLocaleRepresentations();
        }
        logging.debug("Messages, getLocaleInfo " + localeInfo);
        return localeInfo;
    }

    private static List<LocaleRepresentation> getLocaleRepresentations() {
        Object object;
        if (existingLocales != null) {
            return existingLocales;
        }
        ArrayList<LocaleRepresentation> arrayList = new ArrayList<LocaleRepresentation>();
        localeInfo = new TreeMap<String, String>();
        InputStream inputStream = Messages.class.getResourceAsStream(LOCALISATIONS_CONF);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            object = bufferedReader.readLine();
            while (object != null) {
                if (((String)(object = ((String)object).trim())).length() > 0 && ((String)object).charAt(0) != '#') {
                    arrayList.add(new LocaleRepresentation((String)object));
                }
                object = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            logging.warning("Messages exception on reading: " + exception);
        }
        object = new TreeSet();
        for (LocaleRepresentation localeRepresentation : arrayList) {
            ((TreeSet)object).add(localeRepresentation.getName());
            localeInfo.put(localeRepresentation.getName(), localeRepresentation.getIconName());
        }
        logging.debug("Messages, existing names " + object);
        existingLocalesNames = new ArrayList<String>((Collection<String>)object);
        logging.debug("Messages, existing locales " + arrayList);
        logging.debug("Messages, localeInfo  " + localeInfo);
        return arrayList;
    }

    static {
        myLocale = null;
    }
}

