/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.type;

import de.uib.configed.Globals;
import de.uib.utilities.logging.logging;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;

public class OpsiPackage
implements Comparable {
    protected String productId;
    protected int productType;
    protected String versionInfo;
    protected String productVersion;
    protected String packageVersion;
    protected String representation;
    public static final String SERVICEkeyPRODUCT_ID = "productId";
    public static final String SERVICEkeyPRODUCT_VERSION = "productVersion";
    public static final String SERVICEkeyPACKAGE_VERSION = "packageVersion";
    public static final String SERVICEkeyPRODUCT_TYPE = "productType";
    public static final String VERSION_INFO = "versionInfo";
    public static final String LOCALBOOT_PRODUCT_SERVER_STRING = "LocalbootProduct";
    public static final String NETBOOT_PRODUCT_SERVER_STRING = "NetbootProduct";
    public static final ArrayList<String> SERVICE_KEYS = new ArrayList();
    public static final Vector<String> COLUMN_NAMES;
    public static final int TYPE_LOCALBOOT = 0;
    public static final int TYPE_NETBOOT = 1;
    public static int lastIndex;

    public OpsiPackage(String string, String string2, String string3, String string4) {
        this.productId = string;
        this.productVersion = string2;
        this.packageVersion = string3;
        this.versionInfo = string2 + Globals.ProductPackageVersionSeparator.forKey() + string3;
        this.productType = string4.equals(LOCALBOOT_PRODUCT_SERVER_STRING) ? 0 : (string4.equals(NETBOOT_PRODUCT_SERVER_STRING) ? 1 : -1);
        logging.debug(this, "created : " + string + ", " + string4 + ", " + this.versionInfo);
        this.representation = this.buildRepresentation();
    }

    public OpsiPackage(Map<String, Object> map) {
        this("" + map.get(SERVICEkeyPRODUCT_ID), "" + map.get(SERVICEkeyPRODUCT_VERSION), "" + map.get(SERVICEkeyPACKAGE_VERSION), "" + map.get(SERVICEkeyPRODUCT_TYPE));
        logging.debug(this, "built from " + map);
    }

    public String getProductId() {
        return this.productId;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public String getPackageVersion() {
        return this.packageVersion;
    }

    public String getVersionInfo() {
        return this.versionInfo;
    }

    public static String produceVersionInfo(String string, String string2) {
        return string + Globals.ProductPackageVersionSeparator.forKey() + string2;
    }

    public int getProductType() {
        return this.productType;
    }

    public Vector<Object> appendValues(Vector<Object> vector) {
        vector.add(OpsiPackage.giveProductType(this.getProductType()));
        vector.add(this.getProductVersion());
        vector.add(this.getPackageVersion());
        return vector;
    }

    public boolean isLocalbootProduct() {
        return this.productType == 0;
    }

    public boolean isNetbootProduct() {
        return this.productType == 1;
    }

    public static String giveProductType(int n) {
        switch (n) {
            case 0: {
                return LOCALBOOT_PRODUCT_SERVER_STRING;
            }
            case 1: {
                return NETBOOT_PRODUCT_SERVER_STRING;
            }
        }
        return "error";
    }

    protected String buildRepresentation() {
        return "{productId:\"" + this.productId + "\";" + SERVICEkeyPRODUCT_TYPE + ":\"" + OpsiPackage.giveProductType(this.productType) + "\";" + VERSION_INFO + ":\"" + this.versionInfo + "\"}";
    }

    public String toString() {
        return this.representation;
    }

    public int compareTo(Object object) {
        return this.representation.compareTo(object.toString());
    }

    public boolean equals(Object object) {
        return this.representation.equals(object.toString());
    }

    static {
        SERVICE_KEYS.add(SERVICEkeyPRODUCT_ID);
        SERVICE_KEYS.add(SERVICEkeyPRODUCT_VERSION);
        SERVICE_KEYS.add(SERVICEkeyPACKAGE_VERSION);
        SERVICE_KEYS.add(SERVICEkeyPRODUCT_TYPE);
        COLUMN_NAMES = new Vector<String>(SERVICE_KEYS);
        lastIndex = -1;
    }
}

