/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.gui;

import de.uib.configed.ConfigedMain;
import de.uib.configed.Globals;
import de.uib.configed.configed;
import de.uib.configed.gui.GeneralFrame;
import de.uib.configed.type.DatedRowList;
import de.uib.configed.type.SWAuditClientEntry;
import de.uib.utilities.logging.logging;
import de.uib.utilities.pdf.DocumentElementToPdf;
import de.uib.utilities.pdf.DocumentToPdf;
import de.uib.utilities.swing.PopupMenuTrait;
import de.uib.utilities.table.gui.ColorHeaderCellRenderer;
import de.uib.utilities.table.gui.StandardTableCellRenderer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableRowSorter;

public class PanelSWInfo
extends JPanel {
    protected JScrollPane jScrollPane;
    protected JTable jTable;
    protected SWInfoTableModel tableModel;
    protected JLabel jLabelTitle;
    protected String title = "";
    protected DatedRowList swRows;
    protected String hostId = "";
    protected boolean withPopup;
    protected PopupMenuTrait popupMenu;
    protected DocumentToPdf tableToPDF;
    protected int hGap = 5;
    protected int vGap = 5;
    protected int hLabel = 24;
    protected ConfigedMain mainController;

    public PanelSWInfo(ConfigedMain configedMain) {
        this(true, configedMain);
    }

    public PanelSWInfo(boolean bl, ConfigedMain configedMain) {
        this.withPopup = bl;
        this.mainController = configedMain;
        this.buildPanel();
    }

    protected void buildPanel() {
        this.jLabelTitle = new JLabel("");
        this.jLabelTitle.setOpaque(true);
        this.jLabelTitle.setBackground(de.uib.utilities.Globals.backgroundLightGrey);
        this.tableModel = new SWInfoTableModel();
        this.jTable = new JTable(this.tableModel, null);
        this.jTable.setAutoCreateRowSorter(true);
        TableRowSorter tableRowSorter = (TableRowSorter)this.jTable.getRowSorter();
        ArrayList<RowSorter.SortKey> arrayList = new ArrayList<RowSorter.SortKey>(1);
        arrayList.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
        tableRowSorter.setSortKeys(arrayList);
        tableRowSorter.sort();
        this.jTable.setDefaultRenderer(Object.class, new StandardTableCellRenderer());
        this.jTable.getColumnModel().getColumn(0).setPreferredWidth(400);
        this.jTable.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.jTable.getColumnModel().getColumn(2).setPreferredWidth(100);
        this.jTable.getTableHeader().setDefaultRenderer(new ColorHeaderCellRenderer(this.jTable.getTableHeader().getDefaultRenderer()));
        this.jTable.setColumnSelectionAllowed(true);
        this.jTable.setRowSelectionAllowed(true);
        this.jTable.setDragEnabled(true);
        this.jScrollPane = new JScrollPane(this.jTable);
        this.jScrollPane.getViewport().setBackground(de.uib.utilities.Globals.backLightBlue);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGap(this.hGap, this.hGap, this.hGap).addGroup(groupLayout.createParallelGroup().addGroup(groupLayout.createSequentialGroup().addGap(this.hGap, this.hGap, this.hGap).addComponent(this.jLabelTitle, -2, -2, Short.MAX_VALUE).addGap(this.hGap, this.hGap, this.hGap)).addComponent(this.jScrollPane, -2, -2, Short.MAX_VALUE)).addGap(this.hGap, this.hGap, this.hGap));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addComponent(this.jLabelTitle, this.hLabel, this.hLabel, this.hLabel).addGap(this.vGap, this.vGap, this.vGap).addComponent(this.jScrollPane, -2, -2, Short.MAX_VALUE).addGap(this.vGap, this.vGap, this.vGap));
        if (this.withPopup) {
            this.popupMenu = new PopupMenuTrait(new Integer[]{4, 10, 6}){

                @Override
                public void action(int n) {
                    switch (n) {
                        case 4: {
                            PanelSWInfo.this.reload();
                            break;
                        }
                        case 6: {
                            PanelSWInfo.this.floatExternal();
                            break;
                        }
                        case 10: {
                            logging.info(this, "------------- create report");
                            HashMap<String, String> hashMap = new HashMap<String, String>();
                            MessageFormat messageFormat = new MessageFormat(configed.getResourceValue("PanelSWInfo.jLabel_title"));
                            hashMap.put("header", " " + messageFormat.format(new String[]{PanelSWInfo.this.hostId, PanelSWInfo.this.swRows.getDate()}));
                            PanelSWInfo.this.title = "";
                            if (PanelSWInfo.this.mainController.getHostsStatusInfo().getInvolvedDepots().length() != 0) {
                                PanelSWInfo.this.title = PanelSWInfo.this.title + "Depot : " + PanelSWInfo.this.mainController.getHostsStatusInfo().getInvolvedDepots();
                            }
                            if (PanelSWInfo.this.mainController.getHostsStatusInfo().getSelectedClientNames().length() != 0) {
                                PanelSWInfo.this.title = PanelSWInfo.this.title + "; Client: " + PanelSWInfo.this.mainController.getHostsStatusInfo().getSelectedClientNames();
                            }
                            hashMap.put("title", PanelSWInfo.this.title);
                            hashMap.put("subject", "report of table");
                            hashMap.put("keywords", "software inventory");
                            PanelSWInfo.this.tableToPDF = new DocumentToPdf(null, hashMap);
                            ArrayList<Integer> arrayList = new ArrayList<Integer>();
                            arrayList.add(0);
                            DocumentElementToPdf.setAlignmentLeft(arrayList);
                            PanelSWInfo.this.tableToPDF.createContentElement("table", PanelSWInfo.this.jTable);
                            PanelSWInfo.this.tableToPDF.setPageSizeA4_Landscape();
                            PanelSWInfo.this.tableToPDF.toPDF();
                        }
                    }
                }
            };
            this.popupMenu.addPopupListenersTo(new JComponent[]{this, this.jTable, this.jScrollPane, this.jScrollPane.getViewport()});
        }
    }

    public void setTitle(String string) {
        this.title = " " + string + " " + this.title;
    }

    protected void reload() {
        logging.debug(this, "reload action");
    }

    protected void floatExternal() {
        PanelSWInfo panelSWInfo = new PanelSWInfo(false, this.mainController);
        panelSWInfo.setSoftwareInfo(this.hostId, this.swRows);
        GeneralFrame generalFrame = new GeneralFrame(null, this.title, false);
        generalFrame.addPanel(panelSWInfo);
        generalFrame.setup();
        generalFrame.setSize(this.getSize());
        generalFrame.centerOn(Globals.mainFrame);
        generalFrame.setVisible(true);
    }

    public void setSoftwareInfo(String string, DatedRowList datedRowList) {
        logging.info(this, "setSoftwareAudit for " + string + " -- ");
        this.title = string;
        this.hostId = string;
        this.swRows = datedRowList;
        this.jLabelTitle.setText(" (no software audit data) ");
        if (datedRowList == null) {
            this.tableModel.setData(new DatedRowList());
            return;
        }
        if (datedRowList.getDate() != null) {
            MessageFormat messageFormat = new MessageFormat(configed.getResourceValue("PanelSWInfo.jLabel_title"));
            this.jLabelTitle.setText(" " + messageFormat.format(new String[]{string, datedRowList.getDate()}));
            this.title = this.title + "   " + configed.getResourceValue("PanelSWInfo.title");
        }
        this.tableModel.setData(datedRowList);
    }

    public class SWInfoTableModel
    extends AbstractTableModel {
        private List<String[]> data;
        private final String[] header = new String[]{configed.getResourceValue("PanelSWInfo.tableheader_displayName"), configed.getResourceValue("PanelSWInfo.tableheader_softwareId"), configed.getResourceValue("PanelSWInfo.tableheader_displayVersion")};

        public SWInfoTableModel() {
            this.data = new ArrayList<String[]>();
        }

        public void setData(DatedRowList datedRowList) {
            this.data = datedRowList.getRows();
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return SWAuditClientEntry.getDisplayKeys().size();
        }

        @Override
        public String getColumnName(int n) {
            return SWAuditClientEntry.getDisplayKey(n + 1);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.data.get(n)[n2 + 1];
        }
    }
}

