/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.groupaction;

import de.uib.configed.ConfigedMain;
import de.uib.configed.Globals;
import de.uib.configed.configed;
import de.uib.configed.gui.IconButton;
import de.uib.opsidatamodel.PersistenceController;
import de.uib.utilities.WaitCursor;
import de.uib.utilities.logging.logging;
import de.uib.utilities.swing.Containership;
import de.uib.utilities.swing.SecondaryFrame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class FGroupActions
extends SecondaryFrame {
    JPanel topPanel;
    JPanel imageActionPanel;
    JTextField fieldGroupname;
    JTextField fieldInvolvedClientsCount;
    JComboBox comboSelectImage;
    List<String> associatedClients;
    PersistenceController persist;
    ConfigedMain main;
    int hFirstGap = Globals.hFirstGap;
    int firstLabelWidth = 140;

    public FGroupActions(ConfigedMain configedMain, PersistenceController persistenceController, JFrame jFrame) {
        this.main = configedMain;
        this.persist = persistenceController;
        this.define();
        this.reload();
        this.setGlobals(Globals.getMap());
        this.setTitle("opsi config editor " + configed.getResourceValue("FGroupAction.title"));
    }

    protected void setGroupLabelling(String string, String string2) {
        this.fieldGroupname.setText(string);
        this.fieldInvolvedClientsCount.setText(string2);
    }

    @Override
    public void start() {
        super.start();
        this.reload();
    }

    protected void setImages() {
        Vector<String> vector = new Vector<String>();
        vector.addAll(new TreeSet<String>(this.persist.getCommonProductPropertyValues(this.associatedClients, "opsi-local-image-restore", "imagefiles_list")));
        this.comboSelectImage.setModel(new DefaultComboBoxModel(vector));
    }

    private void reload() {
        this.setGroupLabelling(this.main.getActivatedGroupModel().getLabel(), "" + this.main.getActivatedGroupModel().getNumberOfClients());
        this.associatedClients = new ArrayList<String>(this.main.getActivatedGroupModel().getAssociatedClients());
        this.setImages();
    }

    protected void replay() {
        logging.debug(this, "replay " + this.comboSelectImage.getSelectedItem());
        if (this.comboSelectImage.getSelectedItem() == null) {
            return;
        }
        String string = (String)this.comboSelectImage.getSelectedItem();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        WaitCursor waitCursor = new WaitCursor(this);
        this.persist.setCommonProductPropertyValue(this.main.getActivatedGroupModel().getAssociatedClients(), "opsi-local-image-restore", "imagefile", arrayList);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("actionRequest", "setup");
        this.persist.updateProductOnClients(this.main.getActivatedGroupModel().getAssociatedClients(), "opsi-local-image-restore", 1, hashMap);
        waitCursor.stop();
    }

    protected void define() {
        this.topPanel = new JPanel();
        this.defineTopPanel(this.topPanel);
        this.imageActionPanel = new JPanel();
        this.imageActionPanel.setBorder(Globals.createPanelBorder());
        this.defineImageActionPanel(this.imageActionPanel);
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addComponent(this.topPanel, 30, -2, -2).addGap(10, 10, 10).addComponent(this.imageActionPanel, 100, -2, -2).addGap(10, 10, 10));
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup().addComponent(this.topPanel, 100, -2, Short.MAX_VALUE).addComponent(this.imageActionPanel, 100, -2, Short.MAX_VALUE));
        Containership containership = new Containership(this.getContentPane());
        containership.doForAllContainedCompisOfClass("setBackground", new Object[]{Globals.backLightBlue}, JPanel.class);
        containership.doForAllContainedCompisOfClass("setBackground", new Object[]{Globals.backgroundLightGrey}, JTextComponent.class);
    }

    private void defineImageActionPanel(JPanel jPanel) {
        JLabel jLabel = new JLabel(configed.getResourceValue("FGroupAction.existingImages"));
        this.comboSelectImage = new JComboBox();
        JLabel jLabel2 = new JLabel(configed.getResourceValue("FGroupAction.replayImage"));
        JButton jButton = new JButton(configed.getResourceValue("FGroupAction.buttonSetup"));
        jButton.setToolTipText(configed.getResourceValue("FGroupAction.buttonSetup.tooltip"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FGroupActions.this.replay();
            }
        });
        IconButton iconButton = new IconButton(configed.getResourceValue("FGroupAction.buttonReload"), "images/reload16.png", "images/reload16_over.png", "images/reload16_disabled.png", true);
        iconButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FGroupActions.this.reload();
            }
        });
        GroupLayout groupLayout = new GroupLayout(jPanel);
        jPanel.setLayout(groupLayout);
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGap(10, 30, 40).addComponent(jLabel2, -2, -2, -2).addGap(10, 10, 20).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel, -2, -2, -2).addComponent(this.comboSelectImage, -2, -2, -2).addComponent(jButton, 28, 28, 28).addComponent(iconButton, 28, 28, 28)).addGap(10, 30, 40));
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup().addGroup(groupLayout.createSequentialGroup().addGap(10, 20, Short.MAX_VALUE).addComponent(jLabel2, -2, -2, -2).addGap(10, 20, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(10, Globals.hFirstGap, Globals.hFirstGap).addComponent(jLabel, this.firstLabelWidth, this.firstLabelWidth, this.firstLabelWidth).addGap(10, 10, 10).addComponent(this.comboSelectImage, -2, 280, Short.MAX_VALUE).addGap(20, 40, 40).addComponent(jButton, 140, 140, 140).addGap(20, 20, 20).addComponent(iconButton, 60, 60, 60).addGap(10, Globals.hFirstGap, Short.MAX_VALUE)));
    }

    private void defineTopPanel(JPanel jPanel) {
        JLabel jLabel = new JLabel(configed.getResourceValue("FGroupAction.groupname"));
        JLabel jLabel2 = new JLabel(configed.getResourceValue("FGroupAction.clientcounter"));
        this.fieldGroupname = new JTextField();
        this.fieldGroupname.setPreferredSize(Globals.counterfieldDimension);
        this.fieldGroupname.setEditable(false);
        this.fieldInvolvedClientsCount = new JTextField("");
        this.fieldInvolvedClientsCount.setPreferredSize(Globals.counterfieldDimension);
        this.fieldInvolvedClientsCount.setEditable(false);
        GroupLayout groupLayout = new GroupLayout(jPanel);
        jPanel.setLayout(groupLayout);
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGap(10, 10, 20).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel, 28, 28, 28).addComponent(this.fieldGroupname, 28, 28, 28).addComponent(jLabel2, 28, 28, 28).addComponent(this.fieldInvolvedClientsCount, 28, 28, 28)).addGap(10, 10, 20));
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGap(10, Globals.hFirstGap, Globals.hFirstGap).addComponent(jLabel, this.firstLabelWidth, this.firstLabelWidth, this.firstLabelWidth).addGap(10, 10, 10).addComponent(this.fieldGroupname, 140, 140, Short.MAX_VALUE).addGap(10, 20, 20).addComponent(jLabel2, 0, -2, -2).addGap(10, 10, 20).addComponent(this.fieldInvolvedClientsCount, -2, -2, -2).addGap(10, 10, 20));
    }
}

