/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities.table.gui;

import de.uib.configed.Globals;
import de.uib.utilities.logging.logging;
import de.uib.utilities.swing.FEditList;
import de.uib.utilities.table.DefaultListModelProducer;
import de.uib.utilities.table.ListModelProducer;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import org.json.JSONObject;

public class SensitiveCellEditor
extends AbstractCellEditor
implements TableCellEditor,
MouseListener {
    protected JTextField field = new JTextField();
    protected Object value;
    protected FEditList listeditor;
    private int editingRow = -1;
    private int editingColumn = -1;
    protected ListModelProducer modelProducer;
    protected List<Object> forbiddenValues;
    private boolean usingListEditor;
    private static final Map<Object, SensitiveCellEditor> instances = new HashMap<Object, SensitiveCellEditor>();

    public SensitiveCellEditor() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SensitiveCellEditor getInstance(Object object) {
        Map<Object, SensitiveCellEditor> map = instances;
        synchronized (map) {
            SensitiveCellEditor sensitiveCellEditor = instances.get(object);
            if (sensitiveCellEditor == null) {
                sensitiveCellEditor = new SensitiveCellEditor();
                instances.put(object, sensitiveCellEditor);
            }
            return sensitiveCellEditor;
        }
    }

    private SensitiveCellEditor(ListModelProducer listModelProducer) {
        this.field.setEditable(false);
        this.field.addMouseListener(this);
        this.listeditor = new FEditList(this.field, this);
        this.listeditor.setModal(false);
        this.listeditor.init();
        this.setModelProducer(listModelProducer);
    }

    public void re_init() {
        this.listeditor.init();
    }

    public void setForbiddenValues(List<Object> list) {
        this.forbiddenValues = list;
    }

    public void setModelProducer(ListModelProducer listModelProducer) {
        this.modelProducer = listModelProducer;
        if (listModelProducer == null) {
            this.modelProducer = new DefaultListModelProducer();
        }
    }

    private void startListEditor(JTable jTable, int n, int n2) {
        this.field.setEditable(false);
        this.listeditor.init();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SensitiveCellEditor.this.listeditor.setVisible(true);
                SensitiveCellEditor.this.listeditor.centerOn(Globals.mainContainer);
            }
        });
        this.usingListEditor = true;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        logging.info(this, "  celleditor working in " + n + ", " + n2 + " with value " + object + ", class " + object.getClass().getName());
        this.value = this.modelProducer.toList(object);
        if (this.value instanceof List) {
            logging.info(this, " try list editing, with modelProducer " + this.modelProducer);
            DefaultListModel defaultListModel = this.modelProducer.getListModel(n, n2);
            this.listeditor.setVisible(false);
            this.listeditor.setTitle(this.modelProducer.getCaption(n, n2));
            logging.info(this, " model got " + defaultListModel);
            if (defaultListModel != null) {
                logging.info(this, "start with model");
                this.listeditor.setListModel(this.modelProducer.getListModel(n, n2));
                logging.info(this, "startValue set: " + object);
                this.listeditor.setSelectionMode(this.modelProducer.getSelectionMode(n, n2));
                this.listeditor.setEditable(this.modelProducer.getEditable(n, n2));
                this.listeditor.setSelectedValues(this.modelProducer.getSelectedValues(n, n2));
                this.listeditor.enter();
                this.startListEditor(jTable, n, n2);
                this.editingRow = n;
                this.editingColumn = n2;
            } else {
                defaultListModel = new DefaultListModel();
                this.listeditor.setListModel(defaultListModel);
                this.startListEditor(jTable, n, n2);
                this.listeditor.setSelectionMode(2);
                this.listeditor.setEditable(true);
                this.listeditor.setSelectedValues(new ArrayList<Object>());
                this.listeditor.enter();
                this.listeditor.setStartValue("");
                this.editingRow = -1;
                this.editingColumn = -1;
            }
        }
        this.field.setText("" + object);
        return this.field;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.listeditor.getValue() == null) {
            return null;
        }
        if (this.listeditor.getValue() instanceof List) {
            Object object2;
            List list = (List)this.listeditor.getValue();
            if (this.forbiddenValues != null) {
                for (Object object2 : this.forbiddenValues) {
                    list.remove(object2);
                }
            }
            int n = list.size();
            logging.info(this, "getCellEditorValue,  modelProducer.getClass(editingRow, editingColumn) " + this.modelProducer.getClass(this.editingRow, this.editingColumn));
            if (List.class.isAssignableFrom(this.modelProducer.getClass(this.editingRow, this.editingColumn))) {
                return list;
            }
            if (Integer.class.isAssignableFrom(this.modelProducer.getClass(this.editingRow, this.editingColumn))) {
                if (n == 0) {
                    return null;
                }
                return list.get(0);
            }
            if (Boolean.class.isAssignableFrom(this.modelProducer.getClass(this.editingRow, this.editingColumn))) {
                if (n == 0) {
                    return null;
                }
                return list.get(0);
            }
            if (n == 0) {
                return "";
            }
            object2 = new StringBuffer("");
            if (n == 0) {
                return "";
            }
            for (int i = 0; i < n - 1; ++i) {
                ((StringBuffer)object2).append("" + list.get(i) + ",");
            }
            ((StringBuffer)object2).append("" + list.get(n - 1));
            String string = ((StringBuffer)object2).toString();
            if (string.equalsIgnoreCase("null")) {
                return JSONObject.NULL;
            }
            return string;
        }
        return this.listeditor.getValue();
    }

    public void finish() {
        if (this.listeditor != null) {
            this.listeditor.deactivate();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.field && this.usingListEditor && mouseEvent.getClickCount() > 1) {
            this.listeditor.setVisible(true);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

