/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed;

import de.uib.configed.configed;
import de.uib.utilities.WaitCursor;
import de.uib.utilities.logging.UncaughtExceptionHandler;
import de.uib.utilities.logging.logging;

public class UncaughtExceptionHandlerLocalized
extends UncaughtExceptionHandler {
    private static String lastException = "";

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        WaitCursor.stopAll();
        if (configed.fProgress != null) {
            try {
                configed.fProgress.stop();
                configed.fProgress = null;
            }
            catch (Exception exception) {
                logging.debug(this, "Exception " + exception);
            }
        }
        Integer n = logging.getInjectedLogLevel();
        System.out.println(" " + this + " saveInjectedLogLevel " + n);
        if (n != null) {
            logging.injectLogLevel(3);
        }
        System.out.println(" " + this + " injectedLogLevel " + logging.getInjectedLogLevel());
        if (throwable instanceof Exception) {
            logging.warning("Error in thread " + thread);
            logging.logTrace((Exception)throwable);
            String string = configed.getResourceValue("UncaughtExceptionHandler.notForeseenError") + " " + ((Exception)throwable).getMessage();
            if (throwable.getMessage().endsWith("cannot be cast to javax.swing.Painter")) {
                logging.warning(string);
            } else {
                logging.error(string + "\n" + configed.getResourceValue("UncaughtExceptionHandler.pleaseCheckLogfile"), (Exception)throwable);
            }
        } else {
            logging.logTrace(throwable);
            logging.warning("Thread " + thread + " - RunTime Error -  " + throwable);
            if (throwable instanceof OutOfMemoryError && !lastException.equals(throwable.toString())) {
                lastException = throwable.toString();
                logging.error(configed.getResourceValue("UncaughtExceptionHandler.OutOfMemoryError"));
            }
        }
        if (n != null) {
            logging.injectLogLevel(n);
        }
    }
}

