/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities.pdf;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import de.uib.configed.configed;
import de.uib.utilities.Globals;
import de.uib.utilities.logging.logging;
import de.uib.utilities.pdf.DocumentElementToPdf;
import de.uib.utilities.pdf.OpenSaveDialog;
import java.awt.Desktop;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileNameExtensionFilter;

public class DocumentToPdf {
    private static float mLeft = 36.0f;
    private static float mRight = 36.0f;
    private static float mTop = 74.0f;
    private static float mBottom = 54.0f;
    private float xHeaderTop = 803.0f;
    private float headerWidth = 527.0f;
    protected static Document document;
    protected static PdfWriter writer;
    protected static JTable theTable;
    protected Vector<String> classNames;
    protected JFileChooser chooser;
    protected static File exportDirectory;
    protected OpenSaveDialog dialog;
    protected Vector<Integer> excludeCols;
    protected Vector<HashMap<String, Object>> theListOfContentElements;
    protected HashMap<String, String> metaData = new HashMap();

    public DocumentToPdf(String string, HashMap<String, String> hashMap) {
        document = new Document(PageSize.A4, mLeft, mRight, mTop, mBottom);
        this.metaData = hashMap;
        this.theListOfContentElements = new Vector();
        DocumentElementToPdf.setAlignmentLeft(new ArrayList<Integer>());
    }

    public void createContentElement(String string, Object object) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(string, object);
        this.theListOfContentElements.add(hashMap);
    }

    public void addEmptyLine() {
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        String[] stringArray = new String[]{" "};
        hashMap.put("paragraph", stringArray);
        this.theListOfContentElements.add(hashMap);
    }

    public void setJTable(JTable jTable) {
        theTable = jTable;
    }

    public void setExcludeCols(Vector<Integer> vector) {
        this.excludeCols = vector;
    }

    public void setPageSizeA4() {
        document.setPageSize(PageSize.A4);
        this.headerWidth = 527.0f;
        this.xHeaderTop = 803.0f;
    }

    public void setPageSizeA4_Landscape() {
        document.setPageSize(PageSize.A4.rotate());
        this.headerWidth = 770.0f;
        this.xHeaderTop = 555.0f;
    }

    public static void addMetaData(HashMap<String, String> hashMap) {
        if (hashMap == null) {
            document.addTitle("Document as PDF");
            document.addSubject("Using iText");
            document.addKeywords("Java, PDF, iText");
        } else {
            if (hashMap.containsKey("title")) {
                document.addTitle(hashMap.get("title").toString());
            }
            if (hashMap.containsKey("subject")) {
                document.addSubject(hashMap.get("subject").toString());
            }
            if (hashMap.containsKey("keywords")) {
                document.addKeywords(hashMap.get("keywords").toString());
            }
        }
        document.addAuthor(System.getProperty("user.name"));
        document.addCreator("opsi config editor");
    }

    public void toPDF() {
        File file = null;
        String string = null;
        HashMap hashMap = new HashMap();
        if (this.dialog == null) {
            this.dialog = new OpenSaveDialog(configed.getResourceValue("OpenSaveDialog.title"));
        } else {
            this.dialog.setVisible();
        }
        Boolean bl = this.dialog.getSaveAction();
        if (bl != null) {
            if (bl.booleanValue()) {
                string = this.getFileLocation();
            } else {
                try {
                    file = File.createTempFile("report", ".pdf");
                    string = file.getAbsolutePath();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            try {
                Object object;
                writer = string == null ? PdfWriter.getInstance(document, new FileOutputStream("report.pdf")) : PdfWriter.getInstance(document, new FileOutputStream(string));
                try {
                    object = new TableHeader();
                    if (this.metaData.containsKey("header")) {
                        ((TableHeader)object).setHeader(this.metaData.get("header"));
                    } else if (this.metaData.containsKey("title")) {
                        ((TableHeader)object).setHeader(this.metaData.get("title"));
                    }
                    writer.setPageEvent((PdfPageEvent)object);
                }
                catch (Exception exception) {
                    logging.error("Error PdfWriter --- " + exception);
                }
                document.open();
                DocumentToPdf.addMetaData(this.metaData);
                document.add(DocumentElementToPdf.addTitleLines(this.metaData));
                object = this.theListOfContentElements.iterator();
                int n = 1;
                while (object.hasNext()) {
                    hashMap = (HashMap)object.next();
                    if (hashMap.containsKey("table")) {
                        document.add(DocumentElementToPdf.createElement((JTable)hashMap.get("table")));
                    } else if (hashMap.containsKey("paragraph")) {
                        document.add(DocumentElementToPdf.createElement((String[])hashMap.get("paragraph")));
                    }
                    if (!hashMap.containsKey("chapter")) continue;
                    document.add(DocumentElementToPdf.createElement((String)hashMap.get("chapter"), n));
                    ++n;
                }
                document.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                logging.error("file not found: " + string + " --- " + fileNotFoundException);
            }
            catch (Exception exception) {
                logging.error("file not found: " + string + " --- " + exception);
            }
            if (!bl.booleanValue() && file.getAbsolutePath() != null) {
                try {
                    Desktop.getDesktop().open(new File(file.getAbsolutePath()));
                }
                catch (IOException iOException) {
                    logging.error("file name not valid: " + file.getAbsolutePath() + " : " + iOException);
                }
            }
        }
    }

    private String getFileLocation() {
        String string = null;
        File file = new File("report.pdf");
        this.chooser = new JFileChooser(exportDirectory);
        this.chooser.setFileSelectionMode(0);
        this.chooser.setFileFilter(new FileNameExtensionFilter("PDF", "pdf"));
        this.chooser.setApproveButtonText("O.K.");
        this.chooser.setSelectedFile(file);
        this.chooser.setDialogType(1);
        this.chooser.setDialogTitle("opsi config editor " + configed.getResourceValue("DocumentToPdf.chooser"));
        int n = this.chooser.showOpenDialog(Globals.masterFrame);
        if (n == 0) {
            try {
                int n2;
                string = this.chooser.getSelectedFile().getAbsolutePath();
                if (!string.toLowerCase().endsWith(".pdf")) {
                    string = string + ".pdf";
                }
                logging.debug(this, "fileName " + string);
                File file2 = new File(string);
                if (file2.exists() && (n2 = JOptionPane.showConfirmDialog(Globals.masterFrame, configed.getResourceValue("DocumentToPdf.showConfirmDialog"), "opsi config editor Nachfrage", 2)) == 2) {
                    string = null;
                }
            }
            catch (Exception exception) {
                logging.error("file name not valid: " + string);
            }
        }
        if (string != null) {
            try {
                exportDirectory = new File(string).getParentFile();
            }
            catch (Exception exception) {
                logging.error("directory not found for " + string + " : " + exception);
            }
        }
        return string;
    }

    class TableHeader
    extends PdfPageEventHelper {
        String header = "";
        PdfTemplate total;

        TableHeader() {
        }

        public void setHeader(String string) {
            this.header = string;
        }

        @Override
        public void onOpenDocument(PdfWriter pdfWriter, Document document) {
            this.total = pdfWriter.getDirectContent().createTemplate(30.0f, 16.0f);
        }

        @Override
        public void onEndPage(PdfWriter pdfWriter, Document document) {
            PdfPTable pdfPTable = new PdfPTable(3);
            URL uRL = de.uib.configed.Globals.getImageResourceURL("images/opsi_full.png");
            try {
                pdfPTable.setWidths(new int[]{24, 24, 2});
                pdfPTable.setTotalWidth(DocumentToPdf.this.headerWidth);
                pdfPTable.setLockedWidth(true);
                pdfPTable.getDefaultCell().setFixedHeight(20.0f);
                pdfPTable.getDefaultCell().setBorder(2);
                pdfPTable.addCell(this.header);
                pdfPTable.getDefaultCell().setHorizontalAlignment(2);
                pdfPTable.addCell(String.format(" %d / ", pdfWriter.getPageNumber()));
                PdfPCell pdfPCell = new PdfPCell(Image.getInstance(this.total));
                pdfPCell.setBorder(2);
                pdfPTable.addCell(pdfPCell);
                pdfPTable.writeSelectedRows(0, -1, 34.0f, DocumentToPdf.this.xHeaderTop, pdfWriter.getDirectContent());
                document.add(DocumentElementToPdf.createElement(uRL, 25.0f, 25.0f));
            }
            catch (DocumentException documentException) {
                throw new ExceptionConverter(documentException);
            }
            catch (MalformedURLException malformedURLException) {
                logging.error("malformed URL --- " + malformedURLException);
            }
            catch (IOException iOException) {
                logging.error("Error document add footer image --- " + iOException);
            }
        }

        @Override
        public void onCloseDocument(PdfWriter pdfWriter, Document document) {
            ColumnText.showTextAligned(this.total, 0, new Phrase(String.valueOf(pdfWriter.getPageNumber() - 1)), 2.0f, 2.0f, 0.0f);
        }
    }
}

