/*
 * Decompiled with CFR 0.152.
 */
package de.uib.utilities.logging;

import de.uib.configed.Globals;
import de.uib.configed.gui.FShowList;
import de.uib.utilities.WaitCursor;
import de.uib.utilities.logging.LogEvent;
import de.uib.utilities.logging.LogEventObserver;
import de.uib.utilities.logging.LogEventSubject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JFrame;

public class logging
implements LogEventSubject {
    public static String wantedDirectory = null;
    public static String programSubDir = "";
    private static String logfileDelimiter = "configed";
    private static String extension = ".log";
    public static final int LEVEL_INFO = 3;
    public static final int LEVEL_CHECK = 4;
    public static final int LEVEL_DEBUG = 5;
    public static final int LEVEL_DONT_SHOW_IT = 6;
    public static final int LEVEL_FATAL = 0;
    public static final int LEVEL_ERROR = 1;
    public static final int LEVEL_WARNING = 2;
    public static final int LEVEL_SHOW_ALWAYS = 1;
    private static final SimpleDateFormat loggingDateFormat = new SimpleDateFormat("MMM dd  HH:mm:ss.SSS  yyyy");
    public static int AKT_DEBUG_LEVEL = 3;
    private static int AKT_LEVEL_FOR_SHOWING_MESSAGES = 1;
    private static int numberOfKeptLogFiles = 3;
    private static PrintWriter writer;
    private static boolean initialized;
    public static boolean noFileAccess;
    private static final int maxListedErrors = 20;
    private static Vector errorList;
    public static FShowList fErrors;
    private static Integer induceLevel;
    protected static Vector<LogEventObserver> logEventObservers;
    private static boolean suppressConsole;

    public static final String levelText(int n) {
        String string = "UNKNOWN_LEVEL  ";
        switch (n) {
            case 6: {
                string = "(HIDDEN)  ";
                break;
            }
            case 5: {
                string = "(DEBUG)   ";
                break;
            }
            case 4: {
                string = "(CHECK)   ";
                break;
            }
            case 3: {
                string = "(INFO)    ";
                break;
            }
            case 2: {
                string = "(WARNING) ";
                break;
            }
            case 1: {
                string = "(ERROR)   ";
                break;
            }
            case 0: {
                string = "(FATAL)   ";
            }
        }
        return string;
    }

    public static void setSuppressConsole(boolean bl) {
        suppressConsole = bl;
    }

    private static void writeToConsole(String string) {
        if (!suppressConsole) {
            System.out.println(string);
        }
    }

    public static void setAktDebugLevel(int n) {
        if (n >= 0) {
            logging.writeToConsole("debug level was " + AKT_DEBUG_LEVEL);
        }
        AKT_DEBUG_LEVEL = n;
        if (n >= 0) {
            logging.writeToConsole("debug level set to " + n);
        }
    }

    public static final synchronized void init() {
        logging.writeToConsole("logging init");
        errorList = new Vector(20);
        logEventObservers = new Vector();
        try {
            File file = System.getenv("LOCALAPPDATA") != null ? new File(System.getenv("LOCALAPPDATA") + File.separator + programSubDir) : new File(System.getProperty("user.home") + File.separator + programSubDir);
            logging.writeToConsole("logging init logDirectory " + file);
            boolean bl = false;
            String string = "";
            File file2 = file;
            logging.writeToConsole("logging directory is " + file2.toString());
            if (wantedDirectory != null && !wantedDirectory.equals("")) {
                file2 = new File(wantedDirectory);
                try {
                    if (!file2.isDirectory()) {
                        string = "\"" + wantedDirectory + "\" is no existing directory";
                        bl = true;
                    } else if (!file2.canRead() || !file2.canWrite()) {
                        string = "We have not the necessary privileges for writing in \"" + wantedDirectory + "\" ";
                        bl = true;
                    }
                }
                catch (SecurityException securityException) {
                    string = "directory is not readable";
                    bl = true;
                }
                if (bl) {
                    System.out.println(logging.now() + ": " + string);
                }
            }
            if (bl) {
                file2 = file;
            }
            if (AKT_DEBUG_LEVEL >= 0) {
                System.out.println("logging directory is " + file2.toString());
                System.out.println("log level is " + AKT_DEBUG_LEVEL);
            }
            String string2 = file2.toString();
            new File(string2).mkdirs();
            String string3 = string2 + File.separator + logfileDelimiter + extension;
            string3 = new File(string3).getAbsolutePath();
            File file3 = new File(string3);
            if (numberOfKeptLogFiles > 0) {
                int n;
                String[] stringArray = new String[numberOfKeptLogFiles];
                File[] fileArray = new File[numberOfKeptLogFiles];
                for (n = 0; n < numberOfKeptLogFiles; ++n) {
                    stringArray[n] = string2 + File.separator + logfileDelimiter + "_" + n + extension;
                    fileArray[n] = new File(stringArray[n]);
                }
                for (n = numberOfKeptLogFiles - 1; n > 0; --n) {
                    if (!fileArray[n - 1].exists()) continue;
                    fileArray[n - 1].renameTo(fileArray[n]);
                }
                if (file3.exists()) {
                    file3.renameTo(fileArray[0]);
                }
                if (AKT_DEBUG_LEVEL >= 0) {
                    System.out.println("logging: use " + string3);
                }
            }
            writer = new PrintWriter(new FileOutputStream(string3));
            initialized = true;
        }
        catch (Exception exception) {
            System.out.println("file system logging could not be initialized " + exception.toString());
            noFileAccess = true;
        }
    }

    private static boolean debug(int n) {
        return n <= AKT_DEBUG_LEVEL;
    }

    private static boolean showOnGUI(int n) {
        return n <= AKT_LEVEL_FOR_SHOWING_MESSAGES;
    }

    private static String now() {
        return loggingDateFormat.format(new Date());
    }

    private static String makeDebugTextForTime(int n, String string, String string2, String string3) {
        return "[" + n + "] " + logging.levelText(n) + " [" + string3 + "]   " + " [" + Thread.currentThread() + "]      " + string + "   " + string2;
    }

    private static void addErrorToList(String string, String string2) {
        while (errorList.size() >= 20) {
            errorList.removeElementAt(0);
        }
        errorList.add(string2 + " -- " + string);
        for (int i = 0; i < logEventObservers.size(); ++i) {
            logEventObservers.get(i).logEventOccurred(new LogEvent(null, "", -1, true));
        }
    }

    private static boolean checkInit(String string) {
        if (!initialized && !noFileAccess) {
            if (wantedDirectory == null) {
                System.out.println("logging directory not yet set");
                System.out.println(string);
                return false;
            }
            logging.init();
        }
        return true;
    }

    private static int modifyLevel(int n) {
        if (n <= 1) {
            return n;
        }
        if (induceLevel != null) {
            return induceLevel;
        }
        return n;
    }

    public static synchronized void injectLogLevel(Object object, Integer n) {
        String string = "";
        if (object != null) {
            string = object.getClass().getName() + " ";
        }
        if (AKT_DEBUG_LEVEL >= 0) {
            System.out.println(string + "induce loglevel " + n);
            induceLevel = n;
        } else {
            logging.writeToConsole(string + "loglevel already < 0");
        }
    }

    public static synchronized void injectLogLevel(Integer n) {
        logging.injectLogLevel(null, n);
    }

    public static synchronized Integer getInjectedLogLevel() {
        return induceLevel;
    }

    public static String getIntegers(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("{");
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append("\"");
            stringBuffer.append("" + nArray[i]);
            stringBuffer.append("\"");
            if (i >= nArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static String getStrings(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        Object[] objectArray = new Integer[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            objectArray[i] = nArray[i];
        }
        return logging.getStrings(objectArray);
    }

    public static String getStrings(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("{");
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append("\"");
            stringBuffer.append("" + objectArray[i]);
            stringBuffer.append("\"");
            if (i >= objectArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static String getStack(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("STACK:\n");
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append("     " + objectArray[i]);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static synchronized void debugOut(int n, String string, Throwable throwable) {
        if (!logging.checkInit(string)) {
            return;
        }
        int n2 = logging.modifyLevel(n);
        String string2 = logging.now();
        if (logging.debug(n2) && n2 < 6) {
            String string3 = logging.supplyXInfo(logging.makeDebugTextForTime(logging.modifyLevel(n), "", string, string2));
            if (AKT_DEBUG_LEVEL >= 3 || noFileAccess) {
                System.out.println(string3);
                throwable.printStackTrace();
            }
            if (!noFileAccess) {
                writer.println(string3);
                throwable.printStackTrace(writer);
                writer.flush();
            }
        }
        if (logging.showOnGUI(n2)) {
            logging.addErrorToList(string, string2);
        }
    }

    public static synchronized void debugOut(int n, String string) {
        logging.debugOut(n, string, true);
    }

    public static synchronized void debugOut(int n, String string, boolean bl) {
        if (!logging.checkInit(string)) {
            return;
        }
        String string2 = logging.now();
        int n2 = n;
        if (bl) {
            n2 = logging.modifyLevel(n);
        }
        if (logging.debug(n2) && n2 < 6) {
            String string3 = logging.supplyXInfo(logging.makeDebugTextForTime(logging.modifyLevel(n), "", string, string2));
            if (AKT_DEBUG_LEVEL >= 3 || noFileAccess) {
                System.out.println(string3);
            }
            if (!noFileAccess) {
                writer.println(string3);
                writer.flush();
            }
        }
        if (logging.showOnGUI(n2)) {
            logging.addErrorToList(string, string2);
        }
    }

    public static synchronized void debugOut(String string, int n, String string2) {
        if (!logging.checkInit(string2)) {
            return;
        }
        int n2 = logging.modifyLevel(n);
        String string3 = logging.now();
        if (logging.debug(n2) && n2 < 6) {
            String string4 = logging.supplyXInfo(logging.makeDebugTextForTime(n2, string, string2, string3));
            if (AKT_DEBUG_LEVEL >= 3 || noFileAccess) {
                System.out.println(string4);
            }
            if (!noFileAccess) {
                writer.println(string4);
                writer.flush();
            }
        }
        if (logging.showOnGUI(n2)) {
            logging.addErrorToList(string2, string3);
        }
    }

    private static String supplyXInfo(String string) {
        return string;
    }

    public static synchronized void debugOut(Object object, int n, String string) {
        if (!logging.checkInit(string)) {
            return;
        }
        int n2 = logging.modifyLevel(n);
        String string2 = logging.now();
        if (logging.showOnGUI(n2)) {
            logging.addErrorToList(string, string2);
        }
        if (logging.debug(n2) && n2 < 6) {
            String string3 = logging.supplyXInfo(logging.makeDebugTextForTime(n2, object.getClass().getName(), string, string2));
            if (AKT_DEBUG_LEVEL >= 3 || noFileAccess) {
                System.out.println(string3);
            }
            if (!noFileAccess) {
                writer.println(string3);
                writer.flush();
            }
        }
    }

    public static void hidden(Object object, String string) {
        logging.debugOut(object, 6, string);
    }

    public static void debug(Object object, String string) {
        logging.debugOut(object, 5, string);
    }

    public static void check(Object object, String string) {
        logging.debugOut(object, 4, string);
    }

    public static void info(Object object, String string) {
        logging.debugOut(object, 3, string);
    }

    public static void warning(Object object, String string) {
        logging.debugOut(object, 2, string);
    }

    public static void error(Object object, String string, Exception exception) {
        logging.logTrace(exception);
        logging.error(object, string);
    }

    public static void error(Object object, String string) {
        logging.debugOut(object, 1, string);
    }

    public static void fatal(Object object, String string) {
        logging.debugOut(object, 0, string);
    }

    public static void hidden(String string) {
        logging.debugOut(6, string);
    }

    public static void debug(String string) {
        logging.debugOut(5, string);
    }

    public static void check(String string) {
        logging.debugOut(4, string);
    }

    public static void info(String string) {
        logging.debugOut(3, string);
    }

    public static void warning(String string) {
        logging.debugOut(2, string);
    }

    public static void error(String string, Exception exception) {
        logging.logTrace(exception);
        logging.error(string);
    }

    public static void error(String string) {
        logging.debugOut(1, string);
    }

    public static void fatal(String string) {
        logging.debugOut(0, string);
    }

    public static void clearErrorList() {
        errorList.clear();
    }

    private static List getErrorList() {
        return errorList;
    }

    private static void checkErrorList() {
        logging.checkErrorList(null);
    }

    public static void checkErrorList(JFrame jFrame) {
        JFrame jFrame2 = jFrame == null ? Globals.mainFrame : jFrame;
        int n = logging.getErrorList().size();
        if (n == 0) {
            return;
        }
        if (fErrors == null) {
            WaitCursor.stopAll();
            fErrors = new FShowList(jFrame2, "opsi config editor: problems Occurred", false, (Object[])new String[]{"o.k."});
        }
        fErrors.setMessage(logging.getErrorListAsLines());
        fErrors.setAlwaysOnTop(true);
        fErrors.setVisible(true);
    }

    public static String getErrorListAsLines() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (errorList.size() > 0) {
            Object[] objectArray = errorList.toArray();
            for (int i = 0; i < errorList.size(); ++i) {
                stringBuffer.append("\n");
                stringBuffer.append(objectArray[i].toString());
            }
        }
        return stringBuffer.toString();
    }

    public static void logTrace(Throwable throwable) {
        String string = "Exception " + throwable + " \n" + logging.getStack(throwable.getStackTrace());
        logging.debugOut(3, string, false);
    }

    public static void debugMap(Object object, Map map) {
        if (map == null) {
            logging.debug(object, " is null");
            return;
        }
        for (Object k : map.keySet()) {
            Object v = map.get(k);
            logging.debug(object, " key: " + k + ", class " + k.getClass().getName() + ", value " + v + ", class " + v.getClass().getName());
        }
    }

    public static void registLogEventObserver(LogEventObserver logEventObserver) {
        logEventObservers.add(logEventObserver);
    }

    @Override
    public void registerLogEventObserver(LogEventObserver logEventObserver) {
    }

    static {
        initialized = false;
        noFileAccess = false;
        suppressConsole = false;
    }
}

