/*
 * Decompiled with CFR 0.152.
 */
package de.uib.opsidatamodel.productstate;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class ActionResult {
    public static final String KEY = "actionResult";
    public static final int CONFLICT = -4;
    public static final int INVALID = -2;
    public static final int NOT_AVAILABLE = -6;
    public static final int NONE = 0;
    public static final int FAILED = 2;
    public static final int SUCCESSFUL = 4;
    private static Map<Integer, String> state2label;
    private static Map<String, Integer> label2state;
    private static Map<String, String> label2displayLabel;
    private static Map<String, String> displayLabel2label;
    private static Vector<Integer> states;
    private static Vector<String> labels;
    private static String[] choiceLabels;
    private int state = -2;

    private static void checkCollections() {
        if (states != null) {
            return;
        }
        states = new Vector();
        states.add(-4);
        states.add(-2);
        states.add(-6);
        states.add(0);
        states.add(2);
        states.add(4);
        labels = new Vector();
        labels.add("mixed");
        labels.add("");
        labels.add("not_available");
        labels.add("none");
        labels.add("failed");
        labels.add("successful");
        state2label = new HashMap<Integer, String>();
        state2label.put(-4, "mixed");
        state2label.put(-2, "");
        state2label.put(-6, "not_available");
        state2label.put(0, "none");
        state2label.put(2, "failed");
        state2label.put(4, "successful");
        label2state = new HashMap<String, Integer>();
        label2state.put("mixed", -4);
        label2state.put("", -2);
        label2state.put("not_available", -6);
        label2state.put("none", 0);
        label2state.put("failed", 2);
        label2state.put("successful", 4);
        label2displayLabel = new HashMap<String, String>();
        label2displayLabel.put("mixed", "mixed");
        label2displayLabel.put("", "");
        label2displayLabel.put("not_available", "not_available");
        label2displayLabel.put("none", "none");
        label2displayLabel.put("failed", "failed");
        label2displayLabel.put("successful", "success");
        displayLabel2label = new HashMap<String, String>();
        displayLabel2label.put("mixed", "mixed");
        displayLabel2label.put("", "");
        displayLabel2label.put("not_available", "not_available");
        displayLabel2label.put("none", "none");
        displayLabel2label.put("always", "always");
        displayLabel2label.put("failed", "failed");
        displayLabel2label.put("success", "successful");
        choiceLabels = new String[]{label2displayLabel.get("none")};
    }

    public static Map<String, String> getLabel2DisplayLabel() {
        ActionResult.checkCollections();
        return label2displayLabel;
    }

    public static boolean existsState(int n) {
        ActionResult.checkCollections();
        return states.contains(n);
    }

    public static boolean existsLabel(String string) {
        ActionResult.checkCollections();
        return labels.contains(string);
    }

    public static String getLabel(int n) {
        ActionResult.checkCollections();
        if (!ActionResult.existsState(n)) {
            return null;
        }
        return state2label.get(n);
    }

    public static Vector<String> getLabels() {
        ActionResult.checkCollections();
        return labels;
    }

    public static Integer getVal(String string) {
        ActionResult.checkCollections();
        if (string == null || string.equals("")) {
            return 0;
        }
        if (!ActionResult.existsLabel(string)) {
            return null;
        }
        return label2state.get(string);
    }

    public static String getDisplayLabel(int n) {
        ActionResult.checkCollections();
        return label2displayLabel.get(ActionResult.getLabel(n));
    }

    public int getVal() {
        return this.state;
    }

    public String getString() {
        return ActionResult.getLabel(this.state);
    }

    public String toString() {
        return ActionResult.getLabel(this.state);
    }

    public static ActionResult produceFromDisplayLabel(String string) {
        return ActionResult.produceFromLabel(displayLabel2label.get(string));
    }

    public static ActionResult produceFromLabel(String string) {
        ActionResult.checkCollections();
        if (string == null) {
            return new ActionResult(-6);
        }
        if (!labels.contains(string)) {
            return new ActionResult(-2);
        }
        return new ActionResult(ActionResult.getVal(string));
    }

    public ActionResult() {
    }

    public ActionResult(int n) {
        this.state = ActionResult.existsState(n) ? n : -6;
    }

    public static void main(String[] stringArray) {
        System.out.println(" test ActionResult.java");
        ActionResult.checkCollections();
        Iterator<Integer> iterator = states.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ++n;
            int n2 = iterator.next();
        }
    }
}

