/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.clientselection;

import de.uib.configed.clientselection.Backend;
import de.uib.configed.clientselection.ExecutableOperation;
import de.uib.configed.clientselection.SelectElement;
import de.uib.configed.clientselection.SelectGroupOperation;
import de.uib.configed.clientselection.SelectOperation;
import de.uib.configed.clientselection.Serializer;
import de.uib.configed.clientselection.backends.opsidatamodel.OpsiDataBackend;
import de.uib.configed.clientselection.elements.SoftwareNameElement;
import de.uib.configed.clientselection.operations.AndOperation;
import de.uib.configed.clientselection.operations.HardwareOperation;
import de.uib.configed.clientselection.operations.HostOperation;
import de.uib.configed.clientselection.operations.NotOperation;
import de.uib.configed.clientselection.operations.OrOperation;
import de.uib.configed.clientselection.operations.SoftwareOperation;
import de.uib.configed.clientselection.operations.SwAuditOperation;
import de.uib.configed.clientselection.serializers.OpsiDataSerializer;
import de.uib.opsidatamodel.SavedSearches;
import de.uib.utilities.logging.logging;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SelectionManager {
    private List<SelectElement> elements;
    private List<OperationWithStatus> groupWithStatusList;
    private boolean hasSoftware = false;
    private boolean hasHardware = false;
    private boolean hasSwAudit = false;
    private boolean isSerializedLoaded = false;
    private SelectOperation loadedSearch = null;
    private Backend backend;
    private Serializer serializer;

    public SelectionManager(String string) {
        if (string == null || string.isEmpty()) {
            string = "opsidata";
        }
        this.backend = string.equals("database") ? OpsiDataBackend.getInstance() : OpsiDataBackend.getInstance();
        this.serializer = new OpsiDataSerializer(this);
        this.groupWithStatusList = new LinkedList<OperationWithStatus>();
    }

    public SoftwareNameElement getNewSoftwareNameElement() {
        return new SoftwareNameElement(this.backend.getProductIDs());
    }

    public Map<String, List<SelectElement>> getHardwareList() {
        return this.backend.getHardwareList();
    }

    public Map<String, List<SelectElement>> getLocalizedHardwareList() {
        return this.backend.getLocalizedHardwareList();
    }

    public Backend getBackend() {
        return this.backend;
    }

    public void setChanged() {
        this.isSerializedLoaded = false;
    }

    public void addGroupOperation(String string, OperationWithStatus operationWithStatus, List<OperationWithStatus> list) {
        logging.debug(this, "Adding group operation " + string + " with " + list.toString());
        LinkedList<SelectOperation> linkedList = new LinkedList<SelectOperation>();
        linkedList.add(this.build(list, new int[]{0}));
        logging.debug(this, "addGroupOperation: " + string + " " + linkedList.size() + " " + linkedList.get(0));
        if (string.equals("Software")) {
            operationWithStatus.operation = new SoftwareOperation(linkedList);
        } else if (string.equals("Hardware")) {
            operationWithStatus.operation = new HardwareOperation(linkedList);
        } else if (string.equals("SwAudit")) {
            operationWithStatus.operation = new SwAuditOperation(linkedList);
        } else if (string.equals("Host")) {
            operationWithStatus.operation = new HostOperation(linkedList);
        } else {
            throw new IllegalArgumentException(string + " is no valid group operation.");
        }
        this.groupWithStatusList.add(operationWithStatus);
        if (string.equals("Software")) {
            this.hasSoftware = true;
        }
        if (string.equals("Hardware")) {
            this.hasHardware = true;
        }
        if (string.equals("SwAudit")) {
            this.hasSwAudit = true;
        }
    }

    public List<OperationWithStatus> operationsAsList(SelectOperation selectOperation) {
        List<Object> list = new LinkedList();
        list = selectOperation == null ? this.groupWithStatusList : this.reverseBuild(selectOperation, true);
        return list;
    }

    public void clearOperations() {
        this.groupWithStatusList.clear();
        this.hasSoftware = false;
        this.hasHardware = false;
        this.hasSwAudit = false;
        this.isSerializedLoaded = false;
    }

    public SelectOperation getTopOperation() {
        if (this.isSerializedLoaded) {
            return this.loadedSearch;
        }
        return this.build(this.groupWithStatusList, new int[]{0});
    }

    public List<String> selectClients() {
        SelectOperation selectOperation = this.getTopOperation();
        if (selectOperation == null) {
            logging.info(this, "Nothing selected");
            return null;
        }
        logging.info("\n" + selectOperation.printOperation(""));
        ExecutableOperation executableOperation = this.backend.createExecutableOperation(selectOperation);
        logging.info(this, "selectClients, operation " + selectOperation.getClassName());
        logging.info(this, "" + ((SelectGroupOperation)selectOperation).getChildOperations().size());
        return this.backend.checkClients(executableOperation, this.hasSoftware, this.hasHardware, this.hasSwAudit);
    }

    public void saveSearch(String string) {
        this.saveSearch(string, "");
    }

    public void saveSearch(String string, String string2) {
        logging.debug(this, "saveSearch " + string);
        SelectOperation selectOperation = this.getTopOperation();
        if (selectOperation == null) {
            logging.debug(this, "Nothing selected");
        } else {
            this.serializer.save(selectOperation, string, string2);
        }
    }

    public List<String> getSavedSearchesNames() {
        return this.serializer.getSaved();
    }

    public SavedSearches getSavedSearches() {
        return this.serializer.getSavedSearches();
    }

    private void setSearch(SelectOperation selectOperation) {
        this.loadedSearch = selectOperation;
        this.isSerializedLoaded = true;
        this.checkForGroupSearches(this.getTopOperation());
        this.groupWithStatusList = this.reverseBuild(this.getTopOperation(), true);
    }

    public void setSearch(String string) {
        logging.debug(this, "setSearch " + string);
        this.clearOperations();
        this.setSearch(this.serializer.deserialize(string));
    }

    public void loadSearch(String string) {
        logging.info(this, "loadSearch " + string);
        this.clearOperations();
        if (string == null || string.isEmpty()) {
            this.isSerializedLoaded = false;
            return;
        }
        logging.info(this, "setSearch " + string);
        this.setSearch(this.serializer.load(string));
    }

    public void removeSearch(String string) {
        this.serializer.remove(string);
    }

    private SelectOperation build(List<OperationWithStatus> list, int[] nArray) {
        logging.debug(this, "build counter: " + nArray[0]);
        logging.debug(this, "input size: " + list.size());
        if (list.isEmpty()) {
            return null;
        }
        LinkedList<SelectOperation> linkedList = new LinkedList<SelectOperation>();
        LinkedList<SelectOperation> linkedList2 = new LinkedList<SelectOperation>();
        boolean bl = false;
        while (nArray[0] < list.size()) {
            OperationWithStatus operationWithStatus = list.get(nArray[0]);
            logging.debug("Position: " + nArray[0]);
            logging.debug("currentInput: " + operationWithStatus.operation + (Object)((Object)operationWithStatus.status) + operationWithStatus.parenthesisOpen + operationWithStatus.parenthesisClose);
            if (operationWithStatus.parenthesisOpen) {
                operationWithStatus.parenthesisOpen = false;
                SelectOperation selectOperation = this.build(list, nArray);
                logging.debug("\n" + selectOperation.printOperation(""));
                nArray[0] = nArray[0] - 1;
                operationWithStatus = list.get(nArray[0]);
                operationWithStatus.operation = selectOperation;
            }
            if (operationWithStatus.status == ConnectionStatus.Or || operationWithStatus.status == ConnectionStatus.OrNot) {
                if (!bl) {
                    linkedList.add(this.parseNot(operationWithStatus));
                } else {
                    linkedList2.add(this.parseNot(operationWithStatus));
                    linkedList.add(new AndOperation(linkedList2));
                    linkedList2.clear();
                }
                bl = false;
            } else {
                linkedList2.add(this.parseNot(operationWithStatus));
                bl = true;
            }
            nArray[0] = nArray[0] + 1;
            if (!operationWithStatus.parenthesisClose) continue;
            operationWithStatus.parenthesisClose = false;
            break;
        }
        logging.debug(this, "After break: " + nArray[0]);
        if (linkedList2.size() == 1) {
            linkedList.add((SelectOperation)linkedList2.get(0));
        } else if (!linkedList2.isEmpty()) {
            linkedList.add(new AndOperation(linkedList2));
        }
        if (linkedList.size() == 1) {
            return (SelectOperation)linkedList.get(0);
        }
        return new OrOperation(linkedList);
    }

    private List<OperationWithStatus> reverseBuild(SelectOperation selectOperation, boolean bl) {
        LinkedList<OperationWithStatus> linkedList = new LinkedList<OperationWithStatus>();
        if (selectOperation instanceof AndOperation) {
            for (SelectOperation selectOperation2 : ((AndOperation)selectOperation).getChildOperations()) {
                linkedList.addAll(this.reverseBuild(selectOperation2, false));
            }
            if (!bl) {
                ((OperationWithStatus)linkedList.getFirst()).parenthesisOpen = true;
                linkedList.getLast().parenthesisClose = true;
            }
        } else if (selectOperation instanceof OrOperation && !((OrOperation)selectOperation).getChildOperations().isEmpty()) {
            for (SelectOperation selectOperation3 : ((OrOperation)selectOperation).getChildOperations()) {
                linkedList.addAll(this.reverseBuild(selectOperation3, false));
                if (linkedList.getLast().status == ConnectionStatus.And) {
                    linkedList.getLast().status = ConnectionStatus.Or;
                    continue;
                }
                linkedList.getLast().status = ConnectionStatus.OrNot;
            }
            linkedList.getLast().status = linkedList.getLast().status == ConnectionStatus.Or ? ConnectionStatus.And : ConnectionStatus.AndNot;
            if (!bl) {
                linkedList.getFirst().parenthesisOpen = true;
                linkedList.getLast().parenthesisClose = true;
            }
        } else {
            linkedList.add(this.reverseParseNot(selectOperation, ConnectionStatus.And));
            linkedList.getLast().parenthesisOpen = false;
            linkedList.getLast().parenthesisClose = false;
        }
        return linkedList;
    }

    private SelectOperation parseNot(OperationWithStatus operationWithStatus) {
        if (operationWithStatus.status == ConnectionStatus.And || operationWithStatus.status == ConnectionStatus.Or) {
            return operationWithStatus.operation;
        }
        LinkedList<SelectOperation> linkedList = new LinkedList<SelectOperation>();
        linkedList.add(operationWithStatus.operation);
        return new NotOperation(linkedList);
    }

    private OperationWithStatus reverseParseNot(SelectOperation selectOperation, ConnectionStatus connectionStatus) {
        OperationWithStatus operationWithStatus = new OperationWithStatus();
        if (selectOperation instanceof NotOperation) {
            operationWithStatus.operation = ((NotOperation)selectOperation).getChildOperations().get(0);
            operationWithStatus.status = connectionStatus == ConnectionStatus.And ? ConnectionStatus.AndNot : ConnectionStatus.OrNot;
        } else {
            operationWithStatus.operation = selectOperation;
            operationWithStatus.status = connectionStatus;
        }
        return operationWithStatus;
    }

    private void checkForGroupSearches(SelectOperation selectOperation) {
        if (this.hasHardware && this.hasSoftware && this.hasSwAudit) {
            return;
        }
        if (selectOperation instanceof SoftwareOperation) {
            this.hasSoftware = true;
        } else if (selectOperation instanceof HardwareOperation) {
            this.hasHardware = true;
        } else if (selectOperation instanceof SwAuditOperation) {
            this.hasSwAudit = true;
        }
        if (selectOperation instanceof SelectGroupOperation) {
            for (SelectOperation selectOperation2 : ((SelectGroupOperation)selectOperation).getChildOperations()) {
                this.checkForGroupSearches(selectOperation2);
            }
        }
    }

    public static class OperationWithStatus {
        public SelectOperation operation;
        public ConnectionStatus status;
        public boolean parenthesisOpen;
        public boolean parenthesisClose;
    }

    public static enum ConnectionStatus {
        And,
        Or,
        AndNot,
        OrNot;

    }
}

