/*
 * Decompiled with CFR 0.152.
 */
package de.uib.configed.productgroup;

import de.uib.configed.ConfigedMain;
import de.uib.configed.Globals;
import de.uib.configed.configed;
import de.uib.configed.gui.IconButton;
import de.uib.configed.gui.productpage.PanelGroupedProductSettings;
import de.uib.configed.productgroup.MapOfProductGroups;
import de.uib.configed.productgroup.TreeSetBuddy;
import de.uib.utilities.logging.logging;
import de.uib.utilities.swing.JComboBoxToolTip;
import de.uib.utilities.table.gui.SearchPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GroupPanel
extends JPanel
implements ListSelectionListener,
ActionListener,
ItemListener {
    JComboBoxToolTip groupsCombo;
    protected SearchPane searchPane;
    protected JTable tableProducts;
    JTextField saveNameEditor;
    protected IconButton buttonCommit;
    protected IconButton buttonCancel;
    protected IconButton buttonFilter;
    protected IconButton buttonEditDialog;
    protected IconButton buttonDelete;
    protected JLabel labelSave;
    static final String NO_GROUP_ID = configed.getResourceValue("GroupPanel.NO_GROUP_ID");
    static final String SAVE_GROUP_ID = configed.getResourceValue("GroupPanel.SAVE_GROUP_ID");
    static final String NO_GROUP_DESCRIPTION = configed.getResourceValue("GroupPanel.NO_GROUP_DESCRIPTION");
    static final String EMPTIED_GROUPID = "";
    static final String TEXT_SAVE = configed.getResourceValue("GroupPanel.TEXT_SAVE");
    static final String TEXT_DELETE = configed.getResourceValue("GroupPanel.TEXT_DELETE");
    protected Map<String, Map<String, String>> theData;
    PanelGroupedProductSettings associate;
    JPanel panelEdit;
    protected Set<String> selectedIDs;
    protected DefaultComboBoxModel comboModel;
    protected LinkedHashMap<String, String> namesAndDescriptions;
    protected LinkedHashMap<String, String> namesAndDescriptionsSave;
    protected MapOfProductGroups productGroupMembers;
    protected int editIndex;
    protected String showKey;
    protected String editedKey;
    protected JTextField groupsEditField;
    protected JTextField descriptionField;
    protected boolean dataChanged = false;
    protected boolean groupEditing = false;
    protected boolean deleted = false;
    private final int minFieldWidth = 30;
    private final int maxComboWidth = 200;
    MyDocumentListener descriptionFieldListener;
    MyDocumentListener groupsEditFieldListener;
    protected ConfigedMain mainController;

    public GroupPanel(PanelGroupedProductSettings panelGroupedProductSettings, ConfigedMain configedMain, JTable jTable) {
        this.associate = panelGroupedProductSettings;
        this.mainController = configedMain;
        this.tableProducts = jTable;
        this.initData();
        this.initComponents();
    }

    public void setSearchFields(List<String> list) {
        this.searchPane.setSearchFields(list);
    }

    public void markAllSearchResults() {
        this.searchPane.markAll();
    }

    public void setGuiIsFiltered(boolean bl) {
        logging.debug(this, "setGuiIsFiltered " + bl);
        this.buttonFilter.setActivated(!bl);
    }

    public boolean getGuiIsFiltered() {
        return !this.buttonFilter.isActivated();
    }

    protected void enterExistingGroup() {
        logging.debug(this, "enterExistingGroup");
        this.saveNameEditorShallFollow();
        if (this.getGuiIsFiltered()) {
            this.setGuiIsFiltered(false);
            this.associate.noSelection();
        }
        this.setMembers();
        this.setDataChanged(false);
        this.setDeleted(false);
        this.isDeleteLegal();
    }

    protected void enterEditGroup() {
        this.descriptionFieldListener.setEnabled(false);
        String string = this.groupsEditField.getText();
        if (this.namesAndDescriptionsSave.get(string) != null) {
            this.descriptionField.setText(this.namesAndDescriptionsSave.get(string));
        }
        this.descriptionFieldListener.setEnabled(true);
        if (!string.equals(SAVE_GROUP_ID) && !string.equals((String)this.groupsCombo.getSelectedItem())) {
            this.setDataChanged(true);
        }
        this.isSaveLegal();
        this.isDeleteLegal();
    }

    private boolean membersChanged() {
        if (this.productGroupMembers == null || this.saveNameEditor == null) {
            return false;
        }
        this.selectedIDs = this.associate.getSelectedIDs();
        String string = this.saveNameEditor.getText();
        if (string == null || string.equals(EMPTIED_GROUPID)) {
            return false;
        }
        boolean bl = false;
        if (this.namesAndDescriptions.get(string) != null) {
            if (this.productGroupMembers.get(string) == null || ((Set)this.productGroupMembers.get(string)).size() == 0) {
                if (this.selectedIDs.size() > 0) {
                    bl = true;
                }
            } else if (!((TreeSetBuddy)this.productGroupMembers.get(string)).equals(this.selectedIDs)) {
                bl = true;
            }
        } else if (this.selectedIDs.size() > 0) {
            bl = true;
        }
        return bl;
    }

    private void setItemWithoutListener(String string) {
        this.groupsCombo.removeItemListener(this);
        this.groupsCombo.setSelectedItem(string);
        this.groupsCombo.addItemListener(this);
        this.isDeleteLegal();
    }

    public void findGroup(Set<String> set) {
        Iterator<String> iterator = this.namesAndDescriptions.keySet().iterator();
        boolean bl = false;
        if (set != null) {
            TreeSetBuddy treeSetBuddy = new TreeSetBuddy((Collection<String>)set);
            while (!bl && iterator.hasNext()) {
                String string = iterator.next();
                if (this.productGroupMembers.get(string) == null || !((TreeSetBuddy)this.productGroupMembers.get(string)).equals(treeSetBuddy)) continue;
                this.setItemWithoutListener(string);
                bl = true;
            }
        }
        if (!bl) {
            this.setItemWithoutListener(NO_GROUP_ID);
        }
    }

    private void updateAssociations() {
        if (this.membersChanged()) {
            this.setDataChanged(true);
        }
        if (this.namesAndDescriptions == null) {
            return;
        }
        this.isSaveLegal();
        this.findGroup(this.associate.getSelectedIDs());
    }

    private boolean isDescriptionChanged() {
        boolean bl = false;
        String string = this.saveNameEditor.getText();
        if (this.namesAndDescriptions.get(string) == null) {
            bl = true;
        } else {
            String string2 = this.namesAndDescriptions.get(string);
            if (!string2.equals(this.descriptionField.getText())) {
                bl = true;
            }
        }
        return bl;
    }

    protected void updateDescription() {
        if (this.isDescriptionChanged()) {
            this.setDataChanged(true);
        }
    }

    protected void updateKey() {
    }

    protected void initData() {
        this.searchPane = new SearchPane(this.tableProducts, true);
        this.groupsCombo = new JComboBoxToolTip();
        this.groupsCombo.setEditable(false);
        this.groupsCombo.setMaximumRowCount(30);
        this.saveNameEditor = new JTextField(EMPTIED_GROUPID);
        this.saveNameEditor.setEditable(true);
        this.saveNameEditor.setToolTipText(configed.getResourceValue("GroupPanel.GroupnameTooltip"));
        this.setMembers();
        this.setGroupEditing(false);
    }

    protected void initComponents() {
        this.buttonCommit = new IconButton(configed.getResourceValue("GroupPanel.SaveButtonTooltip"), "images/apply.png", "images/apply_over.png", "images/apply_disabled.png", true);
        this.buttonCommit.addActionListener(this);
        this.buttonCommit.setPreferredSize(de.uib.utilities.Globals.newSmallButton);
        this.buttonCancel = new IconButton(configed.getResourceValue("GroupPanel.CancelButtonTooltip"), "images/cancel.png", "images/cancel_over.png", "images/cancel_disabled.png");
        this.buttonCancel.addActionListener(this);
        this.buttonCancel.setPreferredSize(de.uib.utilities.Globals.newSmallButton);
        this.buttonDelete = new IconButton(configed.getResourceValue("GroupPanel.DeleteButtonTooltip"), "images/edit-delete.png", "images/edit-delete_over.png", "images/edit-delete_disabled.png");
        this.buttonDelete.addActionListener(this);
        this.buttonDelete.setPreferredSize(de.uib.utilities.Globals.newSmallButton);
        this.buttonFilter = new IconButton(configed.getResourceValue("GroupPanel.FilterButtonTooltip"), "images/view-filter_disabled-32.png", "images/view-filter_over-32.png", " ", true);
        this.buttonFilter.setToolTips(configed.getResourceValue("GroupPanel.FilterButtonTooltipActive"), configed.getResourceValue("GroupPanel.FilterButtonTooltipInactive"));
        this.buttonFilter.addActionListener(this);
        this.buttonFilter.setPreferredSize(de.uib.utilities.Globals.newSmallButton);
        this.buttonEditDialog = new IconButton(configed.getResourceValue("GroupPanel.EditButtonTooltip"), "images/packagegroup_save.png", "images/packagegroup_save_over.png", "images/packagegroup_save_disabled.png");
        this.buttonEditDialog.setToolTips(configed.getResourceValue("GroupPanel.EditButtonTooltipInactive"), configed.getResourceValue("GroupPanel.EditButtonTooltipActive"));
        this.buttonEditDialog.addActionListener(this);
        this.buttonEditDialog.setPreferredSize(de.uib.utilities.Globals.newSmallButton);
        JLabel jLabel = new JLabel(configed.getResourceValue("GroupPanel.selectgroup.label"));
        jLabel.setFont(de.uib.utilities.Globals.defaultFont);
        this.groupsEditField = this.saveNameEditor;
        this.groupsEditField.getCaret().setBlinkRate(0);
        this.groupsEditField.setBackground(Globals.backgroundLightGrey);
        this.groupsEditFieldListener = new MyDocumentListener(){

            @Override
            public void doAction() {
                GroupPanel.this.enterEditGroup();
            }
        };
        this.groupsEditField.getDocument().addDocumentListener(this.groupsEditFieldListener);
        this.groupsCombo.addItemListener(this);
        this.groupsEditField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                logging.debug(this, "focus gained on groupsEditField, groupediting");
                GroupPanel.this.setGroupEditing(true);
            }
        });
        this.groupsCombo.setPreferredSize(Globals.buttonDimension);
        this.saveNameEditor.setPreferredSize(Globals.buttonDimension);
        this.groupsEditField.setBackground(Globals.backgroundLightGrey);
        this.labelSave = new JLabel();
        this.labelSave.setText(TEXT_SAVE);
        this.labelSave.setFont(Globals.defaultFontStandardBold);
        this.descriptionField = new JTextField(EMPTIED_GROUPID);
        this.descriptionField.setPreferredSize(Globals.buttonDimension);
        this.descriptionField.setFont(Globals.defaultFont);
        this.descriptionField.setBackground(Globals.backgroundLightGrey);
        this.descriptionField.getCaret().setBlinkRate(0);
        this.descriptionFieldListener = new MyDocumentListener(){

            @Override
            public void doAction() {
                logging.debug(this, "description changed, setgroupediting");
                GroupPanel.this.updateDescription();
            }
        };
        this.descriptionField.getDocument().addDocumentListener(this.descriptionFieldListener);
        this.panelEdit = new JPanel();
        this.panelEdit.setBackground(Globals.backgroundWhite);
        GroupLayout groupLayout = new GroupLayout(this.panelEdit);
        this.panelEdit.setLayout(groupLayout);
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGap(5, 5, 5).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelSave, -2, -2, -2)).addGap(1, 1, 2).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.saveNameEditor, -2, -2, -2).addComponent(this.descriptionField, -2, -2, -2).addComponent(this.buttonDelete, -2, -2, -2).addComponent(this.buttonCommit, -2, -2, -2).addComponent(this.buttonCancel, -2, -2, -2)).addGap(5, 5, 5));
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.labelSave, -2, -2, -2)).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.saveNameEditor, -2, -2, 200).addGap(2, 2, 5).addComponent(this.descriptionField, 30, -2, Short.MAX_VALUE).addGap(5, 5, 10).addComponent(this.buttonDelete, -2, -2, -2).addGap(2, 2, 5).addComponent(this.buttonCommit, -2, -2, -2).addGap(2, 2, 5).addComponent(this.buttonCancel, -2, -2, -2).addGap(10, 10, 10)));
        this.setGroupEditing(false);
        this.panelEdit.setBorder(Globals.createPanelBorder());
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setVerticalGroup(groupLayout2.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.searchPane, -2, -2, -2)).addGap(10, 10, 10).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel, -2, -2, -2).addComponent(this.groupsCombo, -2, -2, -2).addComponent(this.buttonFilter, -2, -2, -2).addComponent(this.buttonEditDialog, -2, -2, -2)).addGap(5, 5, 5).addComponent(this.panelEdit, -2, -2, -2));
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.searchPane, -2, -2, Short.MAX_VALUE)).addGroup(groupLayout2.createSequentialGroup().addGap(10, 10, 10).addComponent(this.buttonFilter, -2, -2, -2).addGap(10, 10, Short.MAX_VALUE).addComponent(jLabel, -2, -2, -2).addGap(5, 5, 10).addComponent(this.groupsCombo, -2, -2, 200).addGap(5, 5, 10).addComponent(this.buttonEditDialog, -2, -2, -2).addGap(10, 10, 10)).addComponent(this.panelEdit, 80, -2, Short.MAX_VALUE));
    }

    protected boolean save() {
        boolean bl = false;
        if (this.deleted) {
            String string = this.groupsEditField.getText();
            this.theData.remove(string);
            if (this.mainController.deleteGroup(string)) {
                bl = true;
                this.setInternalGroupsData();
            }
        } else {
            String string = this.groupsEditField.getText();
            String string2 = this.descriptionField.getText();
            Set<String> set = this.associate.getSelectedIDs();
            logging.debug(this, "save: set groupname, description, assigned_products " + string + ", " + string2 + ", " + set);
            if (this.mainController.setProductGroup(string, string2, set)) {
                bl = true;
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("description", string2);
                this.theData.put(string, hashMap);
                this.productGroupMembers.put(string, new TreeSetBuddy((Collection<String>)set));
                this.setInternalGroupsData();
            }
        }
        return bl;
    }

    protected void setMembers() {
        if (this.productGroupMembers == null || this.groupsCombo == null) {
            this.associate.clearSelection();
            return;
        }
        logging.debug(this, "group members " + this.productGroupMembers.get((String)this.groupsCombo.getSelectedItem()));
        this.associate.setSelection((Set)this.productGroupMembers.get((String)this.groupsCombo.getSelectedItem()));
    }

    protected void setInternalGroupsData() {
        this.namesAndDescriptionsSave = new LinkedHashMap();
        this.namesAndDescriptionsSave.put(SAVE_GROUP_ID, NO_GROUP_DESCRIPTION);
        for (String string : new TreeSet<String>(this.theData.keySet())) {
            this.namesAndDescriptionsSave.put(string, this.theData.get(string).get("description"));
        }
        this.namesAndDescriptions = new LinkedHashMap();
        this.namesAndDescriptions.put(NO_GROUP_ID, EMPTIED_GROUPID);
        for (String string : new TreeSet<String>(this.theData.keySet())) {
            this.namesAndDescriptions.put(string, this.theData.get(string).get("description"));
        }
        this.groupsCombo.setValues(this.namesAndDescriptions);
        this.comboModel = (DefaultComboBoxModel)this.groupsCombo.getModel();
        this.clearChanges();
    }

    public void setGroupsData(Map<String, Map<String, String>> map, Map<String, Set<String>> map2) {
        logging.debug(this, "setGroupsData " + map);
        this.setGroupEditing(false);
        this.productGroupMembers = new MapOfProductGroups(map2);
        this.theData = map != null ? map : new HashMap<String, Map<String, String>>();
        this.setInternalGroupsData();
        this.setGuiIsFiltered(false);
    }

    private void setGroupEditing(boolean bl) {
        this.groupEditing = bl;
        if (this.panelEdit != null) {
            this.panelEdit.setVisible(bl);
            this.buttonEditDialog.setActivated(!bl);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.buttonCommit) {
            this.commit();
        } else if (actionEvent.getSource() == this.buttonCancel) {
            this.cancel();
        } else if (actionEvent.getSource() == this.buttonDelete) {
            this.setDeleted(true);
            this.setDataChanged(true);
        } else if (actionEvent.getSource() == this.buttonEditDialog) {
            this.setGroupEditing(!this.panelEdit.isVisible());
        } else if (actionEvent.getSource() == this.buttonFilter) {
            if (!this.getGuiIsFiltered()) {
                logging.debug(this, "associate.reduceToSelected()");
                this.associate.reduceToSelected();
                this.setGuiIsFiltered(true);
                this.buttonFilter.setNewImage("images/view-filter_over-32.png", "images/view-filter_disabled-32.png");
            } else {
                this.setGuiIsFiltered(false);
                logging.debug(this, "associate.showAll()");
                this.associate.showAll();
                this.buttonFilter.setNewImage("images/view-filter_disabled-32.png", "images/view-filter_over-32.png");
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.updateAssociations();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            if (itemEvent.getSource() == this.groupsCombo) {
                this.enterExistingGroup();
            } else if (itemEvent.getSource() == this.saveNameEditor) {
                this.enterEditGroup();
            }
        }
    }

    private void saveNameEditorShallFollow() {
        int n = this.groupsCombo.getSelectedIndex();
        if (n == 0 || n == -1) {
            this.saveNameEditor.setText(SAVE_GROUP_ID);
        } else {
            this.saveNameEditor.setText(EMPTIED_GROUPID + this.groupsCombo.getSelectedItem());
        }
    }

    private void clearChanges() {
        if (this.saveNameEditor != null) {
            this.saveNameEditorShallFollow();
        }
        this.setDataChanged(false);
        this.setDeleted(false);
        if (this.buttonDelete != null) {
            this.buttonDelete.setEnabled(false);
        }
        this.setMembers();
    }

    public void setDataChanged(boolean bl) {
        this.dataChanged = bl;
        if (this.buttonCommit != null) {
            this.buttonCommit.setEnabled(bl);
        }
        if (this.buttonCancel != null) {
            this.buttonCancel.setEnabled(bl);
        }
    }

    protected boolean isSaveLegal() {
        String string = this.groupsEditField.getText();
        boolean bl = true;
        if (string == null) {
            bl = false;
        }
        if (bl) {
            boolean bl2 = string.equals(SAVE_GROUP_ID) || string.equals(EMPTIED_GROUPID);
            bl = !bl2;
        }
        this.buttonCommit.setEnabled(bl);
        return bl;
    }

    protected boolean isDeleteLegal() {
        boolean bl = false;
        if (this.groupsCombo != null) {
            bl = this.groupsCombo.getSelectedIndex() > 0;
        }
        this.buttonDelete.setEnabled(bl);
        return bl;
    }

    protected void setDeleted(boolean bl) {
        if (this.saveNameEditor != null && this.descriptionField != null) {
            this.saveNameEditor.setEnabled(!bl);
            this.saveNameEditor.setEditable(!bl);
            this.descriptionField.setEnabled(!bl);
            this.descriptionField.setEditable(!bl);
            this.buttonDelete.setEnabled(!bl);
            if (bl) {
                this.labelSave.setText(TEXT_DELETE);
            } else {
                this.labelSave.setText(TEXT_SAVE);
            }
            this.deleted = bl;
        }
    }

    public void commit() {
        logging.debug(this, "commit");
        String string = this.groupsEditField.getText();
        if (this.save()) {
            this.clearChanges();
            this.groupsCombo.setSelectedItem(string);
            this.enterExistingGroup();
        }
    }

    public void cancel() {
        this.clearChanges();
    }

    abstract class MyDocumentListener
    implements DocumentListener {
        protected boolean enabled = true;

        MyDocumentListener() {
        }

        public abstract void doAction();

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            if (this.enabled) {
                this.doAction();
            }
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            if (this.enabled) {
                this.doAction();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            if (this.enabled) {
                this.doAction();
            }
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }
    }

    class JComboBoxToolTipX
    extends JComboBoxToolTip {
        JComboBoxToolTipX() {
        }

        @Override
        public void fireActionEvent() {
            super.fireActionEvent();
        }
    }
}

